/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.weakening;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class SyntacticWeakeningManager {
    private final FormulaManagerView fmgr;

    public SyntacticWeakeningManager(FormulaManagerView pFmgr) {
        this.fmgr = pFmgr;
    }

    public Set<BooleanFormula> performWeakening(SSAMap pFromSSA, Map<BooleanFormula, BooleanFormula> selectionInfo, SSAMap pToSSA, Set<BooleanFormula> pFromStateLemmas) {
        HashSet<BooleanFormula> out = new HashSet<BooleanFormula>();
        for (Map.Entry<BooleanFormula, BooleanFormula> e : selectionInfo.entrySet()) {
            BooleanFormula selector = e.getKey();
            BooleanFormula lemma = e.getValue();
            BooleanFormula instantiatedFrom = this.fmgr.instantiate(lemma, pFromSSA);
            BooleanFormula instantiatedTo = this.fmgr.instantiate(lemma, pToSSA);
            if (pFromStateLemmas.contains(lemma) && instantiatedFrom.equals(instantiatedTo)) continue;
            out.add(selector);
        }
        return out;
    }
}

