/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.weakening;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.weakening.CEXWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;

@Options(prefix="cpa.slicing")
public class WeakeningOptions {
    @Option(description="Inductive weakening strategy", secure=true)
    private InductiveWeakeningManager.WEAKENING_STRATEGY weakeningStrategy = InductiveWeakeningManager.WEAKENING_STRATEGY.CEX;
    @Option(secure=true, description="Pre-run syntactic weakening")
    private boolean preRunSyntacticWeakening = true;
    @Option(description="Strategy for abstracting children during CEX weakening", secure=true)
    private CEXWeakeningManager.SELECTION_STRATEGY removalSelectionStrategy = CEXWeakeningManager.SELECTION_STRATEGY.ALL;
    @Option(description="Depth limit for the 'LEAST_REMOVALS' strategy.")
    private int leastRemovalsDepthLimit = 2;

    public WeakeningOptions(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    InductiveWeakeningManager.WEAKENING_STRATEGY getWeakeningStrategy() {
        return this.weakeningStrategy;
    }

    boolean doPreRunSyntacticWeakening() {
        return this.preRunSyntacticWeakening;
    }

    CEXWeakeningManager.SELECTION_STRATEGY getRemovalSelectionStrategy() {
        return this.removalSelectionStrategy;
    }

    int getLeastRemovalsDepthLimit() {
        return this.leastRemovalsDepthLimit;
    }
}

