/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.reachingdef;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ReachingDefUtils {
    private static List<CFANode> cfaNodes;

    public static List<CFANode> getAllNodesFromCFA() {
        return cfaNodes;
    }

    public static Pair<Set<MemoryLocation>, Map<FunctionEntryNode, Set<MemoryLocation>>> getAllVariables(CFANode pMainNode) {
        ArrayList<MemoryLocation> globalVariables = new ArrayList<MemoryLocation>();
        ArrayList<CFANode> nodes = new ArrayList<CFANode>();
        assert (pMainNode instanceof FunctionEntryNode);
        HashMap<FunctionEntryNode, ImmutableSet> result = new HashMap<FunctionEntryNode, ImmutableSet>();
        HashSet<FunctionEntryNode> reachedFunctions = new HashSet<FunctionEntryNode>();
        ArrayDeque<FunctionEntryNode> functionsToProcess = new ArrayDeque<FunctionEntryNode>();
        ArrayDeque<CFANode> currentWaitlist = new ArrayDeque<CFANode>();
        HashSet<CFANode> seen = new HashSet<CFANode>();
        ArrayList<MemoryLocation> localVariables = new ArrayList<MemoryLocation>();
        reachedFunctions.add((FunctionEntryNode)pMainNode);
        functionsToProcess.add((FunctionEntryNode)pMainNode);
        while (!functionsToProcess.isEmpty()) {
            FunctionEntryNode currentFunction = (FunctionEntryNode)functionsToProcess.pop();
            currentWaitlist.clear();
            currentWaitlist.add(currentFunction);
            seen.clear();
            seen.add(currentFunction);
            localVariables.clear();
            Optional<? extends AVariableDeclaration> retVar = currentFunction.getReturnVariable();
            if (retVar.isPresent()) {
                localVariables.add(MemoryLocation.forDeclaration(retVar.get()));
            }
            while (!currentWaitlist.isEmpty()) {
                CFANode currentElement = (CFANode)currentWaitlist.pop();
                nodes.add(currentElement);
                for (CFAEdge out : CFAUtils.leavingEdges(currentElement)) {
                    if (out instanceof FunctionReturnEdge) continue;
                    if (out instanceof FunctionCallEdge) {
                        if (!reachedFunctions.contains(out.getSuccessor())) {
                            functionsToProcess.add((FunctionEntryNode)out.getSuccessor());
                            reachedFunctions.add((FunctionEntryNode)out.getSuccessor());
                        }
                        out = currentElement.getLeavingSummaryEdge();
                    }
                    if (out instanceof CDeclarationEdge) {
                        ReachingDefUtils.handleDeclaration((CDeclarationEdge)out, globalVariables, localVariables);
                    }
                    if (seen.contains(out.getSuccessor())) continue;
                    currentWaitlist.add(out.getSuccessor());
                    seen.add(out.getSuccessor());
                }
            }
            result.put(currentFunction, ImmutableSet.copyOf(localVariables));
        }
        cfaNodes = ImmutableList.copyOf(nodes);
        return Pair.of(ImmutableSet.copyOf(globalVariables), result);
    }

    private static void handleDeclaration(CDeclarationEdge out, List<MemoryLocation> globalVariables, List<MemoryLocation> localVariables) {
        if (out.getDeclaration() instanceof CVariableDeclaration) {
            if (out.getDeclaration().isGlobal()) {
                globalVariables.add(MemoryLocation.forDeclaration(out.getDeclaration()));
            } else {
                localVariables.add(MemoryLocation.forDeclaration(out.getDeclaration()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<MemoryLocation> possiblePointees(CExpression pExp, PointerState pPointerState) {
        Set<MemoryLocation> possibleOperands;
        if (pExp instanceof CPointerExpression) {
            possibleOperands = ReachingDefUtils.possiblePointees(((CPointerExpression)pExp).getOperand(), pPointerState);
        } else {
            if (pExp instanceof CIdExpression) {
                return Collections.singleton(MemoryLocation.forDeclaration(((CIdExpression)pExp).getDeclaration()));
            }
            if (pExp instanceof CFieldReference) {
                if (!((CFieldReference)pExp).isPointerDereference()) return ReachingDefUtils.possiblePointees(((CFieldReference)pExp).getFieldOwner(), pPointerState);
                possibleOperands = ReachingDefUtils.possiblePointees(((CFieldReference)pExp).getFieldOwner(), pPointerState);
            } else {
                if (pExp instanceof CArraySubscriptExpression) {
                    return ReachingDefUtils.possiblePointees(((CArraySubscriptExpression)pExp).getArrayExpression(), pPointerState);
                }
                if (!(pExp instanceof CCastExpression)) return null;
                return ReachingDefUtils.possiblePointees(((CCastExpression)pExp).getOperand(), pPointerState);
            }
        }
        if (possibleOperands == null) {
            return null;
        }
        HashSet<MemoryLocation> possiblePointees = new HashSet<MemoryLocation>();
        for (MemoryLocation possibleOp : possibleOperands) {
            LocationSet pointedTo = pPointerState.getPointsToSet(possibleOp);
            if (pointedTo == null || pointedTo.isTop()) {
                return null;
            }
            if (pointedTo.isBot()) {
                return ImmutableSet.of();
            }
            assert (pointedTo instanceof ExplicitLocationSet);
            ExplicitLocationSet pointees = (ExplicitLocationSet)pointedTo;
            Iterables.addAll(possiblePointees, (Iterable)pointees);
        }
        return possiblePointees;
    }

    public static class VariableExtractor
    extends DefaultCExpressionVisitor<MemoryLocation, UnsupportedCodeException> {
        private CFAEdge edgeForExpression;
        private String warning;

        public void resetWarning() {
            this.warning = null;
        }

        public String getWarning() {
            return this.warning;
        }

        public VariableExtractor(CFAEdge pEdgeForExpression) {
            this.edgeForExpression = pEdgeForExpression;
        }

        @Override
        protected MemoryLocation visitDefault(CExpression pExp) {
            return null;
        }

        @Override
        public MemoryLocation visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnsupportedCodeException {
            this.warning = "Analysis may be unsound in case of aliasing.";
            return pIastArraySubscriptExpression.getArrayExpression().accept(this);
        }

        @Override
        public MemoryLocation visit(CCastExpression pIastCastExpression) throws UnsupportedCodeException {
            return pIastCastExpression.getOperand().accept(this);
        }

        @Override
        public MemoryLocation visit(CComplexCastExpression pIastCastExpression) throws UnsupportedCodeException {
            return pIastCastExpression.getOperand().accept(this);
        }

        @Override
        public MemoryLocation visit(CFieldReference pIastFieldReference) throws UnsupportedCodeException {
            if (pIastFieldReference.isPointerDereference()) {
                throw new UnsupportedCodeException("Does not support assignment to dereferenced variable due to missing aliasing support", this.edgeForExpression, pIastFieldReference);
            }
            this.warning = "Analysis may be unsound in case of aliasing.";
            return pIastFieldReference.getFieldOwner().accept(this);
        }

        @Override
        public MemoryLocation visit(CIdExpression pIastIdExpression) {
            return MemoryLocation.forDeclaration(pIastIdExpression.getDeclaration());
        }

        @Override
        public MemoryLocation visit(CUnaryExpression pIastUnaryExpression) throws UnsupportedCodeException {
            return pIastUnaryExpression.getOperand().accept(this);
        }

        @Override
        public MemoryLocation visit(CPointerExpression pIastUnaryExpression) throws UnsupportedCodeException {
            throw new UnsupportedCodeException("Does not support assignment to dereferenced variable due to missing aliasing support", this.edgeForExpression, pIastUnaryExpression);
        }
    }
}

