/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public final class DelegatingARGBasedRefiner
implements ARGBasedRefiner,
StatisticsProvider {
    private final List<ARGBasedRefiner> refiners;
    private final List<StatCounter> totalRefinementsSelected;
    private final List<StatCounter> totalRefinementsFinished;
    private final LogManager logger;

    public DelegatingARGBasedRefiner(LogManager pLogger, ARGBasedRefiner ... pRefiners) {
        this.logger = pLogger;
        this.refiners = ImmutableList.copyOf((Object[])pRefiners);
        this.totalRefinementsSelected = new ArrayList<StatCounter>();
        this.totalRefinementsFinished = new ArrayList<StatCounter>();
        for (int i = 0; i < this.refiners.size(); ++i) {
            this.totalRefinementsSelected.add(new StatCounter("Number of selected refinement"));
            this.totalRefinementsFinished.add(new StatCounter("Number of finished refinement"));
        }
        assert (!this.refiners.isEmpty());
        assert (this.refiners.size() == this.totalRefinementsSelected.size());
        assert (this.refiners.size() == this.totalRefinementsFinished.size());
    }

    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet reached, ARGPath pErrorPath) throws CPAException, InterruptedException {
        CounterexampleInfo cex = null;
        this.logger.logf(Level.FINE, "starting refinement with %d refiners", new Object[]{this.refiners.size()});
        for (int i = 0; i < this.refiners.size(); ++i) {
            this.totalRefinementsSelected.get(i).inc();
            try {
                this.logger.logf(Level.FINE, "starting refinement %d of %d with %s", new Object[]{i + 1, this.refiners.size(), this.refiners.get(i).getClass().getSimpleName()});
                cex = this.refiners.get(i).performRefinementForPath(reached, pErrorPath);
                if (!cex.isSpurious()) continue;
                this.logger.logf(Level.FINE, "refinement %d of %d was successful", new Object[]{i + 1, this.refiners.size()});
                this.totalRefinementsFinished.get(i).inc();
                break;
            }
            catch (RefinementFailedException e) {
                if (i == this.refiners.size() - 1) {
                    throw e;
                }
                this.logger.logf(Level.FINE, "refinement %d of %d reported repeated counterexample, restarting refinement with next refiner", new Object[]{i + 1, this.refiners.size()});
            }
        }
        if (cex == null) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, pErrorPath);
        }
        this.logger.log(Level.FINE, new Object[]{"refinement finished"});
        return (CounterexampleInfo)((Object)Preconditions.checkNotNull(cex));
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            @Override
            public String getName() {
                return DelegatingARGBasedRefiner.class.getSimpleName();
            }

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
                for (int i = 0; i < DelegatingARGBasedRefiner.this.refiners.size(); ++i) {
                    pOut.println(String.format("Analysis %d (%s):", i + 1, DelegatingARGBasedRefiner.this.refiners.get(i).getClass().getSimpleName()));
                    writer.beginLevel().put(DelegatingARGBasedRefiner.this.totalRefinementsSelected.get(i));
                    writer.beginLevel().put(DelegatingARGBasedRefiner.this.totalRefinementsFinished.get(i));
                    writer.spacer();
                }
            }
        });
        for (ARGBasedRefiner refiner : this.refiners) {
            if (!(refiner instanceof StatisticsProvider)) continue;
            ((StatisticsProvider)((Object)refiner)).collectStatistics(pStatsCollection);
        }
    }
}

