/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.refinement.PrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.PrefixSelector;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cegar")
public final class DelegatingARGBasedRefinerWithRefinementSelection
implements ARGBasedRefiner,
StatisticsProvider {
    @Option(secure=true, description="whether or not to use refinement selection to decide which domain to refine")
    private boolean useRefinementSelection = false;
    @Option(secure=true, description="if this score is exceeded by the first analysis, the auxilliary analysis will be refined")
    private int domainScoreThreshold = 1024;
    private final PrefixSelector classfier;
    private final ARGBasedRefiner primaryRefiner;
    private final PrefixProvider primaryPrefixProvider;
    private final ARGBasedRefiner secondaryRefiner;
    private final PrefixProvider secondaryPrefixProvider;
    private final StatCounter totalPrimaryRefinementsSelected = new StatCounter("Times selected refinement");
    private final StatCounter totalPrimaryRefinementsFinished = new StatCounter("Times finished refinement");
    private final StatCounter totalPrimaryExtraRefinementsSelected = new StatCounter("Times selected refinement (secondary was SAT)");
    private final StatCounter totalPrimaryExtraRefinementsFinished = new StatCounter("Times finished refinement (secondary was SAT)");
    private final StatCounter totalSecondaryRefinementsSelected = new StatCounter("Times selected refinement");
    private final StatCounter totalSecondaryRefinementsFinished = new StatCounter("Times finished refinement");
    private final StatCounter totalSecondaryExtraRefinementsSelected = new StatCounter("Times selected refinement (primary was SAT)");
    private final StatCounter totalSecondaryExtraRefinementsFinished = new StatCounter("Times finished refinement (primary was SAT)");

    public DelegatingARGBasedRefinerWithRefinementSelection(Configuration pConfig, PrefixSelector pClassifier, ARGBasedRefiner pPrimaryRefiner, PrefixProvider pPrimaryPrefixProvider, ARGBasedRefiner pSecondaryRefiner, PrefixProvider pSecondaryPrefixProvider) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.classfier = pClassifier;
        this.primaryRefiner = pPrimaryRefiner;
        this.primaryPrefixProvider = pPrimaryPrefixProvider;
        this.secondaryRefiner = pSecondaryRefiner;
        this.secondaryPrefixProvider = pSecondaryPrefixProvider;
    }

    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet reached, ARGPath pErrorPath) throws CPAException, InterruptedException {
        CounterexampleInfo cex;
        int primaryScore = 0;
        int secondaryScore = Integer.MAX_VALUE;
        if (this.useRefinementSelection && (primaryScore = this.obtainScoreForPrimaryDomain(pErrorPath)) > this.domainScoreThreshold) {
            secondaryScore = this.obtainScoreForSecondaryDomain(pErrorPath);
        }
        if (primaryScore < secondaryScore) {
            this.totalPrimaryRefinementsSelected.inc();
            cex = this.primaryRefiner.performRefinementForPath(reached, pErrorPath);
            if (cex.isSpurious()) {
                this.totalPrimaryRefinementsFinished.inc();
            } else {
                this.totalSecondaryExtraRefinementsSelected.inc();
                cex = this.secondaryRefiner.performRefinementForPath(reached, pErrorPath);
                if (cex.isSpurious()) {
                    this.totalSecondaryExtraRefinementsFinished.inc();
                }
            }
        } else {
            this.totalSecondaryRefinementsSelected.inc();
            cex = this.secondaryRefiner.performRefinementForPath(reached, pErrorPath);
            if (cex.isSpurious()) {
                this.totalSecondaryRefinementsFinished.inc();
            } else {
                this.totalPrimaryExtraRefinementsSelected.inc();
                cex = this.primaryRefiner.performRefinementForPath(reached, cex.getTargetPath());
                if (cex.isSpurious()) {
                    this.totalPrimaryExtraRefinementsFinished.inc();
                }
            }
        }
        return cex;
    }

    private int obtainScoreForPrimaryDomain(ARGPath pErrorPath) throws CPAException, InterruptedException {
        List<InfeasiblePrefix> primaryPrefixes = this.primaryPrefixProvider.extractInfeasiblePrefixes(pErrorPath);
        if (primaryPrefixes.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return this.classfier.obtainScoreForPrefixes(primaryPrefixes, PrefixSelector.PrefixPreference.DOMAIN_MIN);
    }

    private int obtainScoreForSecondaryDomain(ARGPath pErrorPath) throws CPAException, InterruptedException {
        List<InfeasiblePrefix> secondaryPrefixes = this.secondaryPrefixProvider.extractInfeasiblePrefixes(pErrorPath);
        return this.classfier.obtainScoreForPrefixes(secondaryPrefixes, PrefixSelector.PrefixPreference.DOMAIN_MIN);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            @Override
            public String getName() {
                return DelegatingARGBasedRefinerWithRefinementSelection.class.getSimpleName();
            }

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut).beginLevel();
                pOut.println("Primary Analysis:");
                writer.put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalPrimaryRefinementsSelected).put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalPrimaryRefinementsFinished).put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalPrimaryExtraRefinementsSelected).put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalPrimaryExtraRefinementsFinished).spacer();
                pOut.println("Secondary Analysis:");
                writer.put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalSecondaryRefinementsSelected).put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalSecondaryRefinementsFinished).put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalSecondaryExtraRefinementsSelected).put(DelegatingARGBasedRefinerWithRefinementSelection.this.totalSecondaryExtraRefinementsFinished);
            }
        });
        if (this.primaryRefiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.primaryRefiner)).collectStatistics(pStatsCollection);
        }
        if (this.secondaryRefiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.secondaryRefiner)).collectStatistics(pStatsCollection);
        }
    }
}

