/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.refinement.EdgeInterpolator;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.ForgetfulState;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.value.interpolation")
public class GenericEdgeInterpolator<S extends ForgetfulState<T>, T, I extends Interpolant<S, I>>
implements EdgeInterpolator<S, I> {
    @Option(secure=true, description="apply optimizations based on equality of input interpolant and candidate interpolant")
    private boolean applyItpEqualityOptimization = true;
    @Option(secure=true, description="apply optimizations based on CFA edges with only variable-renaming semantics")
    private boolean applyRenamingOptimization = true;
    @Option(secure=true, description="apply optimizations based on infeasibility of suffix")
    private boolean applyUnsatSuffixOptimization = true;
    @Option(secure=true, description="whether or not to manage the callstack, which is needed for BAM")
    private boolean manageCallstack = true;
    private final ShutdownNotifier shutdownNotifier;
    private final StrongestPostOperator<S> postOperator;
    private final InterpolantManager<S, I> interpolantManager;
    private final S initialState;
    private final VariableTrackingPrecision precision;
    private int numberOfInterpolationQueries = 0;
    private final FeasibilityChecker<S> checker;

    public GenericEdgeInterpolator(StrongestPostOperator<S> pStrongestPostOperator, FeasibilityChecker<S> pFeasibilityChecker, InterpolantManager<S, I> pInterpolantManager, S pInitialState, Class<? extends ConfigurableProgramAnalysis> pCpaToRefine, Configuration pConfig, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this, GenericEdgeInterpolator.class);
        try {
            this.checker = pFeasibilityChecker;
            this.postOperator = pStrongestPostOperator;
            this.interpolantManager = pInterpolantManager;
            this.initialState = pInitialState;
            this.precision = VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), pCpaToRefine);
            this.shutdownNotifier = pShutdownNotifier;
        }
        catch (InvalidConfigurationException e) {
            throw new InvalidConfigurationException("Invalid configuration for checking path: " + e.getMessage(), (Throwable)e);
        }
    }

    protected FeasibilityChecker<S> getFeasibilityChecker() {
        return this.checker;
    }

    @Override
    public I deriveInterpolant(ARGPath pErrorPath, CFAEdge pCurrentEdge, Deque<S> pCallstack, PathPosition pOffset, I pInputInterpolant) throws CPAException, InterruptedException {
        Optional<ForgetfulState> maybeSuccessor;
        this.numberOfInterpolationQueries = 0;
        ForgetfulState stateFromOldInterpolant = (ForgetfulState)pInputInterpolant.reconstructState();
        if (pCurrentEdge == null) {
            PathIterator it = pOffset.fullPathIterator();
            Optional<ForgetfulState> intermediate = Optional.of(stateFromOldInterpolant);
            while (intermediate.isPresent()) {
                intermediate = this.getInitialSuccessor(intermediate.orElseThrow(), it.getOutgoingEdge(), pCallstack);
                it.advance();
                if (!it.isPositionWithState()) continue;
            }
            maybeSuccessor = intermediate;
        } else {
            maybeSuccessor = this.getInitialSuccessor(stateFromOldInterpolant, pCurrentEdge, pCallstack);
        }
        if (!maybeSuccessor.isPresent()) {
            return this.interpolantManager.getFalseInterpolant();
        }
        ForgetfulState initialSuccessor = maybeSuccessor.orElseThrow();
        if (this.applyItpEqualityOptimization && stateFromOldInterpolant.equals(initialSuccessor)) {
            return pInputInterpolant;
        }
        if (this.applyRenamingOptimization && this.isOnlyVariableRenamingEdge(pCurrentEdge)) {
            return this.interpolantManager.createInterpolant(initialSuccessor);
        }
        ARGPath remainingErrorPath = pOffset.iterator().getSuffixExclusive();
        if (this.applyUnsatSuffixOptimization && pInputInterpolant.isTrue() && initialSuccessor.getSize() > 1 && this.isSuffixContradicting(remainingErrorPath)) {
            return this.interpolantManager.getTrueInterpolant();
        }
        for (MemoryLocation currentMemoryLocation : this.determineMemoryLocationsToInterpolateOn(initialSuccessor)) {
            this.shutdownNotifier.shutdownIfNecessary();
            Object forgottenInformation = initialSuccessor.forget(currentMemoryLocation);
            if (!this.isRemainingPathFeasible(remainingErrorPath, initialSuccessor)) continue;
            initialSuccessor.remember(currentMemoryLocation, forgottenInformation);
        }
        return this.interpolantManager.createInterpolant(initialSuccessor);
    }

    protected Set<MemoryLocation> determineMemoryLocationsToInterpolateOn(S candidateInterpolant) {
        return candidateInterpolant.getTrackedMemoryLocations();
    }

    private boolean isSuffixContradicting(ARGPath errorPath) throws CPAException, InterruptedException {
        return !this.isRemainingPathFeasible(errorPath, this.initialState);
    }

    protected S getInitalState() {
        return this.initialState;
    }

    @Override
    public int getNumberOfInterpolationQueries() {
        return this.numberOfInterpolationQueries;
    }

    protected void resetNumberOfInterpolationQueries() {
        this.numberOfInterpolationQueries = 0;
    }

    protected ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    protected InterpolantManager<S, I> getInterpolationManager() {
        return this.interpolantManager;
    }

    protected Optional<S> getInitialSuccessor(S pInitialState, CFAEdge pInitialEdge, Deque<S> pCallstack) throws CPAException, InterruptedException {
        S oldState = pInitialState;
        if (this.manageCallstack && pInitialEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
            oldState = this.postOperator.handleFunctionCall(oldState, pInitialEdge, pCallstack);
        }
        if (this.manageCallstack && !pCallstack.isEmpty() && pInitialEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
            oldState = this.postOperator.handleFunctionReturn(oldState, pInitialEdge, pCallstack);
        }
        return this.postOperator.getStrongestPost(oldState, this.precision, pInitialEdge);
    }

    public boolean isRemainingPathFeasible(ARGPath remainingErrorPath, S state) throws CPAException, InterruptedException {
        ++this.numberOfInterpolationQueries;
        return this.checker.isFeasible(remainingErrorPath, state);
    }

    protected boolean isOnlyVariableRenamingEdge(CFAEdge cfaEdge) {
        return cfaEdge != null && cfaEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge;
    }

    protected boolean getApplyItpEqualityOptimization() {
        return this.applyItpEqualityOptimization;
    }

    protected boolean getApplyRenamingOptimization() {
        return this.applyRenamingOptimization;
    }

    protected boolean getApplyUnsatSuffixOptimization() {
        return this.applyUnsatSuffixOptimization;
    }
}

