/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.ForgetfulState;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;

public class GenericFeasibilityChecker<S extends ForgetfulState<?>>
implements FeasibilityChecker<S> {
    private final LogManager logger;
    private final StrongestPostOperator<S> strongestPostOp;
    private final S initialState;
    private final VariableTrackingPrecision precision;

    public GenericFeasibilityChecker(StrongestPostOperator<S> pStrongestPostOp, S pInitialState, Class<? extends ConfigurableProgramAnalysis> pCpaToRefine, LogManager pLogger, Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        this.strongestPostOp = pStrongestPostOp;
        this.initialState = pInitialState;
        this.logger = pLogger;
        this.precision = VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), pCpaToRefine);
    }

    @Override
    public boolean isFeasible(ARGPath path) throws CPAException, InterruptedException {
        return this.isFeasible(path, this.initialState);
    }

    @Override
    public boolean isFeasible(ARGPath pPath, S pStartingPoint) throws CPAException, InterruptedException {
        return this.isFeasible(pPath, pStartingPoint, new ArrayDeque());
    }

    @Override
    public final boolean isFeasible(ARGPath pPath, S pStartingPoint, Deque<S> pCallstack) throws CPAException, InterruptedException {
        try {
            Object next = pStartingPoint;
            PathIterator iterator = pPath.fullPathIterator();
            while (iterator.hasNext()) {
                CFAEdge edge = iterator.getOutgoingEdge();
                Optional<S> maybeNext = this.strongestPostOp.step(next, edge, this.precision, pCallstack, pPath);
                if (!maybeNext.isPresent()) {
                    this.logger.log(Level.FINE, new Object[]{"found path to be infeasible: ", edge, " did not yield a successor"});
                    return false;
                }
                next = (ForgetfulState)maybeNext.orElseThrow();
                iterator.advance();
            }
            return true;
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }
}

