/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.refinement.EdgeInterpolator;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.ForgetfulState;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;
import org.sosy_lab.cpachecker.util.refinement.PathInterpolator;
import org.sosy_lab.cpachecker.util.refinement.PrefixSelector;
import org.sosy_lab.cpachecker.util.refinement.UseDefRelation;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.value.refinement")
public class GenericPathInterpolator<S extends ForgetfulState<?>, I extends Interpolant<S, I>>
implements PathInterpolator<I> {
    @Option(secure=true, description="whether or not to perform path slicing before interpolation")
    private boolean pathSlicing = true;
    @Option(secure=true, description="which prefix of an actual counterexample trace should be used for interpolation", toUppercase=true)
    private List<PrefixSelector.PrefixPreference> prefixPreference = ImmutableList.of((Object)((Object)PrefixSelector.PrefixPreference.DOMAIN_MIN), (Object)((Object)PrefixSelector.PrefixPreference.LENGTH_MIN));
    protected int interpolationOffset = -1;
    protected final StatCounter totalInterpolations = new StatCounter("Number of interpolations");
    protected final StatInt totalInterpolationQueries = new StatInt(StatKind.SUM, "Number of interpolation queries");
    protected final StatInt sizeOfInterpolant = new StatInt(StatKind.AVG, "Size of interpolant");
    protected final StatTimer timerInterpolation = new StatTimer("Time for interpolation");
    private final StatInt totalPrefixes = new StatInt(StatKind.SUM, "Number of sliced prefixes");
    private final StatTimer prefixExtractionTime = new StatTimer("Extracting infeasible sliced prefixes");
    private final StatTimer prefixSelectionTime = new StatTimer("Selecting infeasible sliced prefixes");
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final EdgeInterpolator<S, I> interpolator;
    private final FeasibilityChecker<S> checker;
    private final GenericPrefixProvider<S> prefixProvider;
    private final InterpolantManager<S, I> interpolantManager;
    private final PrefixSelector selector;

    public GenericPathInterpolator(EdgeInterpolator<S, I> pEdgeInterpolator, FeasibilityChecker<S> pFeasibilityChecker, GenericPrefixProvider<S> pPrefixProvider, InterpolantManager<S, I> pInterpolantManager, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this, GenericPathInterpolator.class);
        this.logger = pLogger;
        this.cfa = pCfa;
        this.shutdownNotifier = pShutdownNotifier;
        this.interpolator = pEdgeInterpolator;
        this.checker = pFeasibilityChecker;
        this.interpolantManager = pInterpolantManager;
        this.prefixProvider = pPrefixProvider;
        this.selector = new PrefixSelector(pCfa.getVarClassification(), pCfa.getLoopStructure(), pLogger);
    }

    @Override
    public Map<ARGState, I> performInterpolation(ARGPath errorPath, I interpolant) throws CPAException, InterruptedException {
        this.totalInterpolations.inc();
        this.interpolationOffset = -1;
        ARGPath errorPathPrefix = this.performRefinementSelection(errorPath, interpolant);
        this.timerInterpolation.start();
        Map<ARGState, I> interpolants = this.performEdgeBasedInterpolation(errorPathPrefix, interpolant);
        this.timerInterpolation.stop();
        this.propagateFalseInterpolant(errorPath, errorPathPrefix, interpolants);
        return interpolants;
    }

    protected ARGPath performRefinementSelection(ARGPath pErrorPath, I pInterpolant) throws CPAException, InterruptedException {
        if (!this.isRefinementSelectionEnabled()) {
            return pErrorPath;
        }
        List<InfeasiblePrefix> infeasilbePrefixes = this.extractInfeasibleSlicedPrefixes(pErrorPath, pInterpolant);
        if (!infeasilbePrefixes.isEmpty()) {
            this.totalPrefixes.setNextValue(infeasilbePrefixes.size());
            this.prefixSelectionTime.start();
            pErrorPath = this.selector.selectSlicedPrefix(this.prefixPreference, infeasilbePrefixes).getPath();
            this.logger.logf(Level.FINER, "Sliced prefix selected:\n %s", new Object[]{pErrorPath});
            this.prefixSelectionTime.stop();
        }
        return pErrorPath;
    }

    private List<InfeasiblePrefix> extractInfeasibleSlicedPrefixes(ARGPath pErrorPath, I pInterpolant) throws CPAException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        this.prefixExtractionTime.start();
        List<InfeasiblePrefix> prefixes = this.prefixProvider.extractInfeasiblePrefixes(pErrorPath, (ForgetfulState)pInterpolant.reconstructState());
        this.prefixExtractionTime.stop();
        return prefixes;
    }

    protected Map<ARGState, I> performEdgeBasedInterpolation(ARGPath pErrorPathPrefix, I pInterpolant) throws InterruptedException, CPAException {
        pErrorPathPrefix = this.sliceErrorPath(pErrorPathPrefix);
        LinkedHashMap<ARGState, I> pathInterpolants = new LinkedHashMap<ARGState, I>(pErrorPathPrefix.size());
        PathIterator pathIterator = pErrorPathPrefix.pathIterator();
        ArrayDeque callstack = new ArrayDeque();
        while (pathIterator.hasNext()) {
            this.shutdownNotifier.shutdownIfNecessary();
            if (!pInterpolant.isFalse()) {
                pInterpolant = this.interpolator.deriveInterpolant(pErrorPathPrefix, pathIterator.getOutgoingEdge(), callstack, pathIterator.getPosition(), pInterpolant);
            }
            this.totalInterpolationQueries.setNextValue(this.interpolator.getNumberOfInterpolationQueries());
            if (!pInterpolant.isTrivial() && this.interpolationOffset == -1) {
                this.interpolationOffset = pathIterator.getIndex();
            }
            this.sizeOfInterpolant.setNextValue(pInterpolant.getSize());
            pathIterator.advance();
            pathInterpolants.put(pathIterator.getAbstractState(), pInterpolant);
            if (!pathIterator.hasNext()) assert (pInterpolant.isFalse()) : "final interpolant is not false: " + pInterpolant;
        }
        return pathInterpolants;
    }

    protected boolean isFeasible(ARGPath slicedErrorPathPrefix) throws CPAException, InterruptedException {
        return this.checker.isFeasible(slicedErrorPathPrefix);
    }

    protected ARGPath sliceErrorPath(ARGPath pErrorPathPrefix) throws CPAException, InterruptedException {
        if (!this.isPathSlicingPossible(pErrorPathPrefix)) {
            return pErrorPathPrefix;
        }
        Set<ARGState> useDefStates = new UseDefRelation(pErrorPathPrefix, this.cfa.getVarClassification().isPresent() ? this.cfa.getVarClassification().orElseThrow().getIntBoolVars() : ImmutableSet.of(), false).getUseDefStates();
        ArrayDeque<Pair<FunctionCallEdge, Boolean>> functionCalls = new ArrayDeque<Pair<FunctionCallEdge, Boolean>>();
        ArrayList<CFAEdge> abstractEdges = new ArrayList<CFAEdge>(pErrorPathPrefix.getInnerEdges());
        PathIterator iterator = pErrorPathPrefix.pathIterator();
        while (iterator.hasNext()) {
            CFAEdge originalEdge = iterator.getOutgoingEdge();
            if (!useDefStates.contains(iterator.getAbstractState())) {
                CFANode endNode;
                CFANode startNode;
                if (originalEdge == null) {
                    startNode = AbstractStates.extractLocation(iterator.getAbstractState());
                    endNode = AbstractStates.extractLocation(iterator.getNextAbstractState());
                } else {
                    startNode = originalEdge.getPredecessor();
                    endNode = originalEdge.getSuccessor();
                }
                abstractEdges.set(iterator.getIndex(), new BlankEdge(originalEdge == null ? "" : originalEdge.getRawStatement(), originalEdge == null ? FileLocation.DUMMY : originalEdge.getFileLocation(), startNode, endNode, "sliced edge"));
            }
            if (originalEdge != null) {
                CFAEdgeType typeOfOriginalEdge = originalEdge.getEdgeType();
                if (typeOfOriginalEdge == CFAEdgeType.FunctionCallEdge) {
                    boolean isAbstractEdgeFunctionCall = ((CFAEdge)abstractEdges.get(iterator.getIndex())).getEdgeType() == CFAEdgeType.FunctionCallEdge;
                    functionCalls.push(Pair.of((FunctionCallEdge)originalEdge, isAbstractEdgeFunctionCall));
                }
                if (typeOfOriginalEdge == CFAEdgeType.FunctionReturnEdge) {
                    Pair functionCallInfo = (Pair)functionCalls.pop();
                    if (((Boolean)functionCallInfo.getSecond()).booleanValue() && ((CFAEdge)abstractEdges.get(iterator.getIndex())).getEdgeType() == CFAEdgeType.BlankEdge) {
                        abstractEdges.set(iterator.getIndex(), originalEdge);
                    } else if (!((Boolean)functionCallInfo.getSecond()).booleanValue() && ((CFAEdge)abstractEdges.get(iterator.getIndex())).getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                        for (int j = iterator.getIndex(); j >= 0; --j) {
                            if (functionCallInfo.getFirst() != abstractEdges.get(j)) continue;
                            abstractEdges.set(j, (CFAEdge)functionCallInfo.getFirst());
                            break;
                        }
                    }
                }
            }
            iterator.advance();
        }
        ARGPath slicedErrorPathPrefix = new ARGPath((List<ARGState>)pErrorPathPrefix.asStatesList(), (List<CFAEdge>)abstractEdges);
        return this.isFeasible(slicedErrorPathPrefix) ? pErrorPathPrefix : slicedErrorPathPrefix;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected final void propagateFalseInterpolant(ARGPath errorPath, ARGPath pErrorPathPrefix, Map<ARGState, I> pInterpolants) {
        if (pErrorPathPrefix.size() < errorPath.size()) {
            PathIterator it = errorPath.pathIterator();
            for (int i = 0; i < pErrorPathPrefix.size(); ++i) {
                it.advance();
            }
            for (ARGState state : it.getSuffixInclusive().asStatesList()) {
                pInterpolants.put(state, this.interpolantManager.getFalseInterpolant());
            }
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(out).beginLevel();
        writer.put(this.timerInterpolation).put(this.totalInterpolations).put(this.totalInterpolationQueries).put(this.sizeOfInterpolant).put(this.totalPrefixes);
        writer.put(this.prefixExtractionTime);
        writer.put(this.prefixSelectionTime);
    }

    protected boolean isRefinementSelectionEnabled() {
        return !this.prefixPreference.equals(PrefixSelector.NO_SELECTION);
    }

    protected boolean isPathSlicingPossible(ARGPath pErrorPathPrefix) {
        return this.pathSlicing && this.isRefinementSelectionEnabled() && pErrorPathPrefix.getFirstState().getParents().isEmpty();
    }
}

