/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.UseDefBasedInterpolator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.refinement.ForgetfulState;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.refinement.PrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.refinement.UseDefRelation;

public class GenericPrefixProvider<S extends ForgetfulState<?>>
implements PrefixProvider {
    private final LogManager logger;
    private final StrongestPostOperator<S> strongestPost;
    private final VariableTrackingPrecision precision;
    private final CFA cfa;
    private final S initialState;
    private final ShutdownNotifier shutdownNotifier;

    public GenericPrefixProvider(StrongestPostOperator<S> pStrongestPost, S pEmptyState, LogManager pLogger, CFA pCfa, Configuration config, Class<? extends ConfigurableProgramAnalysis> pCpaToRefine, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.logger = pLogger;
        this.cfa = pCfa;
        this.strongestPost = pStrongestPost;
        this.initialState = pEmptyState;
        this.precision = VariableTrackingPrecision.createStaticPrecision(config, this.cfa.getVarClassification(), pCpaToRefine);
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public List<InfeasiblePrefix> extractInfeasiblePrefixes(ARGPath path) throws CPAException, InterruptedException {
        return this.extractInfeasiblePrefixes(path, this.initialState);
    }

    public List<InfeasiblePrefix> extractInfeasiblePrefixes(ARGPath path, S pInitial) throws CPAException, InterruptedException {
        ArrayList<InfeasiblePrefix> prefixes = new ArrayList<InfeasiblePrefix>();
        ArrayDeque callstack = new ArrayDeque();
        try {
            ARGPathBuilder feasiblePrefixBuilder = ARGPath.builder();
            Object next = pInitial;
            PathIterator iterator = path.pathIterator();
            while (iterator.hasNext()) {
                Optional<S> successor;
                this.shutdownNotifier.shutdownIfNecessary();
                CFAEdge outgoingEdge = iterator.getOutgoingEdge();
                ARGState currentState = iterator.getAbstractState();
                if (outgoingEdge != null) {
                    successor = this.getSuccessor(next, outgoingEdge, callstack);
                } else {
                    PathIterator holeIt = iterator.getPosition().fullPathIterator();
                    Object intermediateState = next;
                    do {
                        successor = this.getSuccessor(intermediateState, holeIt.getOutgoingEdge(), callstack);
                        holeIt.advance();
                        if (!successor.isPresent()) continue;
                        intermediateState = (ForgetfulState)successor.orElseThrow();
                    } while (!holeIt.isPositionWithState() && successor.isPresent());
                }
                feasiblePrefixBuilder.add(currentState, outgoingEdge);
                if (!successor.isPresent()) {
                    this.logger.log(Level.FINE, new Object[]{"found infeasible prefix: ", outgoingEdge, " did not yield a successor"});
                    ARGPath infeasiblePrefix = feasiblePrefixBuilder.build(iterator.getNextAbstractState());
                    prefixes.add(this.buildInfeasiblePrefix(infeasiblePrefix));
                    feasiblePrefixBuilder.removeLast();
                    if (iterator.hasNext()) {
                        Preconditions.checkState((outgoingEdge != null ? 1 : 0) != 0);
                        feasiblePrefixBuilder.add(currentState, new BlankEdge(outgoingEdge.getRawStatement(), outgoingEdge.getFileLocation(), outgoingEdge.getPredecessor(), outgoingEdge.getSuccessor(), "sliced infeasible condition"));
                    }
                    successor = Optional.of(next);
                }
                next = (ForgetfulState)successor.orElseThrow();
                next = this.strongestPost.performAbstraction(next, AbstractStates.extractLocation(iterator.getNextAbstractState()), path, this.precision);
                iterator.advance();
            }
            return prefixes;
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of infeasible prefixes failed: " + e.getMessage(), e);
        }
    }

    private Optional<S> getSuccessor(S pNext, CFAEdge pEdge, Deque<S> pCallstack) throws CPAException, InterruptedException {
        S next = pNext;
        if (pEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
            next = this.strongestPost.handleFunctionCall(next, pEdge, pCallstack);
        }
        if (!pCallstack.isEmpty() && pEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
            next = this.strongestPost.handleFunctionReturn(next, pEdge, pCallstack);
        }
        return this.strongestPost.getStrongestPost(next, this.precision, pEdge);
    }

    private InfeasiblePrefix buildInfeasiblePrefix(ARGPath infeasiblePrefix) {
        UseDefRelation useDefRelation = new UseDefRelation(infeasiblePrefix, this.cfa.getVarClassification().isPresent() ? this.cfa.getVarClassification().orElseThrow().getIntBoolVars() : ImmutableSet.of(), false);
        List<Pair<ARGState, ValueAnalysisInterpolant>> interpolants = new UseDefBasedInterpolator(infeasiblePrefix, useDefRelation, this.cfa.getMachineModel()).obtainInterpolants();
        return InfeasiblePrefix.buildForValueDomain(infeasiblePrefix, (List<ValueAnalysisInterpolant>)Collections3.transformedImmutableListCopy(interpolants, Pair::getSecond));
    }
}

