/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ForOverride;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.ForgetfulState;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;
import org.sosy_lab.cpachecker.util.refinement.InterpolationTree;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.refinement.PathInterpolator;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.value.refinement")
public abstract class GenericRefiner<S extends ForgetfulState<?>, I extends Interpolant<S, I>>
implements ARGBasedRefiner,
StatisticsProvider {
    @Option(secure=true, description="when to export the interpolation tree\nNEVER:   never export the interpolation tree\nFINAL:   export the interpolation tree once after each refinement\nALWAYS:  export the interpolation tree once after each interpolation, i.e. multiple times per refinement", values={"NEVER", "FINAL", "ALWAYS"})
    private String exportInterpolationTree = "NEVER";
    @Option(secure=true, description="export interpolation trees to this file template")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate interpolationTreeExportFile = PathTemplate.ofFormatString((String)"interpolationTree.%d-%d.dot");
    @Option(secure=true, description="instead of reporting a repeated counter-example, search and refine another error-path for the same target-state.")
    private boolean searchForFurtherErrorPaths = false;
    @Option(secure=true, description="store all refined paths")
    private boolean storeAllRefinedPaths = false;
    @Option(secure=true, description="completely disable the tracking of found error paths in the refiner, i.e., disable the detection of repeated counterexamples")
    private boolean disableErrorPathTracking = false;
    @Option(secure=true, description="whether or not to add assumptions to counterexamples, e.g., for supporting counterexample checks")
    private boolean addAssumptionsToCex = true;
    protected final LogManager logger;
    private final PathInterpolator<I> interpolator;
    private final FeasibilityChecker<S> checker;
    private final InterpolantManager<S, I> interpolantManager;
    private final PathExtractor pathExtractor;
    private Set<Integer> previousErrorPathIds = new HashSet<Integer>();
    private final StatCounter refinementCounter = new StatCounter("Number of refinements");
    private final StatInt numberOfTargets = new StatInt(StatKind.SUM, "Number of targets found");
    private final StatTimer refinementTime = new StatTimer("Time for completing refinement");

    protected GenericRefiner(FeasibilityChecker<S> pFeasibilityChecker, PathInterpolator<I> pPathInterpolator, InterpolantManager<S, I> pInterpolantManager, PathExtractor pPathExtractor, Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this, GenericRefiner.class);
        this.logger = pLogger;
        this.interpolator = pPathInterpolator;
        this.interpolantManager = pInterpolantManager;
        this.checker = pFeasibilityChecker;
        this.pathExtractor = pPathExtractor;
    }

    private boolean madeProgress(ARGPath path) {
        boolean progress;
        if (this.disableErrorPathTracking) {
            return true;
        }
        boolean bl = progress = this.previousErrorPathIds.isEmpty() || !this.previousErrorPathIds.contains(this.obtainErrorPathId(path));
        if (!this.storeAllRefinedPaths) {
            this.previousErrorPathIds.clear();
        }
        this.previousErrorPathIds.add(this.obtainErrorPathId(path));
        return progress;
    }

    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath targetPathToUse) throws CPAException, InterruptedException {
        boolean repeatingCEX;
        Set<ARGState> targets = Collections.singleton(targetPathToUse.getLastState());
        boolean bl = repeatingCEX = !this.madeProgress(targetPathToUse);
        if (repeatingCEX && this.searchForFurtherErrorPaths) {
            for (ARGPath targetPath : this.pathExtractor.getTargetPaths(targets)) {
                if (!this.madeProgress(targetPath)) continue;
                this.logger.log(Level.INFO, new Object[]{"The error path given to", this.getClass().getSimpleName(), "is a repeated counterexample,", "so instead, refiner uses a new error path extracted from the reachset."});
                targetPathToUse = targetPath;
                repeatingCEX = false;
                break;
            }
        }
        if (repeatingCEX) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, targetPathToUse);
        }
        this.logger.log(Level.FINEST, new Object[]{"performing refinement ..."});
        this.refinementTime.start();
        this.refinementCounter.inc();
        this.numberOfTargets.setNextValue(targets.size());
        CounterexampleInfo cex = this.isPathFeasible(targetPathToUse);
        if (cex.isSpurious()) {
            this.refineUsingInterpolants(pReached, this.obtainInterpolants(targetPathToUse));
        }
        this.refinementTime.stop();
        this.logger.log(Level.FINEST, new Object[]{"refinement finished"});
        return cex;
    }

    protected abstract void refineUsingInterpolants(ARGReachedSet var1, InterpolationTree<S, I> var2) throws InterruptedException;

    private InterpolationTree<S, I> obtainInterpolants(ARGPath pTargetPath) throws CPAException, InterruptedException {
        InterpolationTree<S, I> interpolationTree = this.createInterpolationTree((List<ARGPath>)ImmutableList.of((Object)((Object)pTargetPath)));
        while (interpolationTree.hasNextPathForInterpolation()) {
            this.performPathInterpolation(interpolationTree);
        }
        this.exportTree(interpolationTree, "FINAL");
        return interpolationTree;
    }

    @ForOverride
    protected InterpolationTree<S, I> createInterpolationTree(List<ARGPath> targets) {
        return new InterpolationTree<S, I>(this.interpolantManager, this.logger, targets, true);
    }

    private void performPathInterpolation(InterpolationTree<S, I> interpolationTree) throws CPAException, InterruptedException {
        ARGPath errorPath = interpolationTree.getNextPathForInterpolation();
        if (errorPath == InterpolationTree.EMPTY_PATH) {
            this.logger.log(Level.FINEST, new Object[]{"skipping interpolation, because false interpolant on path to target state"});
            return;
        }
        I initialItp = interpolationTree.getInitialInterpolantForPath(errorPath);
        if (this.isInitialInterpolantTooWeak(interpolationTree.getRoot(), initialItp, errorPath)) {
            errorPath = ARGUtils.getOnePathTo(errorPath.getLastState());
            initialItp = this.interpolantManager.createInitialInterpolant();
        }
        this.logger.log(Level.FINEST, new Object[]{"performing interpolation, starting at ", errorPath.getFirstState().getStateId(), ", using interpolant ", initialItp});
        interpolationTree.addInterpolants(this.interpolator.performInterpolation(errorPath, initialItp));
        this.exportTree(interpolationTree, "ALWAYS");
    }

    private boolean isInitialInterpolantTooWeak(ARGState root, I initialItp, ARGPath errorPath) throws CPAException, InterruptedException {
        if (Objects.equals(errorPath.getFirstState(), root)) {
            return false;
        }
        return this.checker.isFeasible(errorPath, (ForgetfulState)initialItp.reconstructState());
    }

    private CounterexampleInfo isPathFeasible(ARGPath pErrorPaths) throws CPAException, InterruptedException {
        if (this.isErrorPathFeasible(pErrorPaths)) {
            CFAPathWithAssumptions assignments;
            this.madeProgress(pErrorPaths);
            this.pathExtractor.addFeasibleTarget(pErrorPaths.getLastState());
            this.logger.log(Level.FINEST, new Object[]{"found a feasible counterexample"});
            CFAPathWithAssumptions cFAPathWithAssumptions = assignments = this.addAssumptionsToCex ? this.createModel(pErrorPaths) : CFAPathWithAssumptions.empty();
            if (!assignments.isEmpty()) {
                return CounterexampleInfo.feasiblePrecise(pErrorPaths, assignments);
            }
            return CounterexampleInfo.feasibleImprecise(pErrorPaths);
        }
        return CounterexampleInfo.spurious();
    }

    @ForOverride
    protected boolean isErrorPathFeasible(ARGPath errorPath) throws CPAException, InterruptedException {
        return this.checker.isFeasible(errorPath);
    }

    protected CFAPathWithAssumptions createModel(ARGPath errorPath) throws InterruptedException, CPAException {
        return CFAPathWithAssumptions.empty();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            @Override
            public String getName() {
                return GenericRefiner.this.getClass().getSimpleName();
            }

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                GenericRefiner.this.printStatistics(pOut, pResult, pReached);
            }
        });
        pStatsCollection.add(this.pathExtractor);
        pStatsCollection.add(this.interpolator);
    }

    private void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
        writer.put(this.refinementCounter).put(this.numberOfTargets).put(this.refinementTime);
        this.printAdditionalStatistics(pOut, pResult, pReached);
    }

    protected abstract void printAdditionalStatistics(PrintStream var1, CPAcheckerResult.Result var2, UnmodifiableReachedSet var3);

    private int obtainErrorPathId(ARGPath path) {
        return path.toString().hashCode();
    }

    private void exportTree(InterpolationTree<S, I> interpolationTree, String level) {
        if (this.interpolationTreeExportFile != null && this.exportInterpolationTree.equals(level)) {
            interpolationTree.exportToDot(this.interpolationTreeExportFile, this.refinementCounter.getValue());
        }
    }

    public static enum RestartStrategy {
        ROOT,
        PIVOT,
        COMMON;

    }
}

