/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

public class InfeasiblePrefix {
    private final ARGPath prefix;
    private final ImmutableList<ImmutableSet<String>> interpolantSequence;
    private final ImmutableList<BooleanFormula> pathFormulas;

    private InfeasiblePrefix(ARGPath pInfeasiblePrefix, ImmutableList<ImmutableSet<String>> pSimpleInterpolantSequence) {
        this.prefix = pInfeasiblePrefix;
        this.interpolantSequence = pSimpleInterpolantSequence;
        this.pathFormulas = null;
    }

    private InfeasiblePrefix(ARGPath pInfeasiblePrefix, ImmutableList<ImmutableSet<String>> pSimpleInterpolantSequence, ImmutableList<BooleanFormula> pPathFormulas) {
        this.prefix = pInfeasiblePrefix;
        this.interpolantSequence = pSimpleInterpolantSequence;
        this.pathFormulas = pPathFormulas;
    }

    public static InfeasiblePrefix buildForPredicateDomain(RawInfeasiblePrefix pRawInfeasiblePrefix, FormulaManagerView pFmgr) {
        ImmutableList.Builder simpleInterpolantSequence = ImmutableList.builder();
        for (BooleanFormula itp : pRawInfeasiblePrefix.interpolantSequence) {
            simpleInterpolantSequence.add((Object)ImmutableSet.copyOf(pFmgr.extractVariableNames((Formula)pFmgr.uninstantiate(itp))));
        }
        return new InfeasiblePrefix(pRawInfeasiblePrefix.prefix, (ImmutableList<ImmutableSet<String>>)simpleInterpolantSequence.build(), pRawInfeasiblePrefix.pathFormulas);
    }

    public static InfeasiblePrefix buildForValueDomain(ARGPath pInfeasiblePrefix, List<ValueAnalysisInterpolant> pInterpolantSequence) {
        ImmutableList.Builder simpleInterpolantSequence = ImmutableList.builder();
        for (ValueAnalysisInterpolant itp : pInterpolantSequence) {
            simpleInterpolantSequence.add((Object)Collections3.transformedImmutableSetCopy(itp.getMemoryLocations(), MemoryLocation::getExtendedQualifiedName));
        }
        return new InfeasiblePrefix(pInfeasiblePrefix, (ImmutableList<ImmutableSet<String>>)simpleInterpolantSequence.build());
    }

    public static InfeasiblePrefix buildForSMGValueDomain(ARGPath pInfeasiblePrefix, List<SMGInterpolant> pInterpolantSequence) {
        ImmutableList.Builder simpleInterpolantSequence = ImmutableList.builder();
        for (SMGInterpolant itp : pInterpolantSequence) {
            simpleInterpolantSequence.add((Object)Collections3.transformedImmutableSetCopy(itp.getMemoryLocations(), MemoryLocation::getExtendedQualifiedName));
        }
        return new InfeasiblePrefix(pInfeasiblePrefix, (ImmutableList<ImmutableSet<String>>)simpleInterpolantSequence.build());
    }

    public ImmutableSet<String> extractSetOfIdentifiers() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat(this.interpolantSequence));
    }

    public int getNonTrivialLength() {
        return FluentIterable.from(this.interpolantSequence).filter(Predicates.not(Set::isEmpty)).size();
    }

    public int getDepthOfPivotState() {
        int depth = 0;
        for (Set itp : this.interpolantSequence) {
            if (!itp.isEmpty()) {
                return depth;
            }
            ++depth;
        }
        if (this.pathFormulas != null) {
            return depth;
        }
        throw new AssertionError((Object)"There must be at least one non-trivial interpolant along the prefix.");
    }

    public ARGPath getPath() {
        return this.prefix;
    }

    public ImmutableList<BooleanFormula> getPathFormulae() {
        return this.pathFormulas;
    }

    public static class RawInfeasiblePrefix {
        private final ARGPath prefix;
        private final ImmutableList<BooleanFormula> interpolantSequence;
        private final ImmutableList<BooleanFormula> pathFormulas;

        public RawInfeasiblePrefix(ARGPath pInfeasiblePrefix, ImmutableList<BooleanFormula> pInterpolantSequence, ImmutableList<BooleanFormula> pPathFormulas) {
            this.prefix = pInfeasiblePrefix;
            this.interpolantSequence = pInterpolantSequence;
            this.pathFormulas = pPathFormulas;
        }
    }
}

