/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.refinement.GenericRefiner;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class InterpolationTree<S extends AbstractState, I extends Interpolant<S, I>> {
    private final LogManager logger;
    private int interpolationCounter = 0;
    private final Map<ARGState, ARGState> predecessorRelation = new LinkedHashMap<ARGState, ARGState>();
    private final ListMultimap<ARGState, ARGState> successorRelation = LinkedListMultimap.create();
    private final Map<ARGState, I> interpolants = new LinkedHashMap<ARGState, I>();
    private final ARGState root;
    private final InterpolationStrategy<I> strategy;
    private final InterpolantManager<S, I> interpolantManager;
    public static final ARGPath EMPTY_PATH = null;

    public InterpolationTree(InterpolantManager<S, I> pInterpolantManager, LogManager pLogger, List<ARGPath> pTargetPaths, boolean useTopDownInterpolationStrategy) {
        this.logger = pLogger;
        this.interpolantManager = pInterpolantManager;
        this.root = this.build(pTargetPaths);
        this.strategy = useTopDownInterpolationStrategy ? new TopDownInterpolationStrategy() : new BottomUpInterpolationStrategy(this.extractTargets(pTargetPaths));
    }

    private ARGState build(Collection<ARGPath> targetPaths) {
        return targetPaths.size() == 1 ? this.buildTreeFromSinglePath((ARGPath)((Object)Iterables.getOnlyElement(targetPaths))) : this.buildTreeFromMultiplePaths(targetPaths);
    }

    private ARGState buildTreeFromSinglePath(ARGPath targetPath) {
        ImmutableList<ARGState> states = targetPath.asStatesList();
        for (int i = 0; i < states.size() - 1; ++i) {
            ARGState predecessorState = (ARGState)states.get(i);
            ARGState successorState = (ARGState)states.get(i + 1);
            this.predecessorRelation.put(successorState, predecessorState);
            this.successorRelation.put((Object)predecessorState, (Object)successorState);
        }
        return (ARGState)states.get(0);
    }

    private ARGState buildTreeFromMultiplePaths(Collection<ARGPath> targetPaths) {
        ARGState itpTreeRoot = null;
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(this.extractTargets(targetPaths));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.getParents().iterator().hasNext()) {
                if (this.predecessorRelation.containsKey(currentState)) continue;
                ARGState parentState = currentState.getParents().iterator().next();
                this.predecessorRelation.put(currentState, parentState);
                this.successorRelation.put((Object)parentState, (Object)currentState);
                todo.addFirst(parentState);
                continue;
            }
            if (itpTreeRoot != null) continue;
            itpTreeRoot = currentState;
        }
        return itpTreeRoot;
    }

    private Set<ARGState> extractTargets(Collection<ARGPath> targetsPaths) {
        return Collections3.transformedImmutableSetCopy(targetsPaths, ARGPath::getLastState);
    }

    public ARGState getRoot() {
        return this.root;
    }

    public boolean hasNextPathForInterpolation() {
        ++this.interpolationCounter;
        return this.strategy.hasNextPathForInterpolation();
    }

    public void exportToDot(PathTemplate file, long refinementCounter) {
        StringBuilder result = new StringBuilder("digraph tree {\n");
        for (Map.Entry current : this.successorRelation.entries()) {
            ARGState parent = (ARGState)current.getKey();
            String interpolant = this.interpolants.containsKey(parent) ? ((Interpolant)this.interpolants.get(parent)).toString() : "NA";
            result.append(parent.getStateId() + String.format(" [label=\"%d / %s has itp %s\"]%n", parent.getStateId(), AbstractStates.extractLocation(parent), interpolant));
            result.append(parent.getStateId() + " -> " + ((ARGState)current.getValue()).getStateId() + "\n");
            if (((ARGState)current.getValue()).isTarget()) {
                result.append(((ARGState)current.getValue()).getStateId() + " [style=filled, fillcolor=\"red\"]\n");
            }
            assert (!parent.isTarget());
        }
        result.append("}");
        try {
            IO.writeFile((Path)file.getPath(new Object[]{refinementCounter, this.interpolationCounter}), (Charset)Charset.defaultCharset(), (Object)result);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write interpolation tree to file");
        }
    }

    public ARGPath getNextPathForInterpolation() {
        return this.strategy.getNextPathForInterpolation();
    }

    public I getInitialInterpolantForPath(ARGPath errorPath) {
        return this.strategy.getInitialInterpolantForRoot(errorPath.getFirstState());
    }

    public void addInterpolants(Map<ARGState, I> interpolantsToAdd) {
        for (Map.Entry<ARGState, I> entry : interpolantsToAdd.entrySet()) {
            ARGState state = entry.getKey();
            Interpolant itp = (Interpolant)entry.getValue();
            if (this.interpolants.containsKey(state)) {
                this.interpolants.put(state, ((Interpolant)this.interpolants.get(state)).join(itp));
                continue;
            }
            this.interpolants.put(state, itp);
        }
    }

    public Multimap<CFANode, MemoryLocation> extractPrecisionIncrement(ARGState pRefinementRoot) {
        LinkedHashMultimap increment = LinkedHashMultimap.create();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>();
        todo.add(this.predecessorRelation.get(pRefinementRoot));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (this.stateHasNonTrivialInterpolant(currentState) && !currentState.isTarget()) {
                Interpolant itp = (Interpolant)this.interpolants.get(currentState);
                for (MemoryLocation memoryLocation : itp.getMemoryLocations()) {
                    increment.put((Object)AbstractStates.extractLocation(currentState), (Object)memoryLocation);
                }
            }
            if (this.stateHasFalseInterpolant(currentState)) continue;
            todo.addAll(this.successorRelation.get((Object)currentState));
        }
        return increment;
    }

    public ImmutableSet<ARGState> obtainRefinementRoots(GenericRefiner.RestartStrategy pStrategy) {
        if (pStrategy == GenericRefiner.RestartStrategy.ROOT) {
            assert (this.successorRelation.get((Object)this.root).size() == 1) : "ARG root has more than one successor";
            return ImmutableSet.of((Object)((ARGState)this.successorRelation.get((Object)this.root).iterator().next()));
        }
        ARGState commonRoot = null;
        LinkedHashSet<ARGState> refinementRoots = new LinkedHashSet<ARGState>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>();
        todo.add(this.root);
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (commonRoot == null && this.successorRelation.get((Object)currentState).size() > 1) {
                commonRoot = currentState;
            }
            if (this.stateHasNonTrivialInterpolant(currentState)) {
                refinementRoots.add(currentState);
                if (pStrategy != GenericRefiner.RestartStrategy.COMMON || refinementRoots.size() <= 2) continue;
                assert (commonRoot != null) : "common root not yet set";
                return ImmutableSet.of((Object)commonRoot);
            }
            todo.addAll(this.successorRelation.get((Object)currentState));
        }
        return ImmutableSet.copyOf(refinementRoots);
    }

    public Collection<ARGState> obtainCutOffRoots() {
        HashSet<ARGState> refinementRoots = new HashSet<ARGState>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>();
        todo.add(this.root);
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (this.stateHasFalseInterpolant(currentState)) {
                refinementRoots.add(currentState);
                continue;
            }
            todo.addAll(this.successorRelation.get((Object)currentState));
        }
        return refinementRoots;
    }

    public Collection<ARGState> getTargetsInSubtree(ARGState state) {
        HashSet<ARGState> targetStates = new HashSet<ARGState>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>();
        todo.add(state);
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.isTarget()) {
                targetStates.add(currentState);
                continue;
            }
            todo.addAll(this.successorRelation.get((Object)currentState));
        }
        return targetStates;
    }

    public Collection<ARGState> getInterpolatedTargetsInSubtree(ARGState state) {
        return FluentIterable.from(this.getTargetsInSubtree(state)).filter(this.interpolants::containsKey).toSet();
    }

    public boolean stateHasNonTrivialInterpolant(ARGState currentState) {
        return this.interpolants.containsKey(currentState) && !((Interpolant)this.interpolants.get(currentState)).isTrivial();
    }

    public boolean stateHasFalseInterpolant(ARGState currentState) {
        return this.interpolants.containsKey(currentState) && ((Interpolant)this.interpolants.get(currentState)).isFalse();
    }

    public boolean hasInterpolantForState(ARGState currentState) {
        return this.interpolants.containsKey(currentState);
    }

    public Set<Map.Entry<ARGState, I>> getInterpolantMapping() {
        return this.interpolants.entrySet();
    }

    public I getInterpolantForState(ARGState currentState) {
        return (I)((Interpolant)this.interpolants.get(currentState));
    }

    public Collection<ARGState> getSuccessors(ARGState pState) {
        return this.successorRelation.get((Object)pState);
    }

    public ARGState getPredecessor(ARGState pState) {
        return this.predecessorRelation.get(pState);
    }

    private class BottomUpInterpolationStrategy
    implements InterpolationStrategy<I> {
        private List<ARGState> sources;

        public BottomUpInterpolationStrategy(Set<ARGState> pTargets) {
            this.sources = new ArrayList<ARGState>(pTargets);
        }

        @Override
        public ARGPath getNextPathForInterpolation() {
            ARGState current = this.sources.remove(0);
            assert (current.isTarget()) : "current element is not a target";
            ARGPathBuilder errorPathBuilder = ARGPath.reverseBuilder();
            errorPathBuilder.add(current, (CFAEdge)FluentIterable.from(AbstractStates.getOutgoingEdges(current)).first().orNull());
            while (InterpolationTree.this.predecessorRelation.get(current) != null) {
                ARGState parent = InterpolationTree.this.predecessorRelation.get(current);
                if (InterpolationTree.this.stateHasFalseInterpolant(parent)) {
                    InterpolationTree.this.logger.log(Level.FINEST, new Object[]{"interpolant on path, namely for state ", parent.getStateId(), " is already false, so return empty path"});
                    return EMPTY_PATH;
                }
                if (InterpolationTree.this.predecessorRelation.get(parent) != null) {
                    errorPathBuilder.add(parent, parent.getEdgeToChild(current));
                }
                current = parent;
            }
            return errorPathBuilder.build(current);
        }

        @Override
        public I getInitialInterpolantForRoot(ARGState pRoot) {
            return InterpolationTree.this.interpolantManager.createInitialInterpolant();
        }

        @Override
        public boolean hasNextPathForInterpolation() {
            return !this.sources.isEmpty();
        }
    }

    private class TopDownInterpolationStrategy
    implements InterpolationStrategy<I> {
        private Deque<ARGState> sources;

        private TopDownInterpolationStrategy() {
            this.sources = new ArrayDeque<ARGState>(Collections.singleton(InterpolationTree.this.root));
        }

        @Override
        public ARGPath getNextPathForInterpolation() {
            ARGPathBuilder errorPathBuilder = ARGPath.builder();
            ARGState current = this.sources.pop();
            if (!this.isValidInterpolationRoot(InterpolationTree.this.predecessorRelation.get(current))) {
                InterpolationTree.this.logger.log(Level.FINEST, new Object[]{"interpolant of predecessor of ", current.getStateId(), " is already false, so return empty path"});
                return EMPTY_PATH;
            }
            if (!Objects.equals(current, InterpolationTree.this.root)) {
                errorPathBuilder.add(InterpolationTree.this.predecessorRelation.get(current), InterpolationTree.this.predecessorRelation.get(current).getEdgeToChild(current));
            }
            while (InterpolationTree.this.successorRelation.get((Object)current).iterator().hasNext()) {
                Iterator children = InterpolationTree.this.successorRelation.get((Object)current).iterator();
                ARGState child = (ARGState)children.next();
                errorPathBuilder.add(current, current.getEdgeToChild(child));
                int size = 1;
                while (children.hasNext()) {
                    ++size;
                    ARGState sibling = (ARGState)children.next();
                    InterpolationTree.this.logger.log(Level.FINEST, new Object[]{"\tpush new root ", sibling.getStateId(), " onto stack for parent ", InterpolationTree.this.predecessorRelation.get(sibling).getStateId()});
                    this.sources.push(sibling);
                }
                assert (size <= 2);
                current = child;
            }
            return errorPathBuilder.build(current);
        }

        private boolean isValidInterpolationRoot(ARGState pRoot) {
            return !InterpolationTree.this.stateHasFalseInterpolant(pRoot);
        }

        @Override
        public I getInitialInterpolantForRoot(ARGState pRoot) {
            Interpolant initialInterpolant = (Interpolant)InterpolationTree.this.interpolants.get(pRoot);
            if (initialInterpolant == null) {
                initialInterpolant = InterpolationTree.this.interpolantManager.createInitialInterpolant();
                assert (InterpolationTree.this.interpolants.size() == 0) : "initial interpolant was null after initial interpolation!";
            }
            return initialInterpolant;
        }

        @Override
        public boolean hasNextPathForInterpolation() {
            return !this.sources.isEmpty();
        }
    }

    private static interface InterpolationStrategy<I extends Interpolant<?, ?>> {
        public ARGPath getNextPathForInterpolation();

        public boolean hasNextPathForInterpolation();

        public I getInitialInterpolantForRoot(ARGState var1);
    }
}

