/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options
public class PathExtractor
implements Statistics {
    @Option(secure=true, name="cegar.globalRefinement", description="whether or not global refinement is performed")
    private boolean globalRefinement = false;
    private final Set<ARGState> feasibleTargets = new LinkedHashSet<ARGState>();
    private final LogManager logger;
    private int targetCounter = 0;

    public PathExtractor(LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this, PathExtractor.class);
        this.logger = pLogger;
    }

    public Collection<ARGState> getTargetStates(ARGReachedSet pReached) throws RefinementFailedException, InterruptedException {
        ImmutableList targets = this.extractTargetStatesFromArg(pReached).transform(s -> (ARGState)s).filter(Predicates.not((Predicate)Predicates.in(this.feasibleTargets))).toList();
        if (targets.isEmpty()) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, ARGUtils.getOnePathTo((ARGState)Iterables.getLast(this.feasibleTargets)));
        }
        this.logger.log(Level.FINEST, new Object[]{"number of targets found: " + targets.size()});
        this.targetCounter += targets.size();
        return targets;
    }

    private FluentIterable<AbstractState> extractTargetStatesFromArg(ARGReachedSet pReached) {
        if (this.globalRefinement) {
            return AbstractStates.getTargetStates(pReached.asReachedSet());
        }
        AbstractState lastState = pReached.asReachedSet().getLastState();
        assert (AbstractStates.isTargetState(lastState)) : "Last state is not a target state";
        return FluentIterable.from(Collections.singleton(lastState));
    }

    public List<ARGPath> getTargetPaths(Collection<ARGState> targetStates) {
        return new ArrayList<ARGPath>(Collections2.transform(targetStates, ARGUtils::getOnePathTo));
    }

    public void addFeasibleTarget(ARGState pLastState) {
        this.feasibleTargets.add(pLastState);
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        out.println("Total number of targets found:    " + String.format("%9d", this.targetCounter));
    }

    @Override
    public @Nullable String getName() {
        return this.getClass().getSimpleName();
    }
}

