/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

public class PrefixSelector {
    private final ScorerFactory factory;
    private final Optional<VariableClassification> classification;
    public static final List<PrefixPreference> NO_SELECTION = Collections.singletonList(PrefixPreference.NONE);

    public InfeasiblePrefix selectSlicedPrefix(List<PrefixPreference> pPrefixPreference, List<InfeasiblePrefix> pInfeasiblePrefixes) {
        return (InfeasiblePrefix)Ordering.compound(this.createComparators(pPrefixPreference)).min(pInfeasiblePrefixes);
    }

    public int obtainScoreForPrefixes(List<InfeasiblePrefix> pPrefixes, PrefixPreference pPreference) {
        if (!this.classification.isPresent()) {
            return Integer.MAX_VALUE;
        }
        Scorer scorer = this.factory.createScorer(pPreference);
        return pPrefixes.stream().mapToInt(p -> scorer.computeScore((InfeasiblePrefix)p)).min().orElse(Integer.MAX_VALUE);
    }

    private List<Comparator<InfeasiblePrefix>> createComparators(List<PrefixPreference> pPrefixPreference) {
        return Lists.transform(pPrefixPreference, p -> this.factory.createScorer((PrefixPreference)((Object)p)).getComparator());
    }

    public PrefixSelector(Optional<VariableClassification> pClassification, Optional<LoopStructure> pLoopStructure, LogManager pLogger) {
        this.factory = new ScorerFactory(pClassification, pLoopStructure, pLogger);
        this.classification = pClassification;
    }

    private static class RandomScorer
    implements Scorer {
        private static final Random random = new Random(0L);

        private RandomScorer() {
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            return random.nextInt(1000);
        }
    }

    private static class AssumptionScorer
    implements Scorer {
        private final Optional<VariableClassification> classification;

        public AssumptionScorer(Optional<VariableClassification> pClassification) {
            this.classification = pClassification;
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            int count = 0;
            for (String variable : pPrefix.extractSetOfIdentifiers()) {
                count += this.classification.orElseThrow().getAssumedVariables().count((Object)variable);
            }
            return count;
        }
    }

    private static class AssignmentScorer
    implements Scorer {
        private final Optional<VariableClassification> classification;

        public AssignmentScorer(Optional<VariableClassification> pClassification) {
            this.classification = pClassification;
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            int count = 0;
            for (String variable : pPrefix.extractSetOfIdentifiers()) {
                count += this.classification.orElseThrow().getAssignedVariables().count((Object)variable);
            }
            return count;
        }
    }

    private static class LengthScorer
    implements Scorer {
        private LengthScorer() {
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            return pPrefix.getPath().size();
        }
    }

    private static class DepthScorer
    implements Scorer {
        private DepthScorer() {
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            return pPrefix.getDepthOfPivotState();
        }
    }

    private static class WidthScorer
    implements Scorer {
        private WidthScorer() {
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            return pPrefix.getNonTrivialLength();
        }
    }

    private static class LoopScorer
    implements Scorer {
        private final LogManagerWithoutDuplicates logger;
        private final Optional<VariableClassification> classification;
        private final Optional<LoopStructure> loopStructure;

        public LoopScorer(Optional<VariableClassification> pClassification, Optional<LoopStructure> pLoopStructure, LogManagerWithoutDuplicates pLogger) {
            this.classification = pClassification;
            this.loopStructure = pLoopStructure;
            this.logger = pLogger;
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            int score = this.classification.orElseThrow().obtainDomainTypeScoreForVariables((Collection<String>)pPrefix.extractSetOfIdentifiers(), this.loopStructure, this.logger);
            if (score != Integer.MAX_VALUE) {
                score = 0;
            }
            return score;
        }
    }

    private static class DomainScorer
    implements Scorer {
        private final LogManagerWithoutDuplicates logger;
        private final Optional<VariableClassification> classification;
        private final Optional<LoopStructure> loopStructure;

        public DomainScorer(Optional<VariableClassification> pClassification, Optional<LoopStructure> pLoopStructure, LogManagerWithoutDuplicates pLogger) {
            this.classification = pClassification;
            this.loopStructure = pLoopStructure;
            this.logger = pLogger;
        }

        @Override
        public int computeScore(InfeasiblePrefix pPrefix) {
            return this.classification.orElseThrow().obtainDomainTypeScoreForVariables((Collection<String>)pPrefix.extractSetOfIdentifiers(), this.loopStructure, this.logger);
        }
    }

    private static interface Scorer {
        public static final int DEFAULT_SCORE = Integer.MAX_VALUE;

        public int computeScore(InfeasiblePrefix var1);

        default public Comparator<InfeasiblePrefix> getComparator() {
            return Comparator.comparingInt(this::computeScore);
        }

        default public Scorer invert() {
            final Scorer delegate = this;
            return new Scorer(){

                @Override
                public int computeScore(InfeasiblePrefix pPrefix) {
                    int score = delegate.computeScore(pPrefix);
                    if (score == Integer.MIN_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return -score;
                }
            };
        }
    }

    private static class ScorerFactory {
        private final LogManagerWithoutDuplicates logger;
        private final Optional<VariableClassification> classification;
        private final Optional<LoopStructure> loopStructure;
        private final Scorer randomScorer = new RandomScorer();

        public ScorerFactory(Optional<VariableClassification> pClassification, Optional<LoopStructure> pLoopStructure, LogManager pLogger) {
            this.classification = pClassification;
            this.loopStructure = pLoopStructure;
            this.logger = new LogManagerWithoutDuplicates(pLogger);
        }

        public Scorer createScorer(PrefixPreference pPreference) {
            switch (pPreference) {
                case LENGTH_MIN: {
                    return new LengthScorer();
                }
                case LENGTH_MAX: {
                    return new LengthScorer().invert();
                }
                case DOMAIN_MIN: {
                    return new DomainScorer(this.classification, this.loopStructure, this.logger);
                }
                case DOMAIN_MAX: {
                    return new DomainScorer(this.classification, this.loopStructure, this.logger).invert();
                }
                case LOOPS_MIN: {
                    return new LoopScorer(this.classification, this.loopStructure, this.logger);
                }
                case LOOPS_MAX: {
                    return new LoopScorer(this.classification, this.loopStructure, this.logger).invert();
                }
                case WIDTH_MIN: {
                    return new WidthScorer();
                }
                case WIDTH_MAX: {
                    return new WidthScorer().invert();
                }
                case PIVOT_MIN: {
                    return new DepthScorer();
                }
                case PIVOT_MAX: {
                    return new DepthScorer().invert();
                }
                case ASSIGNMENTS_MIN: {
                    return new AssignmentScorer(this.classification);
                }
                case ASSIGNMENTS_MAX: {
                    return new AssignmentScorer(this.classification).invert();
                }
                case ASSUMPTIONS_MIN: {
                    return new AssumptionScorer(this.classification);
                }
                case ASSUMPTIONS_MAX: {
                    return new AssumptionScorer(this.classification).invert();
                }
                case RANDOM: {
                    return this.randomScorer;
                }
            }
            throw new IllegalArgumentException("Illegal prefix preference " + pPreference + " given!");
        }
    }

    public static enum PrefixPreference {
        LENGTH_MIN,
        LENGTH_MAX,
        DOMAIN_MIN,
        DOMAIN_MAX,
        LOOPS_MIN,
        LOOPS_MAX,
        PIVOT_MIN,
        PIVOT_MAX,
        WIDTH_MIN,
        WIDTH_MAX,
        ASSIGNMENTS_MIN,
        ASSIGNMENTS_MAX,
        ASSUMPTIONS_MIN,
        ASSUMPTIONS_MAX,
        RANDOM,
        NONE;

    }
}

