/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import java.util.Deque;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.refinement.ForgetfulState;

public interface StrongestPostOperator<S extends ForgetfulState<?>> {
    public Optional<S> getStrongestPost(S var1, Precision var2, CFAEdge var3) throws CPAException, InterruptedException;

    public S handleFunctionCall(S var1, CFAEdge var2, Deque<S> var3);

    public S handleFunctionReturn(S var1, CFAEdge var2, Deque<S> var3);

    public S performAbstraction(S var1, CFANode var2, ARGPath var3, Precision var4);

    default public Optional<S> step(S state, CFAEdge edge, Precision precision, Deque<S> callstack, ARGPath argPath) throws CPAException, InterruptedException {
        Optional<S> successors;
        Object next = state;
        if (edge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
            next = this.handleFunctionCall(next, edge, callstack);
        }
        if (!callstack.isEmpty() && edge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
            next = this.handleFunctionReturn(next, edge, callstack);
        }
        if (!(successors = this.getStrongestPost(next, precision, edge)).isPresent()) {
            return successors;
        }
        next = (ForgetfulState)successors.orElseThrow();
        next = this.performAbstraction(next, edge.getSuccessor(), argPath, precision);
        return Optional.of(next);
    }
}

