/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.refinement;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

public class UseDefRelation {
    private Set<String> booleanVariables = new HashSet<String>();
    private final Map<Pair<ARGState, CFAEdge>, Pair<Set<ASimpleDeclaration>, Set<ASimpleDeclaration>>> relation = new LinkedHashMap<Pair<ARGState, CFAEdge>, Pair<Set<ASimpleDeclaration>, Set<ASimpleDeclaration>>>();
    private final Set<ASimpleDeclaration> unresolvedUses = new HashSet<ASimpleDeclaration>();
    private boolean hasContradictingAssumeEdgeBeenHandled = false;
    private boolean addAllAssumes = false;

    public UseDefRelation(ARGPath path, Set<String> pBooleanVariables, boolean pAddAllAssumes) {
        this.booleanVariables = pBooleanVariables;
        this.addAllAssumes = pAddAllAssumes;
        this.buildRelation(path);
    }

    public Map<ARGState, Collection<ASimpleDeclaration>> getExpandedUses(ARGPath path) {
        LinkedHashMap<ARGState, Collection<ASimpleDeclaration>> expandedUses = new LinkedHashMap<ARGState, Collection<ASimpleDeclaration>>();
        HashSet<ASimpleDeclaration> unresolvedUsesOnPath = new HashSet<ASimpleDeclaration>();
        PathIterator it = path.reverseFullPathIterator();
        while (it.hasNext()) {
            it.advance();
            ARGState currentState = it.isPositionWithState() ? it.getAbstractState() : it.getPreviousAbstractState();
            CFAEdge currentEdge = it.getOutgoingEdge();
            unresolvedUsesOnPath.removeAll(this.getDef(currentState, currentEdge));
            unresolvedUsesOnPath.addAll(this.getUses(currentState, currentEdge));
            expandedUses.put(currentState, new HashSet(unresolvedUsesOnPath));
        }
        return expandedUses;
    }

    public Collection<String> getUsesAsQualifiedName() {
        HashSet<String> uses = new HashSet<String>();
        for (Set useSet : Collections3.transformedImmutableSetCopy(this.relation.values(), Pair::getSecond)) {
            for (ASimpleDeclaration use : useSet) {
                uses.add(use.getQualifiedName());
            }
        }
        return uses;
    }

    public Set<ARGState> getUseDefStates() {
        return Collections3.transformedImmutableSetCopy(this.relation.keySet(), Pair::getFirst);
    }

    private void buildRelation(ARGPath path) {
        PathIterator iterator = path.reverseFullPathIterator();
        while (iterator.hasNext()) {
            iterator.advance();
            CFAEdge edge = iterator.getOutgoingEdge();
            ARGState state = iterator.isPositionWithState() ? iterator.getAbstractState() : iterator.getPreviousAbstractState();
            this.updateUseDefRelation(state, edge);
            if (!this.hasContradictingAssumeEdgeBeenHandled || !this.unresolvedUses.isEmpty()) continue;
            break;
        }
    }

    private boolean hasUnresolvedUse(ASimpleDeclaration use) {
        return this.unresolvedUses.contains(use);
    }

    private void addUseDef(ARGState state, CFAEdge edge, ASimpleDeclaration def, ASimpleDeclaration use) {
        this.updateRelation(state, edge, Sets.newHashSet((Object[])new ASimpleDeclaration[]{def}), Sets.newHashSet((Object[])new ASimpleDeclaration[]{use}));
    }

    private void addUseDef(ARGState state, CFAEdge edge, ASimpleDeclaration def, Set<ASimpleDeclaration> uses) {
        this.updateRelation(state, edge, Sets.newHashSet((Object[])new ASimpleDeclaration[]{def}), uses);
    }

    private void addUseDef(ARGState state, CFAEdge edge, Set<ASimpleDeclaration> defs, Set<ASimpleDeclaration> uses) {
        this.updateRelation(state, edge, defs, uses);
    }

    private void addUseDef(ARGState state, CFAEdge edge, Set<ASimpleDeclaration> uses) {
        this.updateRelation(state, edge, (Set<ASimpleDeclaration>)ImmutableSet.of(), uses);
    }

    private void updateRelation(ARGState state, CFAEdge edge, Set<ASimpleDeclaration> defs, Set<ASimpleDeclaration> uses) {
        assert (!this.relation.containsKey(Pair.of(state, edge))) : "There is already a use-def entry for this pair of state, edge";
        this.relation.put(Pair.of(state, edge), Pair.of(defs, uses));
        this.unresolvedUses.removeAll(defs);
        this.unresolvedUses.addAll(uses);
    }

    private Collection<ASimpleDeclaration> getDef(ARGState state, CFAEdge edge) {
        if (this.relation.containsKey(Pair.of(state, edge))) {
            return this.relation.get(Pair.of(state, edge)).getFirst();
        }
        return ImmutableSet.of();
    }

    private Collection<ASimpleDeclaration> getUses(ARGState state, CFAEdge edge) {
        if (this.relation.containsKey(Pair.of(state, edge))) {
            return this.relation.get(Pair.of(state, edge)).getSecond();
        }
        return ImmutableSet.of();
    }

    private void updateUseDefRelation(ARGState state, CFAEdge edge) {
        switch (edge.getEdgeType()) {
            case FunctionReturnEdge: {
                ASimpleDeclaration assignedVariable;
                Set<ASimpleDeclaration> assignedVariables;
                AFunctionCall summaryExpr = ((FunctionReturnEdge)edge).getSummaryEdge().getExpression();
                if (!(summaryExpr instanceof AFunctionCallAssignmentStatement) || (assignedVariables = UseDefRelation.acceptLeft(((CFunctionCallAssignmentStatement)summaryExpr).getLeftHandSide())).size() > 1 || !this.hasUnresolvedUse(assignedVariable = (ASimpleDeclaration)Iterables.getOnlyElement(assignedVariables))) break;
                this.addUseDef(state, edge, assignedVariable, ((FunctionReturnEdge)edge).getFunctionEntry().getReturnVariable().get());
                break;
            }
            case DeclarationEdge: {
                CDeclaration declaration = ((CDeclarationEdge)edge).getDeclaration();
                if (!(declaration instanceof AVariableDeclaration) || !this.hasUnresolvedUse(declaration)) break;
                this.addUseDef(state, edge, (ASimpleDeclaration)declaration, this.getVariablesUsedInDeclaration(declaration));
                break;
            }
            case ReturnStatementEdge: {
                AReturnStatementEdge returnStatementEdge = (AReturnStatementEdge)edge;
                if (!returnStatementEdge.asAssignment().isPresent()) break;
                this.handleAssignments(returnStatementEdge.asAssignment().get(), edge, state);
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)edge;
                FunctionEntryNode functionEntryNode = functionCallEdge.getSuccessor();
                ArrayList<? extends AParameterDeclaration> parameters = new ArrayList<AParameterDeclaration>(functionEntryNode.getFunctionParameters());
                HashSet<ASimpleDeclaration> defs = new HashSet<ASimpleDeclaration>();
                HashSet<ASimpleDeclaration> uses = new HashSet<ASimpleDeclaration>();
                for (int parameterIndex = 0; parameterIndex < parameters.size(); ++parameterIndex) {
                    if (!this.hasUnresolvedUse((ASimpleDeclaration)parameters.get(parameterIndex))) continue;
                    defs.add((ASimpleDeclaration)parameters.get(parameterIndex));
                    uses.addAll(UseDefRelation.acceptAll(functionCallEdge.getArguments().get(parameterIndex)));
                }
                this.addUseDef(state, edge, defs, uses);
                break;
            }
            case AssumeEdge: {
                if (this.hasContradictingAssumeEdgeBeenHandled) {
                    this.handleFeasibleAssumption(state, (CAssumeEdge)edge);
                    break;
                }
                this.hasContradictingAssumeEdgeBeenHandled = !this.addAllAssumes;
                this.addUseDef(state, edge, UseDefRelation.acceptAll(((CAssumeEdge)edge).getExpression()));
                break;
            }
            case StatementEdge: {
                CStatement statement = ((CStatementEdge)edge).getStatement();
                if (!(statement instanceof AExpressionAssignmentStatement) && !(statement instanceof AFunctionCallAssignmentStatement)) break;
                this.handleAssignments((AAssignment)((Object)statement), edge, state);
                break;
            }
        }
    }

    private void handleFeasibleAssumption(ARGState state, CAssumeEdge assumeEdge) {
        CExpression expression = assumeEdge.getExpression();
        CBinaryExpression binaryExpression = (CBinaryExpression)expression;
        CSimpleDeclaration operand = null;
        if (binaryExpression.getOperand1() instanceof CIdExpression && binaryExpression.getOperand2() instanceof CLiteralExpression) {
            operand = ((CIdExpression)binaryExpression.getOperand1()).getDeclaration();
        } else if (binaryExpression.getOperand2() instanceof CIdExpression && binaryExpression.getOperand1() instanceof CLiteralExpression) {
            operand = ((CIdExpression)binaryExpression.getOperand2()).getDeclaration();
        }
        if (this.isEquality(assumeEdge, binaryExpression.getOperator()) && this.hasUnresolvedUse(operand)) {
            this.addUseDef(state, (CFAEdge)assumeEdge, (ASimpleDeclaration)operand, (Set<ASimpleDeclaration>)ImmutableSet.of());
        } else if (this.isInequality(assumeEdge, binaryExpression.getOperator()) && this.hasUnresolvedUse(operand) && this.hasBooleanCharacter(operand)) {
            this.addUseDef(state, (CFAEdge)assumeEdge, (ASimpleDeclaration)operand, (Set<ASimpleDeclaration>)ImmutableSet.of());
        }
    }

    private boolean hasBooleanCharacter(ASimpleDeclaration operand) {
        return this.booleanVariables.contains(operand.getQualifiedName());
    }

    private boolean isEquality(CAssumeEdge assumeEdge, CBinaryExpression.BinaryOperator operator) {
        return assumeEdge.getTruthAssumption() && operator == CBinaryExpression.BinaryOperator.EQUALS || !assumeEdge.getTruthAssumption() && operator == CBinaryExpression.BinaryOperator.NOT_EQUALS;
    }

    private boolean isInequality(CAssumeEdge assumeEdge, CBinaryExpression.BinaryOperator operator) {
        return assumeEdge.getTruthAssumption() && operator == CBinaryExpression.BinaryOperator.NOT_EQUALS || !assumeEdge.getTruthAssumption() && operator == CBinaryExpression.BinaryOperator.EQUALS;
    }

    private static Set<ASimpleDeclaration> acceptLeft(ALeftHandSide exp) {
        return CFAUtils.traverseLeftHandSideRecursively(exp).filter(AIdExpression.class).transform(AIdExpression::getDeclaration).toSet();
    }

    private static Set<ASimpleDeclaration> acceptAll(AExpression exp) {
        return CFAUtils.traverseRecursively(exp).filter(AIdExpression.class).transform(AIdExpression::getDeclaration).toSet();
    }

    private Set<ASimpleDeclaration> getVariablesUsedInDeclaration(CDeclaration declaration) {
        AInitializer initializer = ((AVariableDeclaration)((Object)declaration)).getInitializer();
        if (initializer == null) {
            return ImmutableSet.of();
        }
        return this.getVariablesUsedForInitialization(initializer);
    }

    private Set<ASimpleDeclaration> getVariablesUsedForInitialization(AInitializer initializer) {
        if (initializer instanceof CDesignatedInitializer) {
            return this.getVariablesUsedForInitialization(((CDesignatedInitializer)initializer).getRightHandSide());
        }
        if (initializer instanceof CInitializerList) {
            HashSet<ASimpleDeclaration> readVars = new HashSet<ASimpleDeclaration>();
            for (CInitializer initializerList : ((CInitializerList)initializer).getInitializers()) {
                readVars.addAll(this.getVariablesUsedForInitialization(initializerList));
            }
            return readVars;
        }
        if (initializer instanceof AInitializerExpression) {
            return UseDefRelation.acceptAll(((AInitializerExpression)initializer).getExpression());
        }
        throw new AssertionError((Object)"Missing case for if-then-else statement.");
    }

    private void handleAssignments(AAssignment assignment, CFAEdge edge, ARGState state) {
        ALeftHandSide leftHandSide = assignment.getLeftHandSide();
        Set<ASimpleDeclaration> assignedVariables = UseDefRelation.acceptLeft(leftHandSide);
        Set<ASimpleDeclaration> allLeftHandSideVariables = UseDefRelation.acceptAll(leftHandSide);
        ImmutableSet leftHandSideUses = FluentIterable.from(allLeftHandSideVariables).filter(Predicates.not((Predicate)Predicates.in(assignedVariables))).toSet();
        if (assignedVariables.size() > 1) {
            return;
        }
        if (this.hasUnresolvedUse((ASimpleDeclaration)Iterables.getOnlyElement(assignedVariables))) {
            Set<ASimpleDeclaration> rightHandSideUses;
            if (assignment instanceof AExpressionAssignmentStatement) {
                rightHandSideUses = UseDefRelation.acceptAll((AExpression)assignment.getRightHandSide());
            } else if (assignment instanceof AFunctionCallAssignmentStatement) {
                AFunctionCallAssignmentStatement funcStmt = (AFunctionCallAssignmentStatement)assignment;
                rightHandSideUses = this.getVariablesUsedAsParameters(funcStmt.getFunctionCallExpression().getParameterExpressions());
            } else {
                throw new AssertionError((Object)"Unhandled assignment type.");
            }
            this.addUseDef(state, edge, (ASimpleDeclaration)Iterables.getOnlyElement(assignedVariables), (Set<ASimpleDeclaration>)Sets.union((Set)leftHandSideUses, rightHandSideUses));
        }
    }

    private Set<ASimpleDeclaration> getVariablesUsedAsParameters(List<? extends AExpression> parameters) {
        HashSet<ASimpleDeclaration> usedParameters = new HashSet<ASimpleDeclaration>();
        for (AExpression aExpression : parameters) {
            usedParameters.addAll(UseDefRelation.acceptAll(aExpression));
        }
        return usedParameters;
    }
}

