/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.resources;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;

public class ThreadCpuTimeLimit
implements ResourceLimit {
    private final long duration;
    private final long endTime;
    private final Thread thread;
    private long overallUsedTime = 0L;

    private ThreadCpuTimeLimit(long pStart, long pLimit, TimeUnit pUnit, Thread pThread) {
        Preconditions.checkArgument((pLimit > 0L ? 1 : 0) != 0);
        this.duration = TimeUnit.NANOSECONDS.convert(pLimit, pUnit);
        this.endTime = pStart + this.duration;
        this.thread = pThread;
    }

    public static ThreadCpuTimeLimit fromNowOn(TimeSpan timeSpan, Thread pThread) {
        return new ThreadCpuTimeLimit(ThreadCpuTimeLimit.getCurrentThreadTime(pThread), timeSpan.asNanos(), TimeUnit.NANOSECONDS, pThread);
    }

    public static ThreadCpuTimeLimit fromNowOn(long limit, TimeUnit unit, Thread pThread) {
        return new ThreadCpuTimeLimit(ThreadCpuTimeLimit.getCurrentThreadTime(pThread), limit, unit, pThread);
    }

    @Override
    public synchronized long getCurrentValue() {
        long currentValue = ThreadCpuTimeLimit.getCurrentThreadTime(this.thread);
        if (currentValue != -1L) {
            this.overallUsedTime = currentValue;
        }
        return currentValue;
    }

    private static long getCurrentThreadTime(Thread pThread) {
        return ManagementFactory.getThreadMXBean().getThreadCpuTime(pThread.getId());
    }

    @Override
    public synchronized boolean isExceeded(long pCurrentValue) {
        return pCurrentValue >= this.endTime;
    }

    @Override
    public synchronized long nanoSecondsToNextCheck(long pCurrentValue) {
        return (this.endTime - pCurrentValue) / 2L;
    }

    public synchronized TimeSpan getOverallUsedTime() {
        return TimeSpan.of((long)this.overallUsedTime, (TimeUnit)TimeUnit.NANOSECONDS);
    }

    @Override
    public String getName() {
        return "Thread CPU-time limit of " + TimeUnit.NANOSECONDS.toSeconds(this.duration) + "s";
    }
}

