/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.resources;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;

public class WalltimeLimit
implements ResourceLimit {
    private final long duration;
    private final long endTime;

    private WalltimeLimit(long pDuration) {
        this.duration = pDuration;
        this.endTime = this.getCurrentValue() + pDuration;
    }

    public static WalltimeLimit fromNowOn(TimeSpan timeSpan) {
        return WalltimeLimit.fromNowOn(timeSpan.asNanos(), TimeUnit.NANOSECONDS);
    }

    public static WalltimeLimit fromNowOn(long time, TimeUnit unit) {
        Preconditions.checkArgument((time > 0L ? 1 : 0) != 0);
        long nanoDuration = TimeUnit.NANOSECONDS.convert(time, unit);
        return new WalltimeLimit(nanoDuration);
    }

    @Override
    public long getCurrentValue() {
        return System.nanoTime();
    }

    @Override
    public boolean isExceeded(long pCurrentValue) {
        return pCurrentValue >= this.endTime;
    }

    @Override
    public long nanoSecondsToNextCheck(long pCurrentValue) {
        return this.endTime - pCurrentValue;
    }

    @Override
    public String getName() {
        return "walltime limit of " + TimeUnit.NANOSECONDS.toSeconds(this.duration) + "s";
    }
}

