/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.AbstractTransformingCAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.slicing.Slice;

abstract class AbstractSlice
implements Slice {
    private final CFA originalCfa;
    private final ImmutableCollection<CFAEdge> slicingCriteria;
    private final ImmutableSet<CFAEdge> relevantEdges;
    private final ImmutableSet<ASimpleDeclaration> relevantDeclarations;

    AbstractSlice(CFA pOriginalCfa, Collection<CFAEdge> pSlicingCriteria, Collection<CFAEdge> pRelevantEdges, Set<ASimpleDeclaration> pRelevantDeclarations) {
        this.originalCfa = pOriginalCfa;
        this.slicingCriteria = ImmutableList.copyOf(pSlicingCriteria);
        this.relevantEdges = ImmutableSet.copyOf(pRelevantEdges);
        this.relevantDeclarations = ImmutableSet.copyOf(pRelevantDeclarations);
    }

    static ImmutableSet<ASimpleDeclaration> computeRelevantDeclarations(Collection<CFAEdge> pRelevantEdges, Predicate<ASimpleDeclaration> pRelevantDeclarationFilter) {
        RelevantDeclarationCollectingVisitor relevantDeclarationCollectingVisitor = new RelevantDeclarationCollectingVisitor(pRelevantDeclarationFilter);
        for (CFAEdge relevantEdge : pRelevantEdges) {
            if (relevantEdge instanceof CDeclarationEdge) {
                ((CDeclarationEdge)relevantEdge).getDeclaration().accept(relevantDeclarationCollectingVisitor);
            }
            for (CFANode relevantNode : ImmutableList.of((Object)relevantEdge.getPredecessor(), (Object)relevantEdge.getSuccessor())) {
                if (!(relevantNode instanceof FunctionEntryNode)) continue;
                FunctionEntryNode relevantFunctionEntryNode = (FunctionEntryNode)relevantNode;
                Optional<? extends AVariableDeclaration> optionalReturnVariable = relevantFunctionEntryNode.getReturnVariable();
                optionalReturnVariable.filter(returnVariable -> returnVariable instanceof CVariableDeclaration).map(returnVariable -> (CVariableDeclaration)returnVariable).ifPresent(returnVariable -> returnVariable.accept(relevantDeclarationCollectingVisitor));
            }
        }
        return ImmutableSet.copyOf(relevantDeclarationCollectingVisitor.getRelevantDeclarations());
    }

    @Override
    public CFA getOriginalCfa() {
        return this.originalCfa;
    }

    @Override
    public ImmutableCollection<CFAEdge> getSlicingCriteria() {
        return this.slicingCriteria;
    }

    @Override
    public ImmutableSet<CFAEdge> getRelevantEdges() {
        return this.relevantEdges;
    }

    @Override
    public ImmutableSet<ASimpleDeclaration> getRelevantDeclarations() {
        return this.relevantDeclarations;
    }

    private static final class RelevantDeclarationCollectingVisitor
    extends AbstractTransformingCAstNodeVisitor<NoException> {
        private final Predicate<ASimpleDeclaration> relevantDeclarationFilter;
        private Set<ASimpleDeclaration> relevantDeclarations;

        private RelevantDeclarationCollectingVisitor(Predicate<ASimpleDeclaration> pRelevantDeclarationFilter) {
            this.relevantDeclarationFilter = pRelevantDeclarationFilter;
            this.relevantDeclarations = new LinkedHashSet<ASimpleDeclaration>();
        }

        private Set<ASimpleDeclaration> getRelevantDeclarations() {
            return this.relevantDeclarations;
        }

        private CAstNode collectDeclarationIfRelevant(ASimpleDeclaration pDeclaration, Supplier<CAstNode> pSuperReturnValueSupplier) {
            if (this.relevantDeclarationFilter.test(pDeclaration)) {
                this.relevantDeclarations.add(pDeclaration);
            }
            return pSuperReturnValueSupplier.get();
        }

        @Override
        public CAstNode visit(CVariableDeclaration pDeclaration) {
            return this.collectDeclarationIfRelevant(pDeclaration, () -> super.visit(pDeclaration));
        }

        @Override
        public CAstNode visit(CParameterDeclaration pDeclaration) {
            return this.collectDeclarationIfRelevant(pDeclaration, () -> super.visit(pDeclaration));
        }

        @Override
        public CAstNode visit(CFunctionDeclaration pDeclaration) {
            return this.collectDeclarationIfRelevant(pDeclaration, () -> super.visit(pDeclaration));
        }

        @Override
        public CAstNode visit(CComplexTypeDeclaration pDeclaration) {
            return this.collectDeclarationIfRelevant(pDeclaration, () -> super.visit(pDeclaration));
        }

        @Override
        public CAstNode visit(CTypeDefDeclaration pDeclaration) {
            return this.collectDeclarationIfRelevant(pDeclaration, () -> super.visit(pDeclaration));
        }
    }
}

