/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.util.slicing.Slice;
import org.sosy_lab.cpachecker.util.slicing.SliceExporter;
import org.sosy_lab.cpachecker.util.slicing.Slicer;
import org.sosy_lab.cpachecker.util.slicing.SlicingCriteriaExtractor;

public abstract class AbstractSlicer
implements Slicer {
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final SlicingCriteriaExtractor extractor;
    private final SliceExporter sliceExporter;

    protected AbstractSlicer(SlicingCriteriaExtractor pExtractor, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Configuration pConfig) throws InvalidConfigurationException {
        this.extractor = pExtractor;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.sliceExporter = new SliceExporter(pConfig, pLogger);
    }

    @Override
    public Slice getSlice(CFA pCfa, Specification pSpecification) throws InterruptedException {
        Set<CFAEdge> slicingCriteria = this.extractor.getSlicingCriteria(pCfa, pSpecification, this.shutdownNotifier, this.logger);
        if (slicingCriteria.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"No slicing criteria extracted"});
        }
        return this.getSlice(pCfa, slicingCriteria);
    }

    @Override
    public Slice getSlice(CFA pCfa, Collection<CFAEdge> pSlicingCriteria) throws InterruptedException {
        Slice slice = this.getSlice0(pCfa, pSlicingCriteria);
        this.sliceExporter.execute(slice);
        return slice;
    }

    protected abstract Slice getSlice0(CFA var1, Collection<CFAEdge> var2) throws InterruptedException;
}

