/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.automaton.CachingTargetLocationProvider;
import org.sosy_lab.cpachecker.util.slicing.SlicingCriteriaExtractor;

public class AllTargetsExtractor
implements SlicingCriteriaExtractor {
    @Override
    public Set<CFAEdge> getSlicingCriteria(CFA pCfa, Specification pError, ShutdownNotifier shutdownNotifier, LogManager logger) throws InterruptedException {
        CachingTargetLocationProvider targetProvider = new CachingTargetLocationProvider(shutdownNotifier, logger, pCfa);
        ImmutableSet<CFANode> targetLocations = targetProvider.tryGetAutomatonTargetLocations(pCfa.getMainFunction(), pError);
        if (targetLocations.isEmpty()) {
            logger.logf(Level.WARNING, "No target locations for specification: %s", new Object[]{pError});
        }
        return FluentIterable.from(targetLocations).transformAndConcat(CFAUtils::allEnteringEdges).toSet();
    }
}

