/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.slicing.AbstractSlice;
import org.sosy_lab.cpachecker.util.slicing.AbstractSlicer;
import org.sosy_lab.cpachecker.util.slicing.Slice;
import org.sosy_lab.cpachecker.util.slicing.SlicingCriteriaExtractor;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class IdentitySlicer
extends AbstractSlicer {
    IdentitySlicer(SlicingCriteriaExtractor pExtractor, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Configuration pConfig) throws InvalidConfigurationException {
        super(pExtractor, pLogger, pShutdownNotifier, pConfig);
    }

    @Override
    public Slice getSlice0(CFA pCfa, Collection<CFAEdge> pSlicingCriteria) {
        CFATraversal.EdgeCollectingCFAVisitor cfaVisitor = new CFATraversal.EdgeCollectingCFAVisitor();
        CFATraversal.dfs().traverseOnce(pCfa.getMainFunction(), cfaVisitor);
        List<CFAEdge> relevantEdges = cfaVisitor.getVisitedEdges();
        ImmutableSet<ASimpleDeclaration> relevantDeclarations = AbstractSlice.computeRelevantDeclarations(relevantEdges, declaration -> true);
        return new AbstractSlice(pCfa, pSlicingCriteria, relevantEdges, (Set)relevantDeclarations){

            @Override
            public boolean isRelevantDef(CFAEdge pEdge, MemoryLocation pMemoryLocation) {
                Preconditions.checkNotNull((Object)pEdge, (Object)"pEdge must not be null");
                Preconditions.checkNotNull((Object)pMemoryLocation, (Object)"pEdge must not be null");
                Preconditions.checkArgument((boolean)this.getRelevantEdges().contains((Object)pEdge), (Object)"pEdge is not relevant to this program slice");
                return true;
            }

            @Override
            public boolean isRelevantUse(CFAEdge pEdge, MemoryLocation pMemoryLocation) {
                Preconditions.checkNotNull((Object)pEdge, (Object)"pEdge must not be null");
                Preconditions.checkNotNull((Object)pMemoryLocation, (Object)"pEdge must not be null");
                Preconditions.checkArgument((boolean)this.getRelevantEdges().contains((Object)pEdge), (Object)"pEdge is not relevant to this program slice");
                return true;
            }
        };
    }
}

