/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.util.slicing.AllTargetsExtractor;

@Options(prefix="slicing")
public class ReducerExtractor
extends AllTargetsExtractor {
    private final Configuration config;
    @Option(secure=true, name="conditionFiles", description="path to condition files plus additional assumption guiding automaton when condition itself is in propriertary format and not in witness format")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Set<Path> conditionFiles = ImmutableSet.of((Object)Path.of("output/AssumptionAutomaton.txt", new String[0]), (Object)Classes.getCodeLocation(ReducerExtractor.class).resolveSibling("config/specification/AssumptionGuidingAutomaton.spc"));

    public ReducerExtractor(Configuration pConfig) throws InvalidConfigurationException {
        this.config = pConfig;
        pConfig.inject((Object)this);
    }

    @Override
    public Set<CFAEdge> getSlicingCriteria(CFA pCfa, Specification pError, ShutdownNotifier shutdownNotifier, LogManager logger) throws InterruptedException {
        Specification compositeSpec;
        try {
            compositeSpec = pError.withAdditionalSpecificationFile(this.conditionFiles, pCfa, this.config, logger, shutdownNotifier);
        }
        catch (InvalidConfigurationException e) {
            logger.logException(Level.WARNING, (Throwable)e, "Failed to build composite specification of condition and property specification. Continue with property specification only.");
            compositeSpec = pError;
        }
        return super.getSlicingCriteria(pCfa, compositeSpec, shutdownNotifier, logger);
    }
}

