/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import org.sosy_lab.common.Concurrency;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.cwriter.CFAToCTranslator;
import org.sosy_lab.cpachecker.util.slicing.Slice;
import org.sosy_lab.cpachecker.util.slicing.SliceToCfaConversion;

@Options(prefix="slicing")
public class SliceExporter {
    @Option(secure=true, name="exportToC.enable", description="Whether to export slices as C program files")
    private boolean exportToC = false;
    @Option(secure=true, name="exportToC.file", description="File template for exported C program slices")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportToCFile = PathTemplate.ofFormatString((String)"programSlice.%d.c");
    @Option(secure=true, name="exportToDot.enable", description="Whether to export program slices as DOT files.")
    private boolean exportToDot = true;
    @Option(secure=true, name="exportToDot.file", description="File template for exported program slice DOT files.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportToDotFile = PathTemplate.ofFormatString((String)"programSlice.%d.dot");
    @Option(secure=true, name="exportCriteria.enable", description="Export the used slicing criteria to file")
    private boolean exportCriteria = false;
    @Option(secure=true, name="exportCriteria.file", description="File template for export of used slicing criteria")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportCriteriaFile = PathTemplate.ofFormatString((String)"programSlice.%d.criteria.txt");
    private final Configuration config;
    private final LogManager logger;
    private int exportCount = 0;
    private final CFAToCTranslator translator;

    public SliceExporter(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.translator = new CFAToCTranslator(pConfig);
        this.config = pConfig;
        this.logger = pLogger;
    }

    private void exportToC(Slice pSlice, Path pPath) {
        CFA sliceCfa = SliceToCfaConversion.convert(this.config, this.logger, pSlice);
        try (Writer writer = IO.openOutputFile((Path)pPath, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            String code = this.translator.translateCfa(sliceCfa);
            writer.write(code);
        }
        catch (IOException | InvalidConfigurationException | CPAException ex) {
            this.logger.logUserException(Level.WARNING, ex, "Could not write program slice to C file: " + pPath);
        }
    }

    private void exportAsDotFile(Slice pSlice, Path pPath) {
        CFA sliceCfa = SliceToCfaConversion.convert(this.config, this.logger, pSlice);
        try (Writer writer = IO.openOutputFile((Path)pPath, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            DOTBuilder.generateDOT(writer, sliceCfa);
        }
        catch (IOException ex) {
            this.logger.logUserException(Level.WARNING, (Throwable)ex, "Could not write program slice to DOT file: " + pPath);
        }
    }

    private void exportCriteria(Slice pSlice, Path pPath) {
        try (Writer writer = IO.openOutputFile((Path)pPath, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            for (CFAEdge edge : pSlice.getSlicingCriteria()) {
                FileLocation fileLoc = edge.getFileLocation();
                writer.append(String.valueOf(fileLoc.getFileName()));
                writer.append(":");
                writer.append(String.valueOf(fileLoc.getStartingLineNumber()));
                writer.append(":");
                writer.append(edge.getCode());
                writer.append("\n");
            }
        }
        catch (IOException ex) {
            this.logger.logUserException(Level.WARNING, (Throwable)ex, "Could not write slicing criteria to file: " + pPath);
        }
    }

    private void export(Slice pSlice, int pCurrentExportCount) {
        if (this.exportToC && this.exportToCFile != null) {
            this.exportToC(pSlice, this.exportToCFile.getPath(new Object[]{pCurrentExportCount}));
        }
        if (this.exportToDot && this.exportToDotFile != null) {
            this.exportAsDotFile(pSlice, this.exportToDotFile.getPath(new Object[]{pCurrentExportCount}));
        }
        if (this.exportCriteria && this.exportCriteriaFile != null) {
            this.exportCriteria(pSlice, this.exportCriteriaFile.getPath(new Object[]{pCurrentExportCount}));
        }
    }

    public void execute(Slice pSlice) {
        int currentExportCount = this.exportCount++;
        Concurrency.newThread((String)"Slice-Exporter", () -> this.export(pSlice, currentExportCount)).start();
    }
}

