/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CCfaTransformer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CfaMutableNetwork;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.AbstractTransformingCAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFASimplifier;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.slicing.Slice;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

final class SliceToCfaConversion {
    private static final String IRRELEVANT_EDGE_DESCRIPTION = "edge irrelevant to program slice";

    private SliceToCfaConversion() {
    }

    private static CFAEdge createNoopBlankEdge(CFAEdge pEdge) {
        return new BlankEdge(IRRELEVANT_EDGE_DESCRIPTION, pEdge.getFileLocation(), pEdge.getPredecessor(), pEdge.getSuccessor(), IRRELEVANT_EDGE_DESCRIPTION);
    }

    private static boolean isIrrelevantFunctionEdge(ImmutableSet<AFunctionDeclaration> pRelevantFunctions, CFAEdge pEdge) {
        return !pRelevantFunctions.contains((Object)pEdge.getPredecessor().getFunction()) || !pRelevantFunctions.contains((Object)pEdge.getSuccessor().getFunction());
    }

    private static boolean isIrrelevantNode(ImmutableSet<AFunctionDeclaration> pRelevantFunctions, CfaMutableNetwork pGraph, CFANode pNode) {
        if (pNode instanceof FunctionExitNode) {
            return !pRelevantFunctions.contains((Object)pNode.getFunction());
        }
        return pGraph.adjacentNodes(pNode).isEmpty();
    }

    private static boolean isReplaceableEdge(CFAEdge pEdge) {
        return !(pEdge instanceof FunctionCallEdge) && !(pEdge instanceof FunctionReturnEdge) && !(pEdge instanceof AssumeEdge);
    }

    private static BiFunction<CFANode, CAstNode, @Nullable CAstNode> createAstNodeSubstitutionForCfaNodes(Slice pSlice, Function<AFunctionDeclaration, @Nullable FunctionEntryNode> pFunctionToEntryNode) {
        RelevantFunctionDeclarationTransformingVisitor transformingVisitor = new RelevantFunctionDeclarationTransformingVisitor(pSlice, pFunctionToEntryNode);
        return (cfaNode, astNode) -> {
            CFunctionDeclaration functionDeclaration = (CFunctionDeclaration)cfaNode.getFunction();
            CFunctionDeclaration relevantFunctionDeclaration = (CFunctionDeclaration)functionDeclaration.accept(transformingVisitor);
            if (astNode instanceof AFunctionDeclaration) {
                return relevantFunctionDeclaration;
            }
            if (cfaNode instanceof CFunctionEntryNode && astNode instanceof CVariableDeclaration) {
                if (relevantFunctionDeclaration.getType().getReturnType() != CVoidType.VOID) {
                    return ((CFunctionEntryNode)cfaNode).getReturnVariable().orElseThrow();
                }
                return null;
            }
            return astNode;
        };
    }

    private static BiFunction<CFAEdge, CAstNode, CAstNode> createAstNodeSubstitutionForCfaEdges(Slice pSlice, Function<AFunctionDeclaration, @Nullable FunctionEntryNode> pFunctionToEntryNode) {
        return (edge, astNode) -> {
            if (pSlice.getRelevantEdges().contains(edge)) {
                RelevantCAstNodeTransformingVisitor transformingVisitor = new RelevantCAstNodeTransformingVisitor(pSlice, pFunctionToEntryNode, (CFAEdge)edge);
                return astNode.accept(transformingVisitor);
            }
            return astNode;
        };
    }

    private static CFA createSimplifiedCfa(CFA pCfa) {
        TreeMap<String, FunctionEntryNode> functionEntryNodes = new TreeMap<String, FunctionEntryNode>();
        TreeMultimap allNodes = TreeMultimap.create();
        for (CFANode node : pCfa.getAllNodes()) {
            String functionName = node.getFunction().getQualifiedName();
            allNodes.put((Object)functionName, (Object)node);
            if (!(node instanceof FunctionEntryNode)) continue;
            functionEntryNodes.put(functionName, (FunctionEntryNode)node);
        }
        MutableCFA mutableSliceCfa = new MutableCFA(pCfa.getMachineModel(), functionEntryNodes, (TreeMultimap<String, CFANode>)allNodes, pCfa.getMainFunction(), pCfa.getFileNames(), pCfa.getLanguage());
        CFASimplifier.simplifyCFA(mutableSliceCfa);
        return mutableSliceCfa.makeImmutableCFA(mutableSliceCfa.getVarClassification());
    }

    public static CFA convert(Configuration pConfig, LogManager pLogger, Slice pSlice) {
        ImmutableSet<CFAEdge> relevantEdges = pSlice.getRelevantEdges();
        ImmutableSet relevantFunctions = Collections3.transformedImmutableSetCopy(relevantEdges, edge -> edge.getSuccessor().getFunction());
        CfaMutableNetwork graph = CfaMutableNetwork.of(pSlice.getOriginalCfa());
        ImmutableList irrelevantFunctionEdges = (ImmutableList)graph.edges().stream().filter(edge -> SliceToCfaConversion.isIrrelevantFunctionEdge((ImmutableSet<AFunctionDeclaration>)relevantFunctions, edge)).collect(ImmutableList.toImmutableList());
        irrelevantFunctionEdges.forEach(graph::removeEdge);
        ImmutableList irrelevantEdges = (ImmutableList)graph.edges().stream().filter(edge -> !relevantEdges.contains(edge) && SliceToCfaConversion.isReplaceableEdge(edge)).collect(ImmutableList.toImmutableList());
        irrelevantEdges.forEach(edge -> graph.replace((CFAEdge)edge, SliceToCfaConversion.createNoopBlankEdge(edge)));
        ImmutableList irrelevantNodes = (ImmutableList)graph.nodes().stream().filter(node -> SliceToCfaConversion.isIrrelevantNode((ImmutableSet<AFunctionDeclaration>)relevantFunctions, graph, node)).collect(ImmutableList.toImmutableList());
        irrelevantNodes.forEach(graph::removeNode);
        ImmutableMap functionToEntryNodeMap = (ImmutableMap)pSlice.getOriginalCfa().getAllFunctionHeads().stream().collect(ImmutableMap.toImmutableMap(entryNode -> entryNode.getFunction(), entryNode -> entryNode));
        if (relevantEdges.isEmpty()) {
            FunctionEntryNode mainEntryNode = pSlice.getOriginalCfa().getMainFunction();
            graph.addNode(mainEntryNode);
            graph.addNode(mainEntryNode.getExitNode());
            return CCfaTransformer.createCfa(pConfig, pLogger, pSlice.getOriginalCfa(), graph, (cfaEdge, astNode) -> astNode, (cfaNode, astNode) -> astNode);
        }
        CFA sliceCfa = CCfaTransformer.createCfa(pConfig, pLogger, pSlice.getOriginalCfa(), graph, SliceToCfaConversion.createAstNodeSubstitutionForCfaEdges(pSlice, arg_0 -> ((ImmutableMap)functionToEntryNodeMap).get(arg_0)), SliceToCfaConversion.createAstNodeSubstitutionForCfaNodes(pSlice, arg_0 -> ((ImmutableMap)functionToEntryNodeMap).get(arg_0)));
        return SliceToCfaConversion.createSimplifiedCfa(sliceCfa);
    }

    private static final class RelevantCAstNodeTransformingVisitor
    extends RelevantFunctionDeclarationTransformingVisitor {
        private static final String IRRELEVANT_VALUE_PREFIX = "__IRRELEVANT_VALUE_";
        private final Slice slice;
        private final CFAEdge edge;

        private RelevantCAstNodeTransformingVisitor(Slice pSlice, Function<AFunctionDeclaration, @Nullable FunctionEntryNode> pFunctionToEntryNode, CFAEdge pEdge) {
            super(pSlice, pFunctionToEntryNode);
            this.slice = pSlice;
            this.edge = pEdge;
        }

        @Override
        public CAstNode visit(CVariableDeclaration pVariableDeclaration) {
            MemoryLocation memoryLocation = MemoryLocation.forDeclaration(pVariableDeclaration);
            CInitializer initializer = pVariableDeclaration.getInitializer();
            if (initializer != null && this.slice.isRelevantDef(this.edge, memoryLocation)) {
                return super.visit(pVariableDeclaration);
            }
            return new CVariableDeclaration(pVariableDeclaration.getFileLocation(), pVariableDeclaration.isGlobal(), pVariableDeclaration.getCStorageClass(), pVariableDeclaration.getType(), pVariableDeclaration.getName(), pVariableDeclaration.getOrigName(), pVariableDeclaration.getQualifiedName(), null);
        }

        @Override
        public CAstNode visit(CFunctionCallExpression pFunctionCallExpression) {
            ImmutableSet<ASimpleDeclaration> relevantDeclarations = this.slice.getRelevantDeclarations();
            CFunctionDeclaration functionDeclaration = pFunctionCallExpression.getDeclaration();
            List<CParameterDeclaration> parameters = functionDeclaration.getParameters();
            List<CExpression> arguments = pFunctionCallExpression.getParameterExpressions();
            ImmutableList.Builder relevantArgumentsBuilder = ImmutableList.builder();
            for (int index = 0; index < arguments.size(); ++index) {
                CExpression argument = arguments.get(index);
                if (index >= parameters.size() && relevantDeclarations.contains(Iterables.getLast(parameters))) {
                    assert (functionDeclaration.getType().takesVarArgs());
                    relevantArgumentsBuilder.add((Object)((CExpression)argument.accept(this)));
                    continue;
                }
                CParameterDeclaration parameter = parameters.get(index);
                MemoryLocation parameterMemLoc = MemoryLocation.forDeclaration(parameter);
                if (relevantDeclarations.contains((Object)parameter)) {
                    if (this.slice.isRelevantDef(this.edge, parameterMemLoc)) {
                        relevantArgumentsBuilder.add((Object)((CExpression)argument.accept(this)));
                        continue;
                    }
                    String irrelevantValueVariableName = String.format("%s%d_%d_%d", IRRELEVANT_VALUE_PREFIX, this.edge.getPredecessor().getNodeNumber(), this.edge.getSuccessor().getNodeNumber(), index);
                    CVariableDeclaration irrelevantValueVariableDeclaration = new CVariableDeclaration(argument.getFileLocation(), false, CStorageClass.AUTO, argument.getExpressionType(), irrelevantValueVariableName, irrelevantValueVariableName, irrelevantValueVariableName, null);
                    CIdExpression irrelevantValueExpression = new CIdExpression(argument.getFileLocation(), irrelevantValueVariableDeclaration);
                    relevantArgumentsBuilder.add((Object)irrelevantValueExpression);
                    continue;
                }
                assert (!this.slice.isRelevantDef(this.edge, parameterMemLoc)) : "Argument is relevant but corresponding parameter is not";
            }
            CFunctionDeclaration relevantFunctionDeclaration = (CFunctionDeclaration)functionDeclaration.accept(this);
            return new CFunctionCallExpression(pFunctionCallExpression.getFileLocation(), relevantFunctionDeclaration.getType().getReturnType(), (CExpression)pFunctionCallExpression.getFunctionNameExpression().accept(this), (List<CExpression>)relevantArgumentsBuilder.build(), relevantFunctionDeclaration);
        }

        @Override
        public CAstNode visit(CFunctionCallAssignmentStatement pFunctionCallAssignmentStatement) {
            CFunctionCallExpression relevantFunctionCallExpression = (CFunctionCallExpression)pFunctionCallAssignmentStatement.getRightHandSide().accept(this);
            CFunctionDeclaration relevantFunctionDeclaration = relevantFunctionCallExpression.getDeclaration();
            if (relevantFunctionDeclaration.getType().getReturnType() == CVoidType.VOID) {
                return new CFunctionCallStatement(pFunctionCallAssignmentStatement.getFileLocation(), relevantFunctionCallExpression);
            }
            return new CFunctionCallAssignmentStatement(pFunctionCallAssignmentStatement.getFileLocation(), (CLeftHandSide)pFunctionCallAssignmentStatement.getLeftHandSide().accept(this), relevantFunctionCallExpression);
        }
    }

    private static class RelevantFunctionDeclarationTransformingVisitor
    extends AbstractTransformingCAstNodeVisitor<NoException> {
        private final Slice slice;
        private final Function<AFunctionDeclaration, @Nullable FunctionEntryNode> functionToEntryNode;

        private RelevantFunctionDeclarationTransformingVisitor(Slice pSlice, Function<AFunctionDeclaration, @Nullable FunctionEntryNode> pFunctionToEntryNode) {
            this.slice = pSlice;
            this.functionToEntryNode = pFunctionToEntryNode;
        }

        @Override
        public CAstNode visit(CFunctionDeclaration pFunctionDeclaration) {
            @Nullable FunctionEntryNode entryNode = this.functionToEntryNode.apply(pFunctionDeclaration);
            if (entryNode == null) {
                return pFunctionDeclaration;
            }
            ImmutableSet<ASimpleDeclaration> relevantDeclarations = this.slice.getRelevantDeclarations();
            List<CParameterDeclaration> parameters = pFunctionDeclaration.getParameters();
            ImmutableList relevantParameters = (ImmutableList)parameters.stream().filter(arg_0 -> relevantDeclarations.contains(arg_0)).map(parameter -> (CParameterDeclaration)parameter.accept(this)).collect(ImmutableList.toImmutableList());
            CType relevantReturnType = entryNode.getReturnVariable().map(returnVariable -> (CVariableDeclaration)returnVariable).filter(arg_0 -> relevantDeclarations.contains(arg_0)).map(variable -> variable.getType()).orElse(CVoidType.VOID);
            CFunctionType functionType = pFunctionDeclaration.getType();
            boolean relevantTakesVarargs = functionType.takesVarArgs() && !parameters.isEmpty() && relevantDeclarations.contains(Iterables.getLast(parameters));
            CFunctionTypeWithNames relevantFunctionType = new CFunctionTypeWithNames(relevantReturnType, (List<CParameterDeclaration>)relevantParameters, relevantTakesVarargs);
            return new CFunctionDeclaration(pFunctionDeclaration.getFileLocation(), relevantFunctionType, pFunctionDeclaration.getName(), pFunctionDeclaration.getOrigName(), (List<CParameterDeclaration>)relevantParameters, pFunctionDeclaration.getAttributes());
        }
    }
}

