/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import java.util.ArrayList;
import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.dependencegraph.CSystemDependenceGraph;
import org.sosy_lab.cpachecker.util.dependencegraph.CSystemDependenceGraphBuilder;
import org.sosy_lab.cpachecker.util.slicing.AllTargetsExtractor;
import org.sosy_lab.cpachecker.util.slicing.IdentitySlicer;
import org.sosy_lab.cpachecker.util.slicing.ReducerExtractor;
import org.sosy_lab.cpachecker.util.slicing.Slicer;
import org.sosy_lab.cpachecker.util.slicing.SlicingCriteriaExtractor;
import org.sosy_lab.cpachecker.util.slicing.StaticSlicer;
import org.sosy_lab.cpachecker.util.slicing.SyntaxExtractor;

public class SlicerFactory
implements StatisticsProvider {
    private final Collection<Statistics> stats = new ArrayList<Statistics>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CSystemDependenceGraph createDependenceGraph(LogManager pLogger, ShutdownNotifier pShutdownNotifier, Configuration pConfig, CFA pCfa) throws CPAException, InvalidConfigurationException, InterruptedException {
        CSystemDependenceGraphBuilder depGraphBuilder = new CSystemDependenceGraphBuilder(pCfa, pConfig, pLogger, pShutdownNotifier);
        try {
            CSystemDependenceGraph cSystemDependenceGraph = depGraphBuilder.build();
            return cSystemDependenceGraph;
        }
        finally {
            depGraphBuilder.collectStatistics(this.stats);
        }
    }

    public Slicer create(LogManager pLogger, ShutdownNotifier pShutdownNotifier, Configuration pConfig, CFA pCfa) throws CPAException, InvalidConfigurationException, InterruptedException {
        SlicingCriteriaExtractor extractor;
        SlicerOptions options = new SlicerOptions(pConfig);
        ExtractorType extractorType = options.getExtractorType();
        switch (extractorType) {
            case ALL: {
                extractor = new AllTargetsExtractor();
                break;
            }
            case REDUCER: {
                extractor = new ReducerExtractor(pConfig);
                break;
            }
            case SYNTAX: {
                extractor = new SyntaxExtractor(pConfig, pCfa, pLogger, pShutdownNotifier);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled criterion extractor type " + extractorType));
            }
        }
        SlicingType slicingType = options.getSlicingType();
        switch (slicingType) {
            case STATIC: {
                CSystemDependenceGraph dependenceGraph = this.createDependenceGraph(pLogger, pShutdownNotifier, pConfig, pCfa);
                return new StaticSlicer(extractor, pLogger, pShutdownNotifier, pConfig, dependenceGraph, options.partiallyRelevantEdges);
            }
            case IDENTITY: {
                return new IdentitySlicer(extractor, pLogger, pShutdownNotifier, pConfig);
            }
        }
        throw new AssertionError((Object)("Unhandled slicing type " + slicingType));
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.addAll(this.stats);
    }

    @Options(prefix="slicing")
    public static class SlicerOptions {
        @Option(name="extractor", secure=true, description="which type of extractor for slicing criteria to use")
        private ExtractorType extractorType = ExtractorType.ALL;
        @Option(secure=true, name="type", description="what kind of slicing to use")
        private SlicingType slicingType = SlicingType.STATIC;
        @Option(secure=true, name="partiallyRelevantEdges", description="Whether to allow edges in the resulting slice that are only partially relevant (e.g. function calls where not every parameter is relevant). Setting this parameter to true can decrease the size of the resulting slice.")
        private boolean partiallyRelevantEdges = true;

        public SlicerOptions(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
        }

        public ExtractorType getExtractorType() {
            return this.extractorType;
        }

        public SlicingType getSlicingType() {
            return this.slicingType;
        }
    }

    private static enum SlicingType {
        STATIC,
        IDENTITY;

    }

    private static enum ExtractorType {
        ALL,
        REDUCER,
        SYNTAX;

    }
}

