/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.CSystemDependenceGraph;
import org.sosy_lab.cpachecker.util.dependencegraph.SystemDependenceGraph;
import org.sosy_lab.cpachecker.util.slicing.AbstractSlice;
import org.sosy_lab.cpachecker.util.slicing.AbstractSlicer;
import org.sosy_lab.cpachecker.util.slicing.Slice;
import org.sosy_lab.cpachecker.util.slicing.SlicingCriteriaExtractor;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class StaticSlicer
extends AbstractSlicer
implements StatisticsProvider {
    private final CSystemDependenceGraph sdg;
    private final StatCounter sliceCount = new StatCounter("Number of slicing procedures");
    private final StatTimer slicingTime = new StatTimer(StatKind.SUM, "Time needed for slicing");
    private final StatInt sliceEdgesNumber = new StatInt(StatKind.MAX, "Number of relevant slice edges");
    private final StatInt programEdgesNumber = new StatInt(StatKind.MAX, "Number of program edges");
    private final boolean partiallyRelevantEdges;

    StaticSlicer(SlicingCriteriaExtractor pExtractor, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Configuration pConfig, CSystemDependenceGraph pSdg, boolean pPartiallyRelevantEdges) throws InvalidConfigurationException {
        super(pExtractor, pLogger, pShutdownNotifier, pConfig);
        if (pSdg == null) {
            throw new InvalidConfigurationException("Dependence graph required, but missing");
        }
        this.sdg = pSdg;
        this.partiallyRelevantEdges = pPartiallyRelevantEdges;
    }

    private Function<CFAEdge, Iterable<CSystemDependenceGraph.Node>> createCfaEdgeToSdgNodesFunction() {
        ArrayListMultimap nodesPerCfaNode = ArrayListMultimap.create();
        for (CSystemDependenceGraph.Node node : this.sdg.getNodes()) {
            Optional optCfaEdge = node.getStatement();
            if (!optCfaEdge.isPresent()) continue;
            nodesPerCfaNode.put((Object)((CFAEdge)optCfaEdge.orElseThrow()), (Object)node);
        }
        return arg_0 -> StaticSlicer.lambda$createCfaEdgeToSdgNodesFunction$0((Multimap)nodesPerCfaNode, arg_0);
    }

    @Override
    public Slice getSlice0(CFA pCfa, Collection<CFAEdge> pSlicingCriteria) throws InterruptedException {
        this.slicingTime.start();
        LinkedHashSet<CFAEdge> criteriaEdges = new LinkedHashSet<CFAEdge>(pSlicingCriteria);
        LinkedHashSet<CSystemDependenceGraph.Node> startNodes = new LinkedHashSet<CSystemDependenceGraph.Node>();
        Function<CFAEdge, Iterable<CSystemDependenceGraph.Node>> cfaEdgeToSdgNodes = this.createCfaEdgeToSdgNodesFunction();
        for (CFAEdge criteriaEdge : criteriaEdges) {
            Iterables.addAll(startNodes, cfaEdgeToSdgNodes.apply(criteriaEdge));
        }
        Phase1Visitor phase1Visitor = new Phase1Visitor();
        this.sdg.traverse(startNodes, this.sdg.createVisitOnceVisitor(phase1Visitor));
        LinkedHashSet<CFAEdge> relevantEdges = new LinkedHashSet<CFAEdge>(phase1Visitor.getRelevantEdges());
        startNodes.clear();
        if (this.partiallyRelevantEdges) {
            startNodes.addAll(phase1Visitor.getVisitedSdgNodes());
        } else {
            for (CFAEdge criteriaEdge : relevantEdges) {
                Iterables.addAll(startNodes, cfaEdgeToSdgNodes.apply(criteriaEdge));
            }
        }
        Phase2Visitor phase2Visitor = new Phase2Visitor(relevantEdges);
        this.sdg.traverse(startNodes, this.sdg.createVisitOnceVisitor(phase2Visitor));
        relevantEdges.addAll(phase2Visitor.getRelevantEdges());
        Sets.SetView relevantSdgNodes = Sets.union(phase1Visitor.getVisitedSdgNodes(), phase2Visitor.getVisitedSdgNodes());
        SdgProgramSlice slice = new SdgProgramSlice(pCfa, this.sdg, cfaEdgeToSdgNodes, (ImmutableSet<CSystemDependenceGraph.Node>)ImmutableSet.copyOf((Collection)relevantSdgNodes), (ImmutableCollection<CFAEdge>)ImmutableSet.copyOf(criteriaEdges), (ImmutableSet<CFAEdge>)ImmutableSet.copyOf(relevantEdges));
        this.slicingTime.stop();
        this.sliceCount.inc();
        this.sliceEdgesNumber.setNextValue(relevantEdges.size());
        if (this.programEdgesNumber.getValueCount() == 0L) {
            this.programEdgesNumber.setNextValue(this.countProgramEdges(pCfa));
        }
        return slice;
    }

    private int countProgramEdges(CFA pCfa) {
        int programEdgeCounter = 0;
        for (CFANode node : pCfa.getAllNodes()) {
            programEdgeCounter += CFAUtils.allLeavingEdges(node).size();
        }
        return programEdgeCounter;
    }

    private double getSliceProgramRatio() {
        double sliceEdges = this.sliceEdgesNumber.getMaxValue();
        double programEdges = this.programEdgesNumber.getMaxValue();
        return programEdges > 0.0 ? sliceEdges / programEdges : 1.0;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(new Statistics(){

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
                writer.put(StaticSlicer.this.sliceCount).put(StaticSlicer.this.slicingTime);
                writer.put(StaticSlicer.this.sliceEdgesNumber).put(StaticSlicer.this.programEdgesNumber);
                writer.put("Largest slice / program ratio", String.format(Locale.US, "%.3f", StaticSlicer.this.getSliceProgramRatio()));
            }

            @Override
            public String getName() {
                return StaticSlicer.class.getSimpleName();
            }
        });
    }

    private static /* synthetic */ Iterable lambda$createCfaEdgeToSdgNodesFunction$0(Multimap nodesPerCfaNode, CFAEdge cfaEdge) {
        return nodesPerCfaNode.get((Object)cfaEdge);
    }

    private static final class Phase2Visitor
    implements CSystemDependenceGraph.BackwardsVisitor {
        private final Set<CFAEdge> relevantEdges;
        private final Set<CSystemDependenceGraph.Node> visitedSdgNodes;

        private Phase2Visitor(Set<CFAEdge> pRelevantEdges) {
            this.relevantEdges = new LinkedHashSet<CFAEdge>(pRelevantEdges);
            this.visitedSdgNodes = new LinkedHashSet<CSystemDependenceGraph.Node>();
        }

        private Set<CFAEdge> getRelevantEdges() {
            return this.relevantEdges;
        }

        private Set<CSystemDependenceGraph.Node> getVisitedSdgNodes() {
            return this.visitedSdgNodes;
        }

        @Override
        public SystemDependenceGraph.VisitResult visitNode(CSystemDependenceGraph.Node pNode) {
            this.visitedSdgNodes.add(pNode);
            pNode.getStatement().ifPresent(this.relevantEdges::add);
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }

        @Override
        public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, CSystemDependenceGraph.Node pPredecessor, CSystemDependenceGraph.Node pSuccessor) {
            if (pSuccessor.getType() == SystemDependenceGraph.NodeType.FORMAL_IN || pType == SystemDependenceGraph.EdgeType.CALL_EDGE) {
                return SystemDependenceGraph.VisitResult.SKIP;
            }
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }
    }

    private static final class Phase1Visitor
    implements CSystemDependenceGraph.BackwardsVisitor {
        private final Set<CFAEdge> relevantEdges = new LinkedHashSet<CFAEdge>();
        private final Set<CSystemDependenceGraph.Node> visitedSdgNodes = new LinkedHashSet<CSystemDependenceGraph.Node>();

        private Phase1Visitor() {
        }

        private Set<CFAEdge> getRelevantEdges() {
            return this.relevantEdges;
        }

        private Set<CSystemDependenceGraph.Node> getVisitedSdgNodes() {
            return this.visitedSdgNodes;
        }

        @Override
        public SystemDependenceGraph.VisitResult visitNode(CSystemDependenceGraph.Node pNode) {
            this.visitedSdgNodes.add(pNode);
            pNode.getStatement().ifPresent(this.relevantEdges::add);
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }

        @Override
        public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, CSystemDependenceGraph.Node pPredecessor, CSystemDependenceGraph.Node pSuccessor) {
            if (pPredecessor.getType() == SystemDependenceGraph.NodeType.FORMAL_OUT) {
                return SystemDependenceGraph.VisitResult.SKIP;
            }
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }
    }

    private static final class SdgProgramSlice
    extends AbstractSlice {
        private final CSystemDependenceGraph sdg;
        private final Function<CFAEdge, Iterable<CSystemDependenceGraph.Node>> cfaEdgeToSdgNodes;
        private final ImmutableSet<CSystemDependenceGraph.Node> relevantSdgNodes;
        private final ImmutableSet<ActualNode> relevantActualNodes;

        private SdgProgramSlice(CFA pOriginalCfa, CSystemDependenceGraph pSdg, Function<CFAEdge, Iterable<CSystemDependenceGraph.Node>> pCfaEdgeToSdgNodes, ImmutableSet<CSystemDependenceGraph.Node> pRelevantSdgNodes, ImmutableCollection<CFAEdge> pCriteriaEdges, ImmutableSet<CFAEdge> pRelevantEdges) {
            super(pOriginalCfa, (Collection<CFAEdge>)pCriteriaEdges, (Collection<CFAEdge>)pRelevantEdges, (Set<ASimpleDeclaration>)AbstractSlice.computeRelevantDeclarations(pRelevantEdges, SdgProgramSlice.createRelevantDeclarationFilter(pRelevantSdgNodes)));
            this.sdg = pSdg;
            this.cfaEdgeToSdgNodes = pCfaEdgeToSdgNodes;
            this.relevantSdgNodes = pRelevantSdgNodes;
            this.relevantActualNodes = (ImmutableSet)pRelevantSdgNodes.stream().filter(SdgProgramSlice::isActualNode).map(x$0 -> new ActualNode((CSystemDependenceGraph.Node)x$0)).collect(ImmutableSet.toImmutableSet());
        }

        private static boolean isFormalNode(CSystemDependenceGraph.Node pNode) {
            return pNode.getType() == SystemDependenceGraph.NodeType.FORMAL_IN || pNode.getType() == SystemDependenceGraph.NodeType.FORMAL_OUT;
        }

        private static boolean isActualNode(CSystemDependenceGraph.Node pNode) {
            return pNode.getType() == SystemDependenceGraph.NodeType.ACTUAL_IN || pNode.getType() == SystemDependenceGraph.NodeType.ACTUAL_OUT;
        }

        private static Predicate<ASimpleDeclaration> createRelevantDeclarationFilter(ImmutableSet<CSystemDependenceGraph.Node> pRelevantSdgNodes) {
            ImmutableSet relevantFormalVariables = (ImmutableSet)pRelevantSdgNodes.stream().filter(SdgProgramSlice::isFormalNode).map(node -> node.getVariable()).flatMap(Optional::stream).collect(ImmutableSet.toImmutableSet());
            return declaration -> {
                if (declaration instanceof CParameterDeclaration || declaration instanceof CVariableDeclaration) {
                    return relevantFormalVariables.contains((Object)MemoryLocation.forDeclaration(declaration));
                }
                return true;
            };
        }

        private boolean isInitializerRelevant(CFAEdge pEdge) {
            var declarationEdgeSdgVisitor = new CSystemDependenceGraph.ForwardsVisitor(){
                private boolean relevantDef = false;

                private boolean isDefRelevant() {
                    return this.relevantDef;
                }

                @Override
                public SystemDependenceGraph.VisitResult visitNode(CSystemDependenceGraph.Node pNode) {
                    return relevantSdgNodes.contains((Object)pNode) ? SystemDependenceGraph.VisitResult.CONTINUE : SystemDependenceGraph.VisitResult.SKIP;
                }

                @Override
                public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, CSystemDependenceGraph.Node pPredecessor, CSystemDependenceGraph.Node pSuccessor) {
                    if (relevantSdgNodes.contains((Object)pSuccessor) && pType == SystemDependenceGraph.EdgeType.FLOW_DEPENDENCY) {
                        this.relevantDef = true;
                    }
                    return SystemDependenceGraph.VisitResult.SKIP;
                }
            };
            this.sdg.traverse(ImmutableSet.copyOf(this.cfaEdgeToSdgNodes.apply(pEdge)), this.sdg.createVisitOnceVisitor(declarationEdgeSdgVisitor));
            return declarationEdgeSdgVisitor.isDefRelevant();
        }

        @Override
        public boolean isRelevantDef(CFAEdge pEdge, MemoryLocation pMemoryLocation) {
            Preconditions.checkNotNull((Object)pEdge, (Object)"pEdge must not be null");
            Preconditions.checkNotNull((Object)pMemoryLocation, (Object)"pEdge must not be null");
            Preconditions.checkArgument((boolean)this.getRelevantEdges().contains((Object)pEdge), (Object)"pEdge is not relevant to this program slice");
            if (pEdge instanceof CDeclarationEdge) {
                CDeclaration declaration = ((CDeclarationEdge)pEdge).getDeclaration();
                if (declaration instanceof CVariableDeclaration) {
                    return this.isInitializerRelevant(pEdge);
                }
            } else if (pEdge instanceof CFunctionCallEdge || pEdge instanceof CFunctionReturnEdge || pEdge instanceof CFunctionSummaryEdge) {
                return this.relevantActualNodes.contains((Object)new ActualNode(pEdge, pMemoryLocation));
            }
            return true;
        }

        @Override
        public boolean isRelevantUse(CFAEdge pEdge, MemoryLocation pMemoryLocation) {
            Preconditions.checkNotNull((Object)pEdge, (Object)"pEdge must not be null");
            Preconditions.checkNotNull((Object)pMemoryLocation, (Object)"pEdge must not be null");
            Preconditions.checkArgument((boolean)this.getRelevantEdges().contains((Object)pEdge), (Object)"pEdge is not relevant to this program slice");
            if (pEdge instanceof CFunctionCallEdge || pEdge instanceof CFunctionReturnEdge || pEdge instanceof CFunctionSummaryEdge) {
                return this.relevantActualNodes.contains((Object)new ActualNode(pEdge, pMemoryLocation));
            }
            return true;
        }

        private static final class ActualNode {
            private final CFAEdge edge;
            private final MemoryLocation variable;

            private ActualNode(CFAEdge pEdge, MemoryLocation pVariable) {
                this.edge = pEdge;
                this.variable = pVariable;
            }

            private ActualNode(CSystemDependenceGraph.Node pNode) {
                this((CFAEdge)pNode.getStatement().orElseThrow(), (MemoryLocation)pNode.getVariable().orElseThrow());
            }

            public int hashCode() {
                return Objects.hash(this.edge, this.variable);
            }

            public boolean equals(Object pObject) {
                if (this == pObject) {
                    return true;
                }
                if (!(pObject instanceof ActualNode)) {
                    return false;
                }
                ActualNode other = (ActualNode)pObject;
                return Objects.equals(this.edge, other.edge) && Objects.equals(this.variable, other.variable);
            }
        }
    }
}

