/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.slicing;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.DummyScope;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.automaton.CachingTargetLocationProvider;
import org.sosy_lab.cpachecker.util.slicing.SlicingCriteriaExtractor;

@Options(prefix="slicing")
public class SyntaxExtractor
implements SlicingCriteriaExtractor {
    @Option(secure=true, name="conditionFile", description="path to condition file")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path conditionFile = Path.of("output/AssumptionAutomaton.txt", new String[0]);
    private final Automaton condition;

    public SyntaxExtractor(Configuration pConfig, CFA pCfa, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        List<Automaton> automata = AutomatonParser.parseAutomatonFile(this.conditionFile, pConfig, pLogger, pCfa.getMachineModel(), pCfa.getLanguage() == Language.C ? new CProgramScope(pCfa, pLogger) : DummyScope.getInstance(), pCfa.getLanguage(), pShutdownNotifier);
        try {
            this.condition = (Automaton)Iterables.getOnlyElement(automata);
        }
        catch (NoSuchElementException e) {
            throw new InvalidConfigurationException("Require exactly one condition automaton.", (Throwable)e);
        }
    }

    @Override
    public Set<CFAEdge> getSlicingCriteria(CFA pCfa, Specification pError, ShutdownNotifier pShutdownNotifier, LogManager pLogger) throws InterruptedException {
        Multimap<CFANode, CFAEdge> nodesReachingTargetEdges = this.computeReachableTargetsPerLocation(this.getTargetNodes(pCfa, pError, pShutdownNotifier, pLogger), pShutdownNotifier);
        HashSet notFoundTargets = new HashSet(nodesReachingTargetEdges.values());
        ImmutableSet.Builder relevantTargets = ImmutableSet.builder();
        Collection<CFAEdge> allEdges = this.extractAllCFAEdges(pCfa);
        for (AutomatonInternalState state : this.condition.getStates()) {
            if (state.isTarget()) continue;
            for (CFAEdge edge : allEdges) {
                if (notFoundTargets.contains(edge) && state.nontriviallyMatches(edge, pLogger)) {
                    notFoundTargets.remove(edge);
                    relevantTargets.add((Object)edge);
                } else if (state.nontriviallyMatchesAndEndsIn(edge, "__FALSE", pLogger)) {
                    relevantTargets.addAll((Iterable)nodesReachingTargetEdges.get((Object)edge.getSuccessor()));
                    notFoundTargets.removeAll(nodesReachingTargetEdges.get((Object)edge.getSuccessor()));
                }
                if (!notFoundTargets.isEmpty()) continue;
                return relevantTargets.build();
            }
        }
        return relevantTargets.build();
    }

    private Collection<CFAEdge> extractAllCFAEdges(CFA pCfa) {
        ArrayList<CFAEdge> edges = new ArrayList<CFAEdge>(2 * pCfa.getAllNodes().size());
        for (CFANode node : pCfa.getAllNodes()) {
            CFAUtils.allLeavingEdges(node).copyInto(edges);
        }
        return edges;
    }

    private Iterable<CFANode> getTargetNodes(CFA pCfa, Specification targetSpec, ShutdownNotifier pShutdown, LogManager pLogger) {
        CachingTargetLocationProvider targetProvider = new CachingTargetLocationProvider(pShutdown, pLogger, pCfa);
        return targetProvider.tryGetAutomatonTargetLocations(pCfa.getMainFunction(), targetSpec);
    }

    private Multimap<CFANode, CFAEdge> computeReachableTargetsPerLocation(Iterable<CFANode> targets, ShutdownNotifier pShutdown) throws InterruptedException {
        HashMultimap locToTargets = HashMultimap.create();
        for (CFANode target : targets) {
            pShutdown.shutdownIfNecessary();
            List<CFAEdge> allEdgesOnPathsToTarget = this.getAllEdgesOnPathToTarget(target);
            FluentIterable<CFAEdge> targetEdges = CFAUtils.allEnteringEdges(target);
            for (CFAEdge e : targetEdges) {
                this.putAllLocationsOnPathWithTarget(allEdgesOnPathsToTarget, e, (Multimap<CFANode, CFAEdge>)locToTargets);
            }
        }
        return locToTargets;
    }

    private List<CFAEdge> getAllEdgesOnPathToTarget(CFANode target) {
        CFATraversal.EdgeCollectingCFAVisitor edgeCollector = new CFATraversal.EdgeCollectingCFAVisitor();
        CFATraversal.dfs().backwards().traverseOnce(target, edgeCollector);
        return edgeCollector.getVisitedEdges();
    }

    private void putAllLocationsOnPathWithTarget(List<CFAEdge> edges, CFAEdge pTargetEdge, Multimap<CFANode, CFAEdge> locToTargets) {
        for (CFAEdge edge : edges) {
            locToTargets.put((Object)edge.getPredecessor(), (Object)pTargetEdge);
        }
    }
}

