/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGAndSMGObjects;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectsAndValues;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGSinglyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.util.SMGandValue;

public class SMG {
    private final PersistentMap<SMGObject, Boolean> smgObjects;
    private final PersistentSet<SMGValue> smgValues;
    private final PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> hasValueEdges;
    private final ImmutableMap<SMGValue, SMGPointsToEdge> pointsToEdges;
    private final BigInteger sizeOfPointer;

    public SMG(BigInteger pSizeOfPointer) {
        this.hasValueEdges = PathCopyingPersistentTreeMap.of();
        PersistentSet<SMGValue> newSMGValues = PersistentSet.of(SMGValue.zeroValue());
        newSMGValues = newSMGValues.addAndCopy(SMGValue.zeroFloatValue());
        this.smgValues = newSMGValues.addAndCopy(SMGValue.zeroDoubleValue());
        PersistentSortedMap smgObjectsTmp = PathCopyingPersistentTreeMap.of();
        this.smgObjects = smgObjectsTmp.putAndCopy((Object)SMGObject.nullInstance(), (Object)false);
        SMGPointsToEdge nullPointer = new SMGPointsToEdge(this.getNullObject(), BigInteger.ZERO, SMGTargetSpecifier.IS_REGION);
        this.pointsToEdges = ImmutableMap.of((Object)SMGValue.zeroValue(), (Object)nullPointer, (Object)SMGValue.zeroFloatValue(), (Object)nullPointer, (Object)SMGValue.zeroDoubleValue(), (Object)nullPointer);
        this.sizeOfPointer = pSizeOfPointer;
    }

    private SMG(PersistentMap<SMGObject, Boolean> pSmgObjects, PersistentSet<SMGValue> pSmgValues, PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> pHasValueEdges, ImmutableMap<SMGValue, SMGPointsToEdge> pPointsToEdges, BigInteger pSizeOfPointer) {
        this.smgObjects = pSmgObjects;
        this.smgValues = pSmgValues;
        this.hasValueEdges = pHasValueEdges;
        this.pointsToEdges = pPointsToEdges;
        this.sizeOfPointer = pSizeOfPointer;
    }

    public SMG copyAndAddObject(SMGObject pObject) {
        return new SMG((PersistentMap<SMGObject, Boolean>)this.smgObjects.putAndCopy((Object)pObject, (Object)true), this.smgValues, this.hasValueEdges, this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndAddValue(SMGValue pValue) {
        return new SMG(this.smgObjects, this.smgValues.addAndCopy(pValue), this.hasValueEdges, this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndRemoveValue(SMGValue pValue) {
        return new SMG(this.smgObjects, this.smgValues.removeAndCopy(pValue), this.hasValueEdges, this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndRemoveValues(Collection<SMGValue> pUnreachableValues) {
        SMG returnSmg = this;
        for (SMGValue smgValue : pUnreachableValues) {
            returnSmg = returnSmg.copyAndRemoveValue(smgValue);
        }
        return returnSmg;
    }

    public SMG copyAndReplaceValueForHVEdges(SMGValue oldSMGValue, SMGValue newSMGValue) {
        PersistentSortedMap newHasValueEdges = PathCopyingPersistentTreeMap.of();
        for (Map.Entry entry : this.hasValueEdges.entrySet()) {
            boolean contains = false;
            for (SMGHasValueEdge hvEdge : (PersistentSet)entry.getValue()) {
                if (!hvEdge.hasValue().equals(oldSMGValue)) continue;
                contains = true;
                PersistentSet<SMGHasValueEdge> newSet = ((PersistentSet)entry.getValue()).removeAndCopy(hvEdge).addAndCopy(new SMGHasValueEdge(newSMGValue, hvEdge.getOffset(), hvEdge.getSizeInBits()));
                newHasValueEdges = newHasValueEdges.putAndCopy((Object)((SMGObject)entry.getKey()), newSet);
            }
            if (contains) continue;
            newHasValueEdges = newHasValueEdges.putAndCopy((Object)((SMGObject)entry.getKey()), (Object)((PersistentSet)entry.getValue()));
        }
        return new SMG(this.smgObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)newHasValueEdges, this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndAddHVEdge(SMGHasValueEdge edge, SMGObject source) {
        if (this.hasValueEdges.containsKey((Object)source) && ((PersistentSet)this.hasValueEdges.getOrDefault((Object)source, PersistentSet.of())).contains(edge)) {
            return this;
        }
        PersistentSet<SMGHasValueEdge> edges = (PersistentSet<SMGHasValueEdge>)this.hasValueEdges.getOrDefault((Object)source, PersistentSet.of());
        edges = edges.addAndCopy(edge);
        return new SMG(this.smgObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)this.hasValueEdges.putAndCopy((Object)source, edges), this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndAddPTEdge(SMGPointsToEdge edge, SMGValue source) {
        assert (this.verifyPointsToEdgeSanity());
        if (this.pointsToEdges.containsKey((Object)source)) {
            if (Objects.equals(this.pointsToEdges.get((Object)source), edge)) {
                return this;
            }
            throw new RuntimeException("A SMG-points-to-edge can have only 1 target!");
        }
        ImmutableMap.Builder pointsToEdgesBuilder = ImmutableMap.builder();
        pointsToEdgesBuilder.putAll(this.pointsToEdges);
        pointsToEdgesBuilder.put((Object)source, (Object)edge);
        SMG newSMG = new SMG(this.smgObjects, this.smgValues, this.hasValueEdges, (ImmutableMap<SMGValue, SMGPointsToEdge>)pointsToEdgesBuilder.buildOrThrow(), this.sizeOfPointer);
        assert (this.verifyPointsToEdgeSanity());
        return newSMG;
    }

    public SMG copyAndSetHVEdges(PersistentSet<SMGHasValueEdge> edges, SMGObject source) {
        return new SMG(this.smgObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)this.hasValueEdges.putAndCopy((Object)source, edges), this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndAddHVEdges(Iterable<SMGHasValueEdge> edges, SMGObject source) {
        PersistentSet<SMGHasValueEdge> smgEdges = (PersistentSet<SMGHasValueEdge>)this.hasValueEdges.get((Object)source);
        for (SMGHasValueEdge edgeToAdd : edges) {
            smgEdges = smgEdges.addAndCopy(edgeToAdd);
        }
        return new SMG(this.smgObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)this.hasValueEdges.putAndCopy((Object)source, smgEdges), this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndRemoveHVEdges(Iterable<SMGHasValueEdge> edges, SMGObject source) {
        PersistentSet<SMGHasValueEdge> smgEdges = (PersistentSet<SMGHasValueEdge>)this.hasValueEdges.getOrDefault((Object)source, PersistentSet.of());
        for (SMGHasValueEdge edgeToRemove : edges) {
            smgEdges = smgEdges.removeAndCopy(edgeToRemove);
        }
        return new SMG(this.smgObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)this.hasValueEdges.putAndCopy((Object)source, smgEdges), this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndReplaceHVEdgesAt(SMGObject objectToReplace, PersistentSet<SMGHasValueEdge> newHVEdges) {
        return new SMG(this.smgObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)this.hasValueEdges.removeAndCopy((Object)objectToReplace).putAndCopy((Object)objectToReplace, newHVEdges), this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndSetPTEdges(SMGPointsToEdge edge, SMGValue source) {
        ImmutableMap.Builder pointsToEdgesBuilder = ImmutableMap.builder();
        if (this.pointsToEdges.containsKey((Object)source)) {
            for (Map.Entry entry : this.pointsToEdges.entrySet()) {
                if (!((SMGValue)entry.getKey()).equals(source)) {
                    pointsToEdgesBuilder.put(entry);
                    continue;
                }
                pointsToEdgesBuilder.put((Object)source, (Object)edge);
            }
        } else {
            pointsToEdgesBuilder.putAll(this.pointsToEdges);
            pointsToEdgesBuilder.put((Object)source, (Object)edge);
        }
        return new SMG(this.smgObjects, this.smgValues, this.hasValueEdges, (ImmutableMap<SMGValue, SMGPointsToEdge>)pointsToEdgesBuilder.buildOrThrow(), this.sizeOfPointer);
    }

    public SMG copyAndReplaceHVEdge(SMGObject pSmgObject, SMGHasValueEdge pOldEdge, SMGHasValueEdge pNewEdge) {
        PersistentSet<SMGHasValueEdge> objEdges = ((PersistentSet)this.hasValueEdges.get((Object)pSmgObject)).removeAndCopy(pOldEdge).addAndCopy(pNewEdge);
        return this.copyAndSetHVEdges(objEdges, pSmgObject);
    }

    public SMG copyAndReplaceHVEdgeAt(SMGObject pSmgObject, BigInteger offsetInBits, BigInteger sizeInBits, SMGHasValueEdge pNewEdge) {
        FluentIterable<SMGHasValueEdge> currentEdges = this.getHasValueEdgesByPredicate(pSmgObject, (Predicate<SMGHasValueEdge>)((Predicate)n -> n.getOffset().compareTo(offsetInBits) == 0 && n.getSizeInBits().compareTo(sizeInBits) == 0));
        PersistentSet<SMGHasValueEdge> objEdges = (PersistentSet<SMGHasValueEdge>)this.hasValueEdges.get((Object)pSmgObject);
        for (SMGHasValueEdge oldEdge : currentEdges) {
            objEdges = objEdges.removeAndCopy(oldEdge).addAndCopy(pNewEdge);
        }
        return this.copyAndSetHVEdges(objEdges, pSmgObject);
    }

    public SMG copyAndReplaceObject(SMGObject pOldObject, SMGObject pNewObject) {
        PersistentSet edges = (PersistentSet)this.hasValueEdges.get((Object)pOldObject);
        PersistentMap newHVEdges = this.hasValueEdges.removeAndCopy((Object)pOldObject).putAndCopy((Object)pNewObject, (Object)edges);
        ImmutableMap.Builder pointsToEdgesBuilder = ImmutableMap.builder();
        pointsToEdgesBuilder.putAll(this.pointsToEdges);
        for (Map.Entry oldEntry : this.pointsToEdges.entrySet()) {
            if (!pOldObject.equals(((SMGPointsToEdge)oldEntry.getValue()).pointsTo())) continue;
            SMGPointsToEdge newEdge = new SMGPointsToEdge(pNewObject, ((SMGPointsToEdge)oldEntry.getValue()).getOffset(), ((SMGPointsToEdge)oldEntry.getValue()).targetSpecifier());
            pointsToEdgesBuilder.put((Object)((SMGValue)oldEntry.getKey()), (Object)newEdge);
        }
        PersistentMap newObjects = this.smgObjects.removeAndCopy((Object)pOldObject).putAndCopy((Object)pNewObject, (Object)true);
        return new SMG((PersistentMap<SMGObject, Boolean>)newObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)newHVEdges, (ImmutableMap<SMGValue, SMGPointsToEdge>)pointsToEdgesBuilder.buildOrThrow(), this.sizeOfPointer);
    }

    public SMG copyAndInvalidateObject(SMGObject pObject) {
        PersistentMap newObjects = this.smgObjects.putAndCopy((Object)pObject, (Object)false);
        PersistentMap newHVEdges = this.hasValueEdges.removeAndCopy((Object)pObject);
        return new SMG((PersistentMap<SMGObject, Boolean>)newObjects, this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)newHVEdges, this.pointsToEdges, this.sizeOfPointer);
    }

    public SMG copyAndRemoveObjects(Collection<SMGObject> pUnreachableObjects) {
        SMG returnSmg = this;
        for (SMGObject smgObject : pUnreachableObjects) {
            returnSmg = returnSmg.copyAndInvalidateObject(smgObject);
        }
        return returnSmg;
    }

    public SMG copyAndRemoveDLLObjectAndReplacePointers(SMGObject object, SMGValue valueForPointerToWardsThis, SMGPointsToEdge pointerToNext, SMGPointsToEdge pointerToPrevious) {
        ImmutableMap.Builder newPointers = ImmutableMap.builder();
        PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> newHVEdges = this.hasValueEdges;
        for (Map.Entry pointsToEdgesAndValues : this.pointsToEdges.entrySet()) {
            SMGPointsToEdge pointer = (SMGPointsToEdge)pointsToEdgesAndValues.getValue();
            SMGValue value = (SMGValue)pointsToEdgesAndValues.getKey();
            if (pointer.pointsTo().equals(object) && !value.equals(valueForPointerToWardsThis)) {
                if (pointerToPrevious.pointsTo().isZero()) {
                    newHVEdges = this.replaceValueByZero(value, newHVEdges);
                    continue;
                }
                newPointers.put((Object)value, (Object)pointerToPrevious);
                continue;
            }
            if (pointer.pointsTo().equals(object) && value.equals(valueForPointerToWardsThis)) {
                if (pointerToNext.pointsTo().isZero()) {
                    newHVEdges = this.replaceValueByZero(value, newHVEdges);
                    continue;
                }
                newPointers.put((Object)value, (Object)pointerToNext);
                continue;
            }
            newPointers.put((Object)value, (Object)pointer);
        }
        return new SMG((PersistentMap<SMGObject, Boolean>)this.smgObjects.removeAndCopy((Object)object), this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)newHVEdges.removeAndCopy((Object)object), (ImmutableMap<SMGValue, SMGPointsToEdge>)newPointers.buildOrThrow(), this.sizeOfPointer);
    }

    private PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> replaceValueByZero(SMGValue old, PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> newHVEdges) {
        PersistentMap newHVE = newHVEdges;
        for (Map.Entry entry : this.smgObjects.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            for (SMGHasValueEdge hve : (PersistentSet)newHVE.get(entry.getKey())) {
                if (!hve.hasValue().equals(old)) continue;
                PersistentSet<SMGHasValueEdge> newhves = ((PersistentSet)newHVE.get(entry.getKey())).removeAndCopy(hve).addAndCopy(new SMGHasValueEdge(SMGValue.zeroValue(), hve.getOffset(), hve.getSizeInBits()));
                newHVE = newHVE.removeAndCopy(entry.getKey()).putAndCopy((Object)((SMGObject)entry.getKey()), newhves);
            }
        }
        return newHVE;
    }

    public SMG copyAndRemoveSLLObjectAndReplacePointers(SMGObject object, SMGValue valueForPointerToWardsThis, SMGPointsToEdge pointerToNext, @Nullable SMGObject prevObj) {
        ImmutableMap.Builder newPointers = ImmutableMap.builder();
        PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> newHVEdges = this.hasValueEdges;
        if (prevObj == null) {
            ImmutableSet<SMGObject> possiblePrevObj = this.getObjectsWithValue(valueForPointerToWardsThis);
            Preconditions.checkArgument((possiblePrevObj.size() == 1 ? 1 : 0) != 0);
            prevObj = (SMGObject)possiblePrevObj.iterator().next();
        }
        for (Map.Entry pointsToEdgesAndValues : this.pointsToEdges.entrySet()) {
            SMGPointsToEdge pointer = (SMGPointsToEdge)pointsToEdgesAndValues.getValue();
            SMGValue value = (SMGValue)pointsToEdgesAndValues.getKey();
            if (pointer.pointsTo().equals(object) && !value.equals(valueForPointerToWardsThis)) {
                newPointers.put((Object)value, (Object)new SMGPointsToEdge(prevObj, BigInteger.ZERO, SMGTargetSpecifier.IS_REGION));
                continue;
            }
            if (value.equals(valueForPointerToWardsThis)) {
                if (pointerToNext.pointsTo().isZero()) {
                    newHVEdges = this.replaceValueByZero(value, newHVEdges);
                    continue;
                }
                newPointers.put((Object)value, (Object)pointerToNext);
                continue;
            }
            newPointers.put((Object)value, (Object)pointer);
        }
        return new SMG((PersistentMap<SMGObject, Boolean>)this.smgObjects.removeAndCopy((Object)object), this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)newHVEdges.removeAndCopy((Object)object), (ImmutableMap<SMGValue, SMGPointsToEdge>)newPointers.buildOrThrow(), this.sizeOfPointer);
    }

    public SMGAndSMGObjects copyAndRemoveObjectAndSubSMG(SMGObject object) {
        if (!this.smgObjects.containsKey((Object)object) || !this.isValid(object)) {
            return SMGAndSMGObjects.ofEmptyObjects(this);
        }
        ImmutableMap.Builder newPointers = ImmutableMap.builder();
        ImmutableSet.Builder objectsToRemoveBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valuesToRemoveBuilder = ImmutableSet.builder();
        for (Object pointsToEntry : this.pointsToEdges.entrySet()) {
            if (((SMGPointsToEdge)pointsToEntry.getValue()).pointsTo().equals(object)) {
                valuesToRemoveBuilder.add((Object)((SMGValue)pointsToEntry.getKey()));
                continue;
            }
            newPointers.put((Map.Entry)pointsToEntry);
        }
        ImmutableSet valuesToRemove = valuesToRemoveBuilder.build();
        if (!valuesToRemove.isEmpty()) {
            for (PersistentSet hasValueEntryValue : this.hasValueEdges.values()) {
                for (SMGHasValueEdge valueEdge : hasValueEntryValue) {
                    if (!valuesToRemove.contains((Object)valueEdge.hasValue())) continue;
                    objectsToRemoveBuilder.add((Object)object);
                }
            }
        }
        SMG currentSMG = new SMG((PersistentMap<SMGObject, Boolean>)this.smgObjects.removeAndCopy((Object)object), this.smgValues, (PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>>)this.hasValueEdges.removeAndCopy((Object)object), (ImmutableMap<SMGValue, SMGPointsToEdge>)newPointers.buildOrThrow(), this.sizeOfPointer);
        ImmutableSet objectsToRemove = objectsToRemoveBuilder.build();
        ImmutableSet.Builder objectsThatHaveBeenRemovedBuilder = ImmutableSet.builder();
        objectsThatHaveBeenRemovedBuilder.add((Object)object);
        if (!objectsToRemove.isEmpty()) {
            for (SMGObject toRemove : objectsToRemove) {
                SMGAndSMGObjects newSMGAndRemoved = currentSMG.copyAndRemoveObjectAndSubSMG(toRemove);
                objectsThatHaveBeenRemovedBuilder.addAll(newSMGAndRemoved.getSMGObjects());
                currentSMG = newSMGAndRemoved.getSMG();
            }
        }
        return SMGAndSMGObjects.of(currentSMG, (Set<SMGObject>)objectsThatHaveBeenRemovedBuilder.build());
    }

    private ImmutableSet<SMGObject> getObjectsWithValue(SMGValue valueForPointerToWardsThis) {
        Map.Entry entry;
        SMGObject searchObj;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterator iterator = this.smgObjects.entrySet().iterator();
        while (iterator.hasNext() && !(searchObj = (SMGObject)(entry = (Map.Entry)iterator.next()).getKey()).isZero() && ((Boolean)entry.getValue()).booleanValue()) {
            for (SMGHasValueEdge hve : (PersistentSet)this.hasValueEdges.getOrDefault((Object)searchObj, PersistentSet.of())) {
                if (!hve.hasValue().equals(valueForPointerToWardsThis)) continue;
                builder.add((Object)searchObj);
            }
        }
        return builder.build();
    }

    public SMGObject getNullObject() {
        return SMGObject.nullInstance();
    }

    public Set<SMGObject> getObjects() {
        return this.smgObjects.keySet();
    }

    public Set<SMGValue> getValues() {
        return this.smgValues;
    }

    public Set<SMGHasValueEdge> getEdges(SMGObject pRegion) {
        return (Set)this.hasValueEdges.getOrDefault((Object)pRegion, PersistentSet.of());
    }

    public Optional<SMGHasValueEdge> getHasValueEdgeByPredicate(SMGObject object, Predicate<SMGHasValueEdge> filter) {
        return ((PersistentSet)this.hasValueEdges.getOrDefault((Object)object, PersistentSet.of())).stream().filter(filter).findAny();
    }

    public FluentIterable<SMGHasValueEdge> getHasValueEdgesByPredicate(SMGObject object, Predicate<SMGHasValueEdge> filter) {
        return FluentIterable.from((Iterable)((Iterable)this.hasValueEdges.getOrDefault((Object)object, PersistentSet.of()))).filter(filter);
    }

    public SMGandValue readValue(SMGObject object, BigInteger offset, BigInteger sizeInBits) {
        Preconditions.checkArgument((offset.add(sizeInBits).compareTo(object.getSize()) <= 0 ? 1 : 0) != 0);
        Predicate filterByOffsetAndSize = o -> o.getOffset().compareTo(offset) == 0 && o.getSizeInBits().compareTo(sizeInBits) == 0;
        Optional<SMGHasValueEdge> maybeValue = this.getHasValueEdgeByPredicate(object, (Predicate<SMGHasValueEdge>)filterByOffsetAndSize);
        if (maybeValue.isPresent()) {
            return new SMGandValue(this, maybeValue.orElseThrow().hasValue());
        }
        Optional<SMGValue> isCoveredBy = this.isCoveredByNullifiedBlocks(object, offset, sizeInBits);
        if (isCoveredBy.isPresent()) {
            return new SMGandValue(this, isCoveredBy.orElseThrow());
        }
        int nestingLevel = object.getNestingLevel();
        SMGValue newValue = SMGValue.of(nestingLevel);
        SMG newSMG = this.copyAndAddValue(newValue);
        SMGHasValueEdge newHVEdge = new SMGHasValueEdge(newValue, offset, sizeInBits);
        newSMG = newSMG.copyAndAddHVEdge(newHVEdge, object);
        return new SMGandValue(newSMG, newValue);
    }

    public SMG writeValue(SMGObject object, BigInteger offset, BigInteger sizeInBits, SMGValue value) {
        BigInteger offsetPlusSize = offset.add(sizeInBits);
        Preconditions.checkArgument((offsetPlusSize.compareTo(object.getSize()) <= 0 ? 1 : 0) != 0);
        if (value.isZero() && this.isCoveredByNullifiedBlocks(object, offset, sizeInBits).isPresent()) {
            return this;
        }
        Optional<SMGHasValueEdge> hvEdge = this.getHasValueEdgeByPredicate(object, (Predicate<SMGHasValueEdge>)((Predicate)o -> o.getOffset().compareTo(offset) == 0 && o.getSizeInBits().compareTo(sizeInBits) == 0));
        if (hvEdge.isPresent() && hvEdge.orElseThrow().hasValue().equals(value)) {
            return this;
        }
        SMG newSMG = this.copyAndAddValue(value);
        FluentIterable<SMGHasValueEdge> nonZeroOverlappingEdges = newSMG.getHasValueEdgesByPredicate(object, (Predicate<SMGHasValueEdge>)((Predicate)n -> n.getOffset().add(n.getSizeInBits()).compareTo(offset) > 0 && offsetPlusSize.compareTo(n.getOffset()) > 0 && !n.hasValue().isZero()));
        newSMG = newSMG.copyAndRemoveHVEdges((Iterable<SMGHasValueEdge>)nonZeroOverlappingEdges, object);
        if (!value.isZero()) {
            newSMG = newSMG.cutZeroValueEdgesToField(object, offset, sizeInBits);
        }
        SMGHasValueEdge newHVEdge = new SMGHasValueEdge(value, offset, sizeInBits);
        newSMG = newSMG.copyAndAddHVEdge(newHVEdge, object);
        return newSMG;
    }

    private SMG cutZeroValueEdgesToField(SMGObject object, BigInteger offset, BigInteger sizeInBits) {
        BigInteger offsetPlusSize = offset.add(sizeInBits);
        PersistentSet<SMGHasValueEdge> toRemoveEdgesSet = PersistentSet.of();
        PersistentSet<SMGHasValueEdge> toAddEdgesSet = PersistentSet.of();
        for (SMGHasValueEdge hvEdge : (PersistentSet)this.hasValueEdges.get((Object)object)) {
            BigInteger newSize;
            BigInteger hvEdgeOffsetPlusSize = hvEdge.getOffset().add(hvEdge.getSizeInBits());
            if (!hvEdge.hasValue().isZero() || hvEdge.getOffset().compareTo(offsetPlusSize) >= 0 || hvEdgeOffsetPlusSize.compareTo(offset) <= 0) continue;
            toRemoveEdgesSet = toRemoveEdgesSet.addAndCopy(hvEdge);
            if (hvEdge.getOffset().compareTo(offset) < 0) {
                newSize = this.calculateBitPreciseSize(offset, hvEdge.getOffset());
                SMGHasValueEdge newLowerEdge = new SMGHasValueEdge(SMGValue.zeroValue(), hvEdge.getOffset(), newSize);
                toAddEdgesSet = toAddEdgesSet.addAndCopy(newLowerEdge);
            }
            if (offsetPlusSize.compareTo(hvEdgeOffsetPlusSize) >= 0) continue;
            newSize = this.calculateBitPreciseSize(hvEdgeOffsetPlusSize, offsetPlusSize);
            SMGHasValueEdge newUpperEdge = new SMGHasValueEdge(SMGValue.zeroValue(), offsetPlusSize, newSize);
            toAddEdgesSet = toAddEdgesSet.addAndCopy(newUpperEdge);
        }
        return this.copyAndRemoveHVEdges(toRemoveEdgesSet, object).copyAndAddHVEdges(toAddEdgesSet, object);
    }

    private BigInteger calculateBitPreciseSize(BigInteger first, BigInteger second) {
        return first.subtract(second);
    }

    private Optional<SMGValue> isCoveredByNullifiedBlocks(SMGObject object, BigInteger offset, BigInteger size) {
        ImmutableSortedMap<BigInteger, BigInteger> nullEdgesRangeMap = this.getZeroValueEdgesForObject(object, offset, size);
        if (nullEdgesRangeMap.isEmpty()) {
            return Optional.empty();
        }
        BigInteger currentMax = (BigInteger)nullEdgesRangeMap.firstKey();
        if (currentMax.compareTo(offset) > 0) {
            return Optional.empty();
        }
        BigInteger offsetPlusSize = offset.add(size);
        currentMax = ((BigInteger)nullEdgesRangeMap.get(currentMax)).add(currentMax);
        for (Map.Entry entry : nullEdgesRangeMap.entrySet()) {
            if (currentMax.compareTo((BigInteger)entry.getKey()) < 0) {
                return Optional.empty();
            }
            if ((currentMax = currentMax.max(((BigInteger)entry.getValue()).add((BigInteger)entry.getKey()))).compareTo(offsetPlusSize) < 0) continue;
            return Optional.of(this.getHasValueEdgeByPredicate(object, (Predicate<SMGHasValueEdge>)((Predicate)hv -> hv.getOffset().compareTo((BigInteger)entry.getKey()) == 0)).orElseThrow().hasValue());
        }
        return Optional.empty();
    }

    private ImmutableSortedMap<BigInteger, BigInteger> getZeroValueEdgesForObject(SMGObject smgObject, BigInteger offset, BigInteger sizeInBits) {
        if (this.hasValueEdges.get((Object)smgObject) == null) {
            return ImmutableSortedMap.of();
        }
        BigInteger offsetPlusSize = offset.add(sizeInBits);
        return (ImmutableSortedMap)((PersistentSet)this.hasValueEdges.get((Object)smgObject)).stream().filter(n -> n.hasValue().isZero() && offsetPlusSize.compareTo(n.getOffset()) >= 0 && offset.compareTo(n.getOffset().add(n.getSizeInBits())) <= 0).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), SMGHasValueEdge::getOffset, SMGHasValueEdge::getSizeInBits, BigInteger::max));
    }

    public Collection<SMGHasValueEdge> getOverlappingEdges(SMGObject pObject, BigInteger pFieldOffset, BigInteger pSizeofInBits) {
        return this.getHasValueEdgesByPredicate(pObject, (Predicate<SMGHasValueEdge>)((Predicate)edge -> edge.getOffset().compareTo(pFieldOffset) <= 0 && edge.getOffset().add(edge.getSizeInBits()).compareTo(pFieldOffset) > 0 || edge.getOffset().compareTo(pFieldOffset) > 0 && edge.getOffset().compareTo(pFieldOffset.add(pSizeofInBits)) < 0)).toSortedSet(Comparator.comparing(SMGHasValueEdge::getOffset));
    }

    public FluentIterable<SMGDoublyLinkedListSegment> getDLLs() {
        return FluentIterable.from((Iterable)this.smgObjects.keySet()).filter(SMGDoublyLinkedListSegment.class);
    }

    public FluentIterable<SMGHasValueEdge> getHVEdges() {
        return FluentIterable.from((Iterable)this.hasValueEdges.values()).transformAndConcat(edges -> FluentIterable.from((Iterable)edges));
    }

    public FluentIterable<SMGPointsToEdge> getPTEdges() {
        return FluentIterable.from((Iterable)this.pointsToEdges.values());
    }

    public FluentIterable<SMGPointsToEdge> getPTEdgesByTarget(SMGObject pointingTo) {
        return this.getPTEdges().filter(ptEdge -> ptEdge.pointsTo().equals(pointingTo));
    }

    public Map<SMGValue, SMGPointsToEdge> getPTEdgeMapping() {
        return this.pointsToEdges;
    }

    public Optional<SMGPointsToEdge> getPTEdge(SMGValue value) {
        return Optional.ofNullable((SMGPointsToEdge)this.pointsToEdges.get((Object)value));
    }

    public boolean pointsToZeroPlus(@Nullable SMGValue value) {
        if (value == null) {
            return false;
        }
        Optional<SMGPointsToEdge> maybePTEdge = this.getPTEdge(value);
        return maybePTEdge.isPresent() && maybePTEdge.orElseThrow().pointsTo() instanceof SMGSinglyLinkedListSegment && ((SMGSinglyLinkedListSegment)maybePTEdge.orElseThrow().pointsTo()).getMinLength() == 0;
    }

    public boolean isPointer(SMGValue pValue) {
        return this.pointsToEdges.containsKey((Object)pValue);
    }

    public boolean hasOverlappingEdge(SMGHasValueEdge pHValueEdge, SMGObject pObject) {
        return this.getEdges(pObject).stream().anyMatch(other -> {
            BigInteger otherStart = other.getOffset();
            BigInteger otherEnd = otherStart.add(other.getSizeInBits());
            BigInteger pStart = pHValueEdge.getOffset();
            BigInteger pEnd = pStart.add(pHValueEdge.getSizeInBits());
            if (pStart.compareTo(otherStart) > 0) {
                return pStart.compareTo(otherEnd) < 0;
            }
            if (pStart.compareTo(otherStart) < 0) {
                return pEnd.compareTo(otherStart) > 0;
            }
            return true;
        });
    }

    public Optional<SMGValue> findAddressForEdge(SMGObject targetObject, BigInteger pOffset, SMGTargetSpecifier pTargetSpecifier) {
        return this.pointsToEdges.entrySet().stream().filter(entry -> {
            SMGPointsToEdge edge = (SMGPointsToEdge)entry.getValue();
            return edge.getOffset().equals(pOffset) && edge.targetSpecifier().equals((Object)pTargetSpecifier) && edge.pointsTo().equals(targetObject);
        }).findAny().map(entry -> (SMGValue)entry.getKey());
    }

    public ImmutableSet<SMGObject> findAllAddressesForTargetObject(SMGObject targetObject, Collection<SMGObject> heapObjects) {
        ImmutableSet.Builder ret = ImmutableSet.builder();
        for (Map.Entry entry : this.pointsToEdges.entrySet()) {
            if (!targetObject.equals(((SMGPointsToEdge)entry.getValue()).pointsTo())) continue;
            SMGValue pointerValue = (SMGValue)entry.getKey();
            for (SMGObject heapObj : heapObjects) {
                if (!this.isValid(heapObj)) continue;
                for (SMGHasValueEdge hve : (PersistentSet)this.hasValueEdges.getOrDefault((Object)heapObj, PersistentSet.of())) {
                    if (hve.hasValue() != pointerValue) continue;
                    ret.add((Object)heapObj);
                }
            }
        }
        return ret.build();
    }

    public boolean isValid(SMGObject pObject) {
        return (Boolean)this.smgObjects.getOrDefault((Object)pObject, (Object)false);
    }

    public int hashCode() {
        return Objects.hash(this.hasValueEdges, this.smgObjects, this.pointsToEdges, this.smgValues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SMG)) {
            return false;
        }
        SMG other = (SMG)obj;
        return Objects.equals(this.hasValueEdges, other.hasValueEdges) && Objects.equals(this.smgObjects, other.smgObjects) && Objects.equals(this.pointsToEdges, other.pointsToEdges) && Objects.equals(this.smgValues, other.smgValues);
    }

    public BigInteger getSizeOfPointer() {
        return this.sizeOfPointer;
    }

    public SMGObjectsAndValues collectReachableObjectsAndValues(Collection<SMGObject> pVisibleObjects) {
        HashSet<SMGObject> visitedObjects = new HashSet<SMGObject>();
        HashSet<SMGValue> visitedValues = new HashSet<SMGValue>();
        ArrayDeque<SMGObject> workDeque = new ArrayDeque<SMGObject>(pVisibleObjects);
        while (!workDeque.isEmpty()) {
            SMGObject object = (SMGObject)workDeque.pop();
            if (!visitedObjects.add(object) || !this.isValid(object)) continue;
            for (SMGHasValueEdge outgoingEdge : this.getEdges(object)) {
                SMGValue value = outgoingEdge.hasValue();
                if (!visitedValues.add(value) || !this.isPointer(value)) continue;
                SMGObject pointerTarget = this.getPTEdge(value).orElseThrow().pointsTo();
                workDeque.add(pointerTarget);
            }
        }
        return new SMGObjectsAndValues(visitedObjects, visitedValues);
    }

    public PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> getSMGObjectsWithSMGHasValueEdges() {
        return this.hasValueEdges;
    }

    public boolean sanityCheck() {
        for (Map.Entry entry : this.hasValueEdges.entrySet()) {
            SMGObject obj = (SMGObject)entry.getKey();
            PersistentSet hvEdges = (PersistentSet)entry.getValue();
            for (SMGHasValueEdge edge1 : hvEdges) {
                for (SMGHasValueEdge edge2 : hvEdges) {
                    if (edge1 == edge2 || edge1.getOffset().compareTo(edge2.getOffset()) != 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public SMG copyHVEdgesFromTo(SMGObject source, SMGObject target) {
        PersistentSet<SMGHasValueEdge> setOfValues = (PersistentSet<SMGHasValueEdge>)this.hasValueEdges.get((Object)source);
        if (setOfValues == null) {
            setOfValues = PersistentSet.of();
        }
        return this.copyAndSetHVEdges(setOfValues, target);
    }

    public SMG replaceAllPointersTowardsWith(SMGValue pointerValue, SMGObject newTarget) {
        SMGPointsToEdge oldEdge = this.getPTEdge(pointerValue).orElseThrow();
        assert (this.verifyPointsToEdgeSanity());
        SMG newSMG = this.copyAndSetPTEdges(new SMGPointsToEdge(newTarget, oldEdge.getOffset(), oldEdge.targetSpecifier()), pointerValue);
        assert (this.verifyPointsToEdgeSanity());
        return newSMG;
    }

    public SMG replaceAllPointersTowardsWith(SMGObject oldObj, SMGObject newTarget) {
        assert (this.verifyPointsToEdgeSanity());
        SMG newSMG = this;
        if (newTarget.isZero() || oldObj.isZero()) {
            throw new AssertionError((Object)"Can't replace a 0 value!");
        }
        for (Map.Entry pointsToEntry : this.pointsToEdges.entrySet()) {
            if (!((SMGPointsToEdge)pointsToEntry.getValue()).pointsTo().equals(oldObj)) continue;
            SMGValue value = (SMGValue)pointsToEntry.getKey();
            newSMG = newSMG.copyAndSetPTEdges(new SMGPointsToEdge(newTarget, ((SMGPointsToEdge)pointsToEntry.getValue()).getOffset(), ((SMGPointsToEdge)pointsToEntry.getValue()).targetSpecifier()), value);
        }
        assert (this.verifyPointsToEdgeSanity());
        return newSMG;
    }

    private boolean verifyPointsToEdgeSanity() {
        for (Map.Entry pointsToEntry2 : this.pointsToEdges.entrySet()) {
            for (Map.Entry pointsToEntry3 : this.pointsToEdges.entrySet()) {
                if (!((SMGPointsToEdge)pointsToEntry2.getValue()).equals(pointsToEntry3.getValue()) || ((SMGValue)pointsToEntry2.getKey()).equals(pointsToEntry3.getKey()) || ((SMGValue)pointsToEntry2.getKey()).isZero() || ((SMGValue)pointsToEntry2.getKey()).getNestingLevel() != ((SMGValue)pointsToEntry3.getKey()).getNestingLevel()) continue;
                return false;
            }
        }
        return true;
    }

    public SMG replaceAllPointersTowardsWithAndIncrementNestingLevel(SMGObject oldObj, SMGObject newTarget, int incrementAmount) {
        assert (this.verifyPointsToEdgeSanity());
        int min = 0;
        if (newTarget instanceof SMGSinglyLinkedListSegment) {
            min = ((SMGSinglyLinkedListSegment)newTarget).getMinLength();
        }
        SMG newSMG = this;
        if (newTarget.isZero() || oldObj.isZero()) {
            throw new AssertionError((Object)"Can't replace a 0 value!");
        }
        ImmutableSet.Builder valuesToDecrementBuilder = ImmutableSet.builder();
        for (Map.Entry pointsToEntry : this.pointsToEdges.entrySet()) {
            if (!((SMGPointsToEdge)pointsToEntry.getValue()).pointsTo().equals(oldObj)) continue;
            SMGValue value = (SMGValue)pointsToEntry.getKey();
            newSMG = newSMG.copyAndSetPTEdges(new SMGPointsToEdge(newTarget, ((SMGPointsToEdge)pointsToEntry.getValue()).getOffset(), ((SMGPointsToEdge)pointsToEntry.getValue()).targetSpecifier()), value.withNestingLevelAndCopy(value.getNestingLevel() + incrementAmount));
            assert (this.verifyPointsToEdgeSanity());
            if (min <= value.getNestingLevel() + incrementAmount) {
                Preconditions.checkArgument((min > value.getNestingLevel() + incrementAmount ? 1 : 0) != 0);
            }
            valuesToDecrementBuilder.add((Object)value);
        }
        ImmutableSet valuesToDecrement = valuesToDecrementBuilder.build();
        PersistentMap newHasValueEdges = this.hasValueEdges;
        for (Map.Entry objToHvEntry : this.hasValueEdges.entrySet()) {
            SMGObject currentObject = (SMGObject)objToHvEntry.getKey();
            boolean contains = false;
            PersistentSet<SMGHasValueEdge> hvEdges = (PersistentSet<SMGHasValueEdge>)objToHvEntry.getValue();
            for (SMGHasValueEdge hvEdge : (PersistentSet)objToHvEntry.getValue()) {
                if (!valuesToDecrement.contains((Object)hvEdge.hasValue())) continue;
                contains = true;
                hvEdges = hvEdges.removeAndCopy(hvEdge);
                hvEdges = hvEdges.addAndCopy(new SMGHasValueEdge(hvEdge.hasValue().withNestingLevelAndCopy(hvEdge.hasValue().getNestingLevel() + incrementAmount), hvEdge.getOffset(), hvEdge.getSizeInBits()));
            }
            if (!contains) continue;
            newHasValueEdges = newHasValueEdges.removeAndCopy((Object)currentObject);
            newHasValueEdges = newHasValueEdges.putAndCopy((Object)currentObject, (Object)hvEdges);
        }
        return newSMG.replaceHasValueEdgesAndCopy(newHasValueEdges);
    }

    public SMG replaceSpecificPointersTowardsWithAndSetNestingLevelZero(SMGObject oldObj, SMGObject newTarget, int replacementLevel) {
        assert (this.verifyPointsToEdgeSanity());
        SMG newSMG = this;
        if (newTarget.isZero() || oldObj.isZero()) {
            throw new AssertionError((Object)"Can't replace a 0 value!");
        }
        ImmutableSet.Builder valuesToDecrementBuilder = ImmutableSet.builder();
        for (Map.Entry pointsToEntry : this.pointsToEdges.entrySet()) {
            SMGValue value;
            if (!((SMGPointsToEdge)pointsToEntry.getValue()).pointsTo().equals(oldObj) || (value = (SMGValue)pointsToEntry.getKey()).getNestingLevel() != replacementLevel) continue;
            newSMG = newSMG.copyAndSetPTEdges(new SMGPointsToEdge(newTarget, ((SMGPointsToEdge)pointsToEntry.getValue()).getOffset(), ((SMGPointsToEdge)pointsToEntry.getValue()).targetSpecifier()), value.withNestingLevelAndCopy(0));
            valuesToDecrementBuilder.add((Object)value);
            assert (this.verifyPointsToEdgeSanity());
        }
        ImmutableSet valuesToDecrement = valuesToDecrementBuilder.build();
        PersistentMap newHasValueEdges = newSMG.hasValueEdges;
        for (Map.Entry objToHvEntry : newSMG.hasValueEdges.entrySet()) {
            SMGObject currentObject = (SMGObject)objToHvEntry.getKey();
            boolean contains = false;
            PersistentSet<SMGHasValueEdge> hvEdges = (PersistentSet<SMGHasValueEdge>)objToHvEntry.getValue();
            for (SMGHasValueEdge hvEdge : (PersistentSet)objToHvEntry.getValue()) {
                if (!valuesToDecrement.contains((Object)hvEdge.hasValue())) continue;
                contains = true;
                hvEdges = hvEdges.removeAndCopy(hvEdge);
                hvEdges = hvEdges.addAndCopy(new SMGHasValueEdge(hvEdge.hasValue().withNestingLevelAndCopy(0), hvEdge.getOffset(), hvEdge.getSizeInBits()));
            }
            if (!contains) continue;
            newHasValueEdges = newHasValueEdges.removeAndCopy((Object)currentObject);
            newHasValueEdges = newHasValueEdges.putAndCopy((Object)currentObject, (Object)hvEdges);
        }
        return newSMG.replaceHasValueEdgesAndCopy(newHasValueEdges);
    }

    public SMG replaceSMGValueNestingLevel(SMGValue value, int replacementLevel) {
        SMG newSMG = this;
        assert (this.verifyPointsToEdgeSanity());
        for (Map.Entry pointsToEntry : this.pointsToEdges.entrySet()) {
            if (!((SMGValue)pointsToEntry.getKey()).equals(value)) continue;
            newSMG = newSMG.copyAndSetPTEdges(new SMGPointsToEdge(((SMGPointsToEdge)pointsToEntry.getValue()).pointsTo(), ((SMGPointsToEdge)pointsToEntry.getValue()).getOffset(), ((SMGPointsToEdge)pointsToEntry.getValue()).targetSpecifier()), value.withNestingLevelAndCopy(replacementLevel));
            assert (this.verifyPointsToEdgeSanity());
        }
        PersistentMap newHasValueEdges = this.hasValueEdges;
        for (Map.Entry objToHvEntry : this.hasValueEdges.entrySet()) {
            SMGObject currentObject = (SMGObject)objToHvEntry.getKey();
            boolean contains = false;
            PersistentSet<SMGHasValueEdge> hvEdges = (PersistentSet<SMGHasValueEdge>)objToHvEntry.getValue();
            for (SMGHasValueEdge hvEdge : (PersistentSet)objToHvEntry.getValue()) {
                if (!value.equals(hvEdge.hasValue())) continue;
                contains = true;
                hvEdges = hvEdges.removeAndCopy(hvEdge);
                hvEdges = hvEdges.addAndCopy(new SMGHasValueEdge(hvEdge.hasValue().withNestingLevelAndCopy(replacementLevel), hvEdge.getOffset(), hvEdge.getSizeInBits()));
            }
            if (!contains) continue;
            newHasValueEdges = newHasValueEdges.removeAndCopy((Object)currentObject);
            newHasValueEdges = newHasValueEdges.putAndCopy((Object)currentObject, (Object)hvEdges);
        }
        return newSMG.replaceHasValueEdgesAndCopy(newHasValueEdges);
    }

    private SMG replaceHasValueEdgesAndCopy(PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> newHasValueEdges) {
        return new SMG(this.smgObjects, this.smgValues, newHasValueEdges, this.pointsToEdges, this.sizeOfPointer);
    }

    public SMGObject getPreviousObjectOfZeroPlusAbstraction(SMGValue ptObject) {
        for (Map.Entry entry : this.smgObjects.entrySet()) {
            PersistentSet hvEdgesPerObj;
            if (!((Boolean)entry.getValue()).booleanValue() || (hvEdgesPerObj = (PersistentSet)this.hasValueEdges.get(entry.getKey())) == null) continue;
            for (SMGHasValueEdge value : hvEdgesPerObj) {
                if (!value.hasValue().equals(ptObject)) continue;
                return (SMGObject)entry.getKey();
            }
        }
        throw new AssertionError((Object)"Critical error: could not find origin of points-to-edge in the SMG.");
    }
}

