/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg;

import java.util.Optional;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.exception.SMGInconsistencyException;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public final class SMGConsistencyChecker {
    public static void checkBasicConsistency(SMG smg) throws SMGInconsistencyException {
        SMGObject nullPointer = smg.getNullObject();
        if (smg.isValid(nullPointer) || nullPointer.getSize().intValue() != 0 || nullPointer.getNestingLevel() != 0 || nullPointer.getOffset().intValue() != 0) {
            throw new SMGInconsistencyException("Inconsistent smg: " + smg + "\n Invalid nullObject");
        }
        SMGConsistencyChecker.checkInvalidRegionConsistency(smg);
        SMGConsistencyChecker.checkValidDLLConsistency(smg);
    }

    private static void checkValidDLLConsistency(SMG smg) {
        Optional<SMGDoublyLinkedListSegment> invalidDLL = smg.getDLLs().stream().filter(l -> !smg.isValid((SMGObject)l)).findAny();
        if (invalidDLL.isPresent()) {
            throw new SMGInconsistencyException("Inconsistent smg: " + smg + "\n Invalid DLL found: " + invalidDLL);
        }
    }

    private static void checkInvalidRegionConsistency(SMG smg) {
        for (SMGObject region : smg.getObjects()) {
            if (smg.isValid(region) || smg.getEdges(region).isEmpty()) continue;
            throw new SMGInconsistencyException("Inconsistent smg: " + smg + "\n Invalid region " + region + " has outgoing edges.");
        }
    }

    public static void checkFieldConsistency(SMG smg) throws SMGInconsistencyException {
        smg.getHVEdges().forEach(e -> SMGConsistencyChecker.checkFieldConsistency(smg, e));
    }

    private static void checkFieldConsistency(SMG smg, SMGHasValueEdge edge) {
        if (edge.getSizeInBits().compareTo(edge.getOffset()) <= 0) {
            throw new SMGInconsistencyException("Inconsistent smg: " + smg + "\n Edge " + edge + " points outside of it's field.");
        }
    }
}

