/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Optional;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.util.ValueAndObjectSet;

public class SMGProveNequality {
    private final SMG smg;

    public SMGProveNequality(SMG pSMG) {
        this.smg = pSMG;
    }

    public boolean proveInequality(SMGValue value1, SMGValue value2) {
        Preconditions.checkArgument((value1.getNestingLevel() == 0 && value2.getNestingLevel() == 0 ? 1 : 0) != 0, (String)"%s or %s is not on level 0", (Object)value1, (Object)value2);
        if (value1.equals(value2)) {
            return false;
        }
        ValueAndObjectSet targetValueAndReachedSet1 = this.lookThrough(value1);
        ValueAndObjectSet targetValueAndReachedSet2 = this.lookThrough(value2);
        if (targetValueAndReachedSet1.getValue().equals(targetValueAndReachedSet2.getValue())) {
            return false;
        }
        if (targetValueAndReachedSet1.getObjectSet().stream().anyMatch(targetValueAndReachedSet2.getObjectSet()::contains)) {
            return false;
        }
        if (!this.smg.isPointer(targetValueAndReachedSet1.getValue()) || !this.smg.isPointer(targetValueAndReachedSet2.getValue())) {
            return false;
        }
        SMGPointsToEdge targetEdge1 = this.smg.getPTEdge(targetValueAndReachedSet1.getValue()).orElseThrow();
        SMGPointsToEdge targetEdge2 = this.smg.getPTEdge(targetValueAndReachedSet2.getValue()).orElseThrow();
        if (targetEdge1.pointsTo().equals(targetEdge2.pointsTo())) {
            return this.checkEdgeLabelsForEqualTargets(targetEdge1, targetEdge2);
        }
        if (this.checkIfEdgePointsOutOfBounds(targetEdge1) || this.checkIfEdgePointsOutOfBounds(targetEdge2)) {
            return false;
        }
        if (targetValueAndReachedSet1.getValue().isZero() || targetValueAndReachedSet2.getValue().isZero()) {
            return true;
        }
        return this.smg.isValid(targetEdge1.pointsTo()) && this.smg.isValid(targetEdge2.pointsTo());
    }

    private boolean checkIfEdgePointsOutOfBounds(SMGPointsToEdge pToEdge) {
        return pToEdge.getOffset().compareTo(pToEdge.pointsTo().getSize()) > 0 || pToEdge.getOffset().signum() < 0;
    }

    private boolean checkEdgeLabelsForEqualTargets(SMGPointsToEdge pTagetEdge1, SMGPointsToEdge pTagetEdge2) {
        if (pTagetEdge1.targetSpecifier().equals((Object)pTagetEdge2.targetSpecifier())) {
            return true;
        }
        if ((pTagetEdge1.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_FIRST_POINTER) || pTagetEdge1.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_LAST_POINTER)) && (pTagetEdge2.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_FIRST_POINTER) || pTagetEdge2.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_LAST_POINTER))) {
            return ((SMGDoublyLinkedListSegment)pTagetEdge1.pointsTo()).getMinLength() >= 2;
        }
        return false;
    }

    public ValueAndObjectSet lookThrough(SMGValue value) {
        HashSet<SMGObject> reachedSet = new HashSet<SMGObject>();
        SMGValue retValue = value;
        Optional<SMGPointsToEdge> ptoOptional = this.smg.getPTEdge(value);
        while (ptoOptional.isPresent() && !ptoOptional.orElseThrow().pointsTo().isZero()) {
            SMGPointsToEdge pointerEdge = ptoOptional.orElseThrow();
            SMGObject nextObject = pointerEdge.pointsTo();
            if (pointerEdge.targetSpecifier() == SMGTargetSpecifier.IS_REGION) break;
            Preconditions.checkArgument((boolean)(nextObject instanceof SMGDoublyLinkedListSegment));
            SMGDoublyLinkedListSegment dlls = (SMGDoublyLinkedListSegment)nextObject;
            if (dlls.getMinLength() != 0) break;
            reachedSet.add(nextObject);
            if (pointerEdge.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_FIRST_POINTER)) {
                retValue = this.findHVETargetValue(dlls, dlls.getNextOffset(), this.smg.getSizeOfPointer());
            } else {
                Preconditions.checkArgument((boolean)pointerEdge.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_LAST_POINTER), (String)"Inconsisntent SMG found: DLLS pointer with SMGTargetSpecifier: %s", (Object)pointerEdge.targetSpecifier().name());
                retValue = this.findHVETargetValue(dlls, dlls.getPrevOffset(), this.smg.getSizeOfPointer());
            }
            ptoOptional = this.smg.getPTEdge(retValue);
        }
        return new ValueAndObjectSet(reachedSet, retValue);
    }

    private SMGValue findHVETargetValue(SMGDoublyLinkedListSegment dlls, BigInteger pOffset, BigInteger pSize) {
        Optional<SMGHasValueEdge> hveOptional = this.smg.getHasValueEdgeByPredicate(dlls, (Predicate<SMGHasValueEdge>)((Predicate)edge -> edge.getOffset().equals(pOffset) && edge.getSizeInBits().equals(pSize)));
        Preconditions.checkArgument((boolean)hveOptional.isPresent(), (String)"No pointer for DLLS %s with offset %s and Size %s found.", (Object)dlls, (Object)pOffset, (Object)pSize);
        return hveOptional.orElseThrow().hasValue();
    }
}

