/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.SMGProveNequality;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.test.SMGTest0;

public class SMGProveNequalityTest
extends SMGTest0 {
    private SMG smg;
    private final SMGValue value1 = this.createValue("value1");
    private final SMGValue value2 = this.createValue("value2");
    private final SMGValue value3 = this.createValue("value3");
    private final SMGValue value4 = this.createValue("value4");

    @Before
    public void setUp() {
        this.smg = new SMG(mockType8bSize);
        this.smg = this.smg.copyAndAddValue(this.value1).copyAndAddValue(this.value2).copyAndAddValue(this.value3).copyAndAddValue(this.value4);
    }

    @Test
    public void equalValuesAreNotInequal() {
        SMGProveNequality nequality = new SMGProveNequality(this.smg);
        Truth.assertThat((Boolean)nequality.proveInequality(this.value1, this.value1)).isFalse();
        Truth.assertThat((Boolean)nequality.proveInequality(this.value2, this.value2)).isFalse();
        Truth.assertThat((Boolean)nequality.proveInequality(this.value3, this.value3)).isFalse();
    }

    @Test
    public void pointerValuesThatShareTargetValuesAreNotInEqual() {
        SMGDoublyLinkedListSegment dlls1 = this.createDLLS(64, 0, 32, 32, "dlls1");
        SMGDoublyLinkedListSegment dlls2 = this.createDLLS(64, 0, 32, 32, "dlls2");
        SMGPointsToEdge pt1 = this.createPTEdge(0, SMGTargetSpecifier.IS_FIRST_POINTER, dlls1);
        SMGPointsToEdge pt2 = this.createPTEdge(0, SMGTargetSpecifier.IS_FIRST_POINTER, dlls2);
        this.smg = this.smg.copyAndAddPTEdge(pt1, this.value1);
        this.smg = this.smg.copyAndAddPTEdge(pt2, this.value2);
        SMGHasValueEdge hasValueEdge1 = this.createHasValueEdge(64, 32, this.value3);
        SMGHasValueEdge hasValueEdge2 = this.createHasValueEdge(64, 32, this.value3);
        this.smg = this.smg.copyAndAddHVEdge(hasValueEdge1, dlls1);
        this.smg = this.smg.copyAndAddHVEdge(hasValueEdge2, dlls2);
        SMGPointsToEdge pt3 = this.createPTEdge(64, SMGTargetSpecifier.IS_FIRST_POINTER, SMGObject.nullInstance());
        this.smg = this.smg.copyAndAddPTEdge(pt3, this.value3);
        SMGProveNequality nequality = new SMGProveNequality(this.smg);
        Truth.assertThat((Boolean)nequality.proveInequality(this.value1, this.value2)).isFalse();
    }

    @Test
    public void pointerValuesThatHaveSharedObjectsAreNotInEqual() {
        SMGDoublyLinkedListSegment dlls1 = this.createDLLS(64, 0, 32, 32, "dlls1");
        SMGDoublyLinkedListSegment dlls2 = this.createDLLS(64, 0, 32, 32, "dlls2");
        SMGPointsToEdge pt1 = this.createPTEdge(0, SMGTargetSpecifier.IS_FIRST_POINTER, dlls1);
        SMGPointsToEdge pt2 = this.createPTEdge(0, SMGTargetSpecifier.IS_FIRST_POINTER, dlls2);
        this.smg = this.smg.copyAndAddPTEdge(pt1, this.value1);
        this.smg = this.smg.copyAndAddPTEdge(pt2, this.value2);
        SMGHasValueEdge hasValueEdge1 = this.createHasValueEdge(64, 32, this.value3);
        SMGHasValueEdge hasValueEdge2 = this.createHasValueEdge(64, 32, this.value4);
        this.smg = this.smg.copyAndAddHVEdge(hasValueEdge1, dlls1);
        this.smg = this.smg.copyAndAddHVEdge(hasValueEdge2, dlls2);
        SMGDoublyLinkedListSegment dlls3 = this.createDLLS(64, 0, 32, 0, "dlls3");
        SMGPointsToEdge pt4 = this.createPTEdge(0, SMGTargetSpecifier.IS_LAST_POINTER, dlls3);
        SMGPointsToEdge pt5 = this.createPTEdge(32, SMGTargetSpecifier.IS_FIRST_POINTER, dlls3);
        this.smg = this.smg.copyAndAddPTEdge(pt4, this.value3);
        this.smg = this.smg.copyAndAddPTEdge(pt5, this.value4);
        SMGValue value5 = this.createValue("value5");
        SMGValue value6 = this.createValue("value6");
        SMGHasValueEdge hasValueEdge3 = this.createHasValueEdge(64, 32, value5);
        SMGHasValueEdge hasValueEdge4 = this.createHasValueEdge(64, 0, value6);
        this.smg = this.smg.copyAndAddValue(value5).copyAndAddValue(value6).copyAndAddHVEdge(hasValueEdge4, dlls3).copyAndAddHVEdge(hasValueEdge3, dlls3);
        SMGPointsToEdge pt6 = this.createPTEdge(0, SMGTargetSpecifier.IS_LAST_POINTER, SMGObject.nullInstance());
        SMGPointsToEdge pt7 = this.createPTEdge(32, SMGTargetSpecifier.IS_FIRST_POINTER, SMGObject.nullInstance());
        this.smg = this.smg.copyAndAddPTEdge(pt6, value5);
        this.smg = this.smg.copyAndAddPTEdge(pt7, value6);
        SMGProveNequality nequality = new SMGProveNequality(this.smg);
        Truth.assertThat((Boolean)nequality.proveInequality(this.value1, this.value2)).isFalse();
    }
}

