/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.test.SMGTest0;
import org.sosy_lab.cpachecker.util.smg.util.SMGandValue;

public class SMGWriteReadTest
extends SMGTest0 {
    private SMG smg;
    private final SMGValue value1 = this.createValue("value1");
    private final SMGValue value2 = this.createValue("value2");
    private final SMGValue value3 = this.createValue("value3");
    private final SMGValue value4 = this.createValue("value4");
    private SMGPointsToEdge nullPointer;

    @Before
    public void setUp() {
        this.smg = new SMG(mockType8bSize);
        this.nullPointer = new SMGPointsToEdge(this.smg.getNullObject(), BigInteger.ZERO, SMGTargetSpecifier.IS_REGION);
    }

    @Test
    public void emptyObjectTest() {
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).isEmpty();
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()));
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).isEmpty();
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
    }

    @Test
    public void writeOverlappingTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(24L), BigInteger.valueOf(64L), this.value1);
        SMGHasValueEdge expectedZeroEdgeBeginning = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, BigInteger.valueOf(24L));
        SMGHasValueEdge expectedValue1Edge = new SMGHasValueEdge(this.value1, BigInteger.valueOf(24L), BigInteger.valueOf(64L));
        SMGHasValueEdge expectedZeroEdgeEnd = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(88L), BigInteger.valueOf(168L));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of(expectedZeroEdgeBeginning).addAndCopy(expectedValue1Edge).addAndCopy(expectedZeroEdgeEnd);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1));
        Truth.assertThat(this.smg.getValues()).hasSize(4);
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
        this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(56L), BigInteger.valueOf(64L), this.value2);
        SMGHasValueEdge expectedValue2Edge = new SMGHasValueEdge(this.value2, BigInteger.valueOf(56L), BigInteger.valueOf(64L));
        expectedZeroEdgeEnd = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(120L), BigInteger.valueOf(136L));
        expectedEdges = PersistentSet.of(expectedZeroEdgeBeginning).addAndCopy(expectedValue2Edge).addAndCopy(expectedZeroEdgeEnd);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).isEqualTo(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test
    public void writeIndependentObjectsTest() {
        SMGObject testObject1 = this.createRegion(BigInteger.valueOf(256L));
        SMGObject testObject2 = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject1);
        this.smg = this.smg.copyAndAddObject(testObject2);
        this.smg = this.smg.writeValue(testObject1, BigInteger.ZERO, testObject1.getSize(), SMGValue.zeroValue());
        Truth.assertThat(this.smg.getEdges(testObject1)).isNotEmpty();
        Truth.assertThat(this.smg.getEdges(testObject2)).isEmpty();
        this.smg = this.smg.writeValue(testObject2, BigInteger.ZERO, testObject2.getSize(), SMGValue.zeroValue());
        Truth.assertThat(this.smg.getEdges(testObject1)).isNotEmpty();
        Truth.assertThat(this.smg.getEdges(testObject2)).isNotEmpty();
        this.smg = this.smg.writeValue(testObject1, BigInteger.valueOf(24L), BigInteger.valueOf(64L), this.value1);
        SMGHasValueEdge expectedZeroEdgeObject2 = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, testObject2.getSize());
        Truth.assertThat(this.smg.getEdges(testObject2)).containsExactlyElementsIn((Iterable)ImmutableList.of((Object)expectedZeroEdgeObject2));
        this.smg = this.smg.writeValue(testObject1, BigInteger.valueOf(56L), BigInteger.valueOf(64L), this.value2);
        Truth.assertThat(this.smg.getEdges(testObject2)).containsExactlyElementsIn((Iterable)ImmutableList.of((Object)expectedZeroEdgeObject2));
        this.smg = this.smg.writeValue(testObject2, BigInteger.valueOf(24L), BigInteger.valueOf(64L), this.value3);
        SMGHasValueEdge expectedZeroEdgeBeginningObject1 = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, BigInteger.valueOf(24L));
        SMGHasValueEdge expectedValue2EdgeObject1 = new SMGHasValueEdge(this.value2, BigInteger.valueOf(56L), BigInteger.valueOf(64L));
        SMGHasValueEdge expectedZeroEdgeEndObject1 = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(120L), BigInteger.valueOf(136L));
        SMGHasValueEdge expectedValue3EdgeObject2 = new SMGHasValueEdge(this.value3, BigInteger.valueOf(24L), BigInteger.valueOf(64L));
        SMGHasValueEdge expectedZeroEdgeBeginningObject2 = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, BigInteger.valueOf(24L));
        SMGHasValueEdge expectedZeroEdgeEndObject2 = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(88L), BigInteger.valueOf(168L));
        PersistentSet<SMGHasValueEdge> expectedEdgesObject1 = PersistentSet.of(expectedZeroEdgeBeginningObject1).addAndCopy(expectedValue2EdgeObject1).addAndCopy(expectedZeroEdgeEndObject1);
        PersistentSet<SMGHasValueEdge> expectedEdgesObject2 = PersistentSet.of(expectedValue3EdgeObject2).addAndCopy(expectedZeroEdgeBeginningObject2).addAndCopy(expectedZeroEdgeEndObject2);
        ImmutableList expectedEdges = ImmutableList.of((Object)expectedZeroEdgeEndObject2, (Object)expectedZeroEdgeBeginningObject2, (Object)expectedValue3EdgeObject2, (Object)expectedZeroEdgeEndObject1, (Object)expectedValue2EdgeObject1, (Object)expectedZeroEdgeBeginningObject1);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2).addAndCopy(this.value3));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject1).addAndCopy(testObject2));
        Truth.assertThat(this.smg.getEdges(testObject1)).containsExactlyElementsIn(expectedEdgesObject1);
        Truth.assertThat(this.smg.getEdges(testObject2)).containsExactlyElementsIn(expectedEdgesObject2);
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn((Iterable)expectedEdges);
        this.smg = this.smg.writeValue(testObject2, BigInteger.valueOf(56L), BigInteger.valueOf(64L), this.value4);
        SMGHasValueEdge expectedValue4EdgeObject2 = new SMGHasValueEdge(this.value4, BigInteger.valueOf(56L), BigInteger.valueOf(64L));
        expectedZeroEdgeEndObject2 = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(120L), BigInteger.valueOf(136L));
        expectedEdgesObject2 = PersistentSet.of(expectedValue4EdgeObject2).addAndCopy(expectedZeroEdgeBeginningObject2).addAndCopy(expectedZeroEdgeEndObject2);
        expectedEdges = ImmutableList.of((Object)expectedZeroEdgeEndObject2, (Object)expectedZeroEdgeBeginningObject2, (Object)expectedValue4EdgeObject2, (Object)expectedZeroEdgeEndObject1, (Object)expectedValue2EdgeObject1, (Object)expectedZeroEdgeBeginningObject1);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2).addAndCopy(this.value3).addAndCopy(this.value4));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject1).addAndCopy(testObject2));
        Truth.assertThat(this.smg.getEdges(testObject1)).containsExactlyElementsIn(expectedEdgesObject1);
        Truth.assertThat(this.smg.getEdges(testObject2)).containsExactlyElementsIn(expectedEdgesObject2);
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn((Iterable)expectedEdges);
    }

    @Test
    public void writeZeroValueForEntireObjectTest() {
        BigInteger sizeInBitsOfObject = BigInteger.valueOf(256L);
        SMGObject testObject = this.createRegion(sizeInBitsOfObject);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).isEmpty();
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()));
        this.smg = this.smg.copyAndAddObject(testObject);
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        SMGHasValueEdge expectedEdge = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, sizeInBitsOfObject);
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of().addAndCopy(expectedEdge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)expectedEdge));
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).isEqualTo(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test
    public void writeSingleValueTest() {
        BigInteger sizeInBitsOfObject = BigInteger.valueOf(256L);
        SMGObject testObject = this.createRegion(sizeInBitsOfObject);
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, sizeInBitsOfObject.divide(BigInteger.valueOf(2L)), this.value1);
        SMGHasValueEdge expectedZeroEdge = new SMGHasValueEdge(SMGValue.zeroValue(), sizeInBitsOfObject.divide(BigInteger.valueOf(2L)), sizeInBitsOfObject.divide(BigInteger.valueOf(2L)));
        SMGHasValueEdge expectedValueEdge = new SMGHasValueEdge(this.value1, BigInteger.ZERO, sizeInBitsOfObject.divide(BigInteger.valueOf(2L)));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of().addAndCopy(expectedValueEdge).addAndCopy(expectedZeroEdge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).hasSize(2);
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).contains((Object)expectedValueEdge);
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).contains((Object)expectedZeroEdge);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).isEqualTo(expectedEdges);
    }

    @Test
    public void writeSingleValueTest2() {
        BigInteger sizeInBitsOfObject = BigInteger.valueOf(256L);
        SMGObject testObject = this.createRegion(sizeInBitsOfObject);
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, sizeInBitsOfObject.divide(BigInteger.valueOf(2L)), sizeInBitsOfObject.divide(BigInteger.valueOf(2L)), this.value1);
        SMGHasValueEdge expectedZeroEdge = new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, sizeInBitsOfObject.divide(BigInteger.valueOf(2L)));
        SMGHasValueEdge expectedValueEdge = new SMGHasValueEdge(this.value1, sizeInBitsOfObject.divide(BigInteger.valueOf(2L)), sizeInBitsOfObject.divide(BigInteger.valueOf(2L)));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of().addAndCopy(expectedValueEdge).addAndCopy(expectedZeroEdge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).hasSize(2);
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).contains((Object)expectedValueEdge);
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).contains((Object)expectedZeroEdge);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).isEqualTo(expectedEdges);
    }

    @Test
    public void writeMulitpleValuesNonOverlappingTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO), this.value2);
        SMGHasValueEdge expectedValue1Edge = new SMGHasValueEdge(this.value1, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO));
        SMGHasValueEdge expectedValue2Edge = new SMGHasValueEdge(this.value2, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of(expectedValue1Edge).addAndCopy(expectedValue2Edge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test
    public void writeMulitpleValuesOverlappingTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO), this.value2);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO).subtract(BigInteger.valueOf(8L)), BigInteger.valueOf(16L), this.value3);
        SMGHasValueEdge expectedValue3Edge = new SMGHasValueEdge(this.value3, testObject.getSize().divide(BigInteger.TWO).subtract(BigInteger.valueOf(8L)), BigInteger.valueOf(16L));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of(expectedValue3Edge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2).addAndCopy(this.value3));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test
    public void writeMulitpleValuesOverlappingTest2() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO), this.value2);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, BigInteger.valueOf(8L), this.value3);
        SMGHasValueEdge expectedValue2Edge = new SMGHasValueEdge(this.value2, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO));
        SMGHasValueEdge expectedValue3Edge = new SMGHasValueEdge(this.value3, BigInteger.ZERO, BigInteger.valueOf(8L));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of(expectedValue2Edge).addAndCopy(expectedValue3Edge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2).addAndCopy(this.value3));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test
    public void writeMulitpleValuesOverlappingTest3() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO), this.value2);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO).subtract(BigInteger.valueOf(8L)), BigInteger.valueOf(8L), this.value3);
        SMGHasValueEdge expectedValue2Edge = new SMGHasValueEdge(this.value2, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO));
        SMGHasValueEdge expectedValue3Edge = new SMGHasValueEdge(this.value3, testObject.getSize().divide(BigInteger.TWO).subtract(BigInteger.valueOf(8L)), BigInteger.valueOf(8L));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of(expectedValue2Edge).addAndCopy(expectedValue3Edge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2).addAndCopy(this.value3));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test
    public void writeMulitpleValuesOverlappingTest4() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO), this.value2);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().subtract(BigInteger.valueOf(8L)), BigInteger.valueOf(8L), this.value3);
        SMGHasValueEdge expectedValue1Edge = new SMGHasValueEdge(this.value1, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO));
        SMGHasValueEdge expectedValue3Edge = new SMGHasValueEdge(this.value3, testObject.getSize().subtract(BigInteger.valueOf(8L)), BigInteger.valueOf(8L));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of(expectedValue1Edge).addAndCopy(expectedValue3Edge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2).addAndCopy(this.value3));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test
    public void writeMulitpleValuesOverlappingTest5() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO), testObject.getSize().divide(BigInteger.TWO), this.value2);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().divide(BigInteger.TWO), BigInteger.valueOf(8L), this.value3);
        SMGHasValueEdge expectedValue1Edge = new SMGHasValueEdge(this.value1, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO));
        SMGHasValueEdge expectedValue3Edge = new SMGHasValueEdge(this.value3, testObject.getSize().divide(BigInteger.TWO), BigInteger.valueOf(8L));
        PersistentSet<SMGHasValueEdge> expectedEdges = PersistentSet.of(expectedValue1Edge).addAndCopy(expectedValue3Edge);
        Truth.assertThat((Iterable)this.smg.getPTEdges().toList()).isEqualTo((Object)ImmutableList.of((Object)this.nullPointer, (Object)this.nullPointer, (Object)this.nullPointer));
        Truth.assertThat((Iterable)this.smg.getHVEdges().toList()).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getValues()).isEqualTo(PersistentSet.of(SMGValue.zeroValue()).addAndCopy(SMGValue.zeroDoubleValue()).addAndCopy(SMGValue.zeroFloatValue()).addAndCopy(this.value1).addAndCopy(this.value2).addAndCopy(this.value3));
        Truth.assertThat(this.smg.getObjects()).isEqualTo(PersistentSet.of(SMGObject.nullInstance()).addAndCopy(testObject));
        Truth.assertThat(this.smg.getEdges(testObject)).containsExactlyElementsIn(expectedEdges);
        Truth.assertThat(this.smg.getEdges(testObject)).hasSize(expectedEdges.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeBeyondRangeTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().add(BigInteger.ONE), SMGValue.zeroValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeBeyondRangeTest2() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, testObject.getSize(), BigInteger.ONE, SMGValue.zeroValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void writeBeyondRangeTest3() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, testObject.getSize().subtract(BigInteger.ONE), BigInteger.TWO, SMGValue.zeroValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void readBeyondRangeTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg.readValue(testObject, BigInteger.ZERO, testObject.getSize().add(BigInteger.ONE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void readBeyondRangeTest2() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg.readValue(testObject, testObject.getSize(), BigInteger.ONE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readBeyondRangeTest3() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg.readValue(testObject, testObject.getSize().subtract(BigInteger.ONE), BigInteger.TWO);
    }

    @Test
    public void readValueZeroValueCombinationTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.checkReadExpectedValue(testObject, BigInteger.ZERO, testObject.getSize().divide(BigInteger.TWO), this.value1);
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(8L)).getSMG();
        this.checkReadUnknownValue(testObject, testObject.getSize().divide(BigInteger.TWO).subtract(BigInteger.valueOf(8L)), BigInteger.valueOf(16L));
    }

    @Test
    public void readValueValueCombinationTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        BigInteger objectSizeQuartered = testObject.getSize().divide(BigInteger.valueOf(4L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, objectSizeQuartered, this.value1);
        this.smg = this.smg.writeValue(testObject, objectSizeQuartered, objectSizeQuartered, this.value2);
        this.smg = this.smg.writeValue(testObject, objectSizeQuartered.multiply(BigInteger.TWO), objectSizeQuartered, this.value3);
        this.smg = this.smg.writeValue(testObject, objectSizeQuartered.multiply(BigInteger.valueOf(3L)), objectSizeQuartered, this.value4);
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, testObject.getSize()).getSMG();
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.ZERO, objectSizeQuartered, this.value1);
        this.smg = this.checkReadExpectedValue(testObject, objectSizeQuartered.multiply(BigInteger.ONE), objectSizeQuartered, this.value2);
        this.smg = this.checkReadExpectedValue(testObject, objectSizeQuartered.multiply(BigInteger.TWO), objectSizeQuartered, this.value3);
        this.smg = this.checkReadExpectedValue(testObject, objectSizeQuartered.multiply(BigInteger.valueOf(3L)), objectSizeQuartered, this.value4);
    }

    @Test
    public void repeatedReadValueTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(8L), BigInteger.valueOf(8L), this.value1);
        this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(32L), BigInteger.valueOf(8L), this.value2);
        this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(128L), BigInteger.valueOf(8L), this.value3);
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.valueOf(8L), BigInteger.valueOf(8L), this.value1);
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.valueOf(32L), BigInteger.valueOf(8L), this.value2);
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.valueOf(128L), BigInteger.valueOf(8L), this.value3);
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(8L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.valueOf(16L), BigInteger.valueOf(16L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.valueOf(40L), BigInteger.valueOf(88L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.valueOf(136L), BigInteger.valueOf(112L));
        SMGandValue readReinterpreation0to16 = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(16L));
        this.smg = readReinterpreation0to16.getSMG();
        SMGValue newValueInSMG0to16 = readReinterpreation0to16.getValue();
        SMGandValue readReinterpreation0to32 = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(32L));
        SMGValue newValueInSMG0to32 = readReinterpreation0to32.getValue();
        this.smg = readReinterpreation0to32.getSMG();
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.ZERO, BigInteger.valueOf(16L), newValueInSMG0to16);
        SMGandValue readReinterpreation0to17 = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(17L));
        this.smg = readReinterpreation0to17.getSMG();
        SMGValue newValueInSMG0to17 = readReinterpreation0to17.getValue();
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.ZERO, BigInteger.valueOf(16L), newValueInSMG0to16);
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.ZERO, BigInteger.valueOf(32L), newValueInSMG0to32);
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.ZERO, BigInteger.valueOf(17L), newValueInSMG0to17);
    }

    @Test
    public void readSingleZeroValueTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        this.smg = this.smg.writeValue(testObject, BigInteger.ZERO, testObject.getSize(), SMGValue.zeroValue());
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(8L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.valueOf(248L), BigInteger.valueOf(8L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(256L));
    }

    @Test
    public void readMulitpleZeroValuesTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        for (long i = 0L; i < 32L; ++i) {
            this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(i * 8L), BigInteger.valueOf(8L), SMGValue.zeroValue());
        }
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(8L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(16L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(80L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.valueOf(168L), BigInteger.valueOf(80L));
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(256L));
    }

    @Test
    public void readUndefinedTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        for (long i = 0L; i < 32L; ++i) {
            if (i % 4L == 3L) continue;
            this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(i * 8L), BigInteger.valueOf(8L), SMGValue.zeroValue());
        }
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(24L));
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(32L)).getSMG();
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(25L)).getSMG();
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.valueOf(24L), BigInteger.valueOf(8L)).getSMG();
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(56L)).getSMG();
        this.smg = this.checkReadZeroValue(testObject, BigInteger.valueOf(224L), BigInteger.valueOf(24L));
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.valueOf(224L), BigInteger.valueOf(32L)).getSMG();
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(256L)).getSMG();
    }

    @Test
    public void readValuesWithBitPrecisionTest() {
        SMGObject testObject = this.createRegion(BigInteger.valueOf(256L));
        this.smg = this.smg.copyAndAddObject(testObject);
        for (int i = 0; i < 256; ++i) {
            this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(i), BigInteger.ONE, SMGValue.zeroValue());
        }
        this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(31L), BigInteger.ONE, this.value1);
        this.smg = this.smg.writeValue(testObject, BigInteger.valueOf(254L), BigInteger.ONE, this.value2);
        this.smg = this.checkReadZeroValue(testObject, BigInteger.ZERO, BigInteger.valueOf(31L));
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(32L)).getSMG();
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(64L)).getSMG();
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.valueOf(31L), BigInteger.ONE, this.value1);
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.valueOf(31L), BigInteger.valueOf(32L)).getSMG();
        this.smg = this.checkReadZeroValue(testObject, BigInteger.valueOf(32L), BigInteger.valueOf(222L));
        this.smg = this.checkReadExpectedValue(testObject, BigInteger.valueOf(254L), BigInteger.ONE, this.value2);
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.valueOf(254L), BigInteger.TWO).getSMG();
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.valueOf(253L), BigInteger.valueOf(3L)).getSMG();
        this.smg = this.checkReadUnknownValue(testObject, BigInteger.ZERO, BigInteger.valueOf(256L)).getSMG();
    }

    private SMG checkReadExpectedValue(SMGObject testObject, BigInteger offset, BigInteger size, SMGValue expectedValue) {
        if (!expectedValue.isZero()) {
            Truth.assertThat(this.smg.getEdges(testObject)).contains((Object)new SMGHasValueEdge(expectedValue, offset, size));
        }
        Set<SMGValue> allValuesBeforeRead = this.smg.getValues();
        SMGandValue readReinterpretation = this.smg.readValue(testObject, offset, size);
        SMG newSMG = readReinterpretation.getSMG();
        Truth.assertThat((Comparable)readReinterpretation.getValue()).isEqualTo((Object)expectedValue);
        Truth.assertThat(newSMG.getValues()).isEqualTo(allValuesBeforeRead);
        return newSMG;
    }

    private SMG checkReadZeroValue(SMGObject testObject, BigInteger offset, BigInteger size) {
        return this.checkReadExpectedValue(testObject, offset, size, SMGValue.zeroValue());
    }

    private SMGandValue checkReadUnknownValue(SMGObject testObject, BigInteger offset, BigInteger size) {
        Set<SMGValue> allValuesBeforeRead = this.smg.getValues();
        SMGandValue readReinterpretation = this.smg.readValue(testObject, offset, size);
        PersistentSet oldEdgesForObject = (PersistentSet)this.smg.getEdges(testObject);
        SMG newSMG = readReinterpretation.getSMG();
        Truth.assertThat(newSMG.getValues()).hasSize(allValuesBeforeRead.size() + 1);
        SMGValue newValue = (SMGValue)Sets.difference(newSMG.getValues(), allValuesBeforeRead).stream().findFirst().orElseThrow();
        Truth.assertThat((Comparable)readReinterpretation.getValue()).isEqualTo((Object)newValue);
        Truth.assertThat(newSMG.getEdges(testObject)).isEqualTo(oldEdgesForObject.addAndCopy(new SMGHasValueEdge(newValue, offset, size)));
        return readReinterpretation;
    }
}

