/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.graph;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGSinglyLinkedListSegment;

public class SMGDoublyLinkedListSegment
extends SMGSinglyLinkedListSegment {
    private final BigInteger prevOffset;

    public SMGDoublyLinkedListSegment(int pNestingLevel, BigInteger pSize, BigInteger pOffset, BigInteger pHeadOffset, BigInteger pNextOffset, BigInteger pPrevOffset, int pMinLength) {
        super(pNestingLevel, pSize, pOffset, pHeadOffset, pNextOffset, pMinLength);
        this.prevOffset = pPrevOffset;
    }

    public BigInteger getPrevOffset() {
        return this.prevOffset;
    }

    @Override
    public boolean equals(Object pOther) {
        return super.equals(pOther);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public SMGObject copyWithNewLevel(int newLevel) {
        Preconditions.checkArgument((newLevel >= 0 ? 1 : 0) != 0);
        return new SMGDoublyLinkedListSegment(newLevel, this.getSize(), this.getOffset(), this.getHeadOffset(), this.getNextOffset(), this.prevOffset, this.getMinLength());
    }

    @Override
    public SMGObject freshCopy() {
        return new SMGDoublyLinkedListSegment(this.getNestingLevel(), this.getSize(), this.getOffset(), this.getHeadOffset(), this.getNextOffset(), this.prevOffset, this.getMinLength());
    }

    @Override
    public SMGObject decrementLengthAndCopy() {
        return new SMGDoublyLinkedListSegment(this.getNestingLevel(), this.getSize(), this.getOffset(), this.getHeadOffset(), this.getNextOffset(), this.prevOffset, Integer.max(this.getMinLength() - 1, 0));
    }

    @Override
    public String toString() {
        return this.getMinLength() + "+DLL " + super.hashCode();
    }

    @Override
    public boolean isSLL() {
        return false;
    }
}

