/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.graph;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.util.smg.graph.SMGEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class SMGHasValueEdge
implements SMGEdge,
Comparable<SMGHasValueEdge> {
    private final SMGValue value;
    private final BigInteger sizeInBits;
    private final BigInteger offset;

    public SMGHasValueEdge(SMGValue pValue, BigInteger pOffset, BigInteger pSizeInBits) {
        this.value = pValue;
        this.sizeInBits = pSizeInBits;
        this.offset = pOffset;
    }

    public SMGValue hasValue() {
        return this.value;
    }

    public BigInteger getSizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public BigInteger getOffset() {
        return this.offset;
    }

    @Override
    public int compareTo(SMGHasValueEdge pOther) {
        int valueCompare = this.value.compareTo(pOther.value);
        if (valueCompare == 0) {
            if (this.offset.compareTo(pOther.offset) == 0) {
                if (this.sizeInBits.compareTo(pOther.sizeInBits) == 0) {
                    return 0;
                }
                return this.sizeInBits.compareTo(pOther.sizeInBits);
            }
            return this.offset.compareTo(pOther.offset);
        }
        return valueCompare;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SMGHasValueEdge)) {
            return false;
        }
        SMGHasValueEdge otherEdge = (SMGHasValueEdge)other;
        return otherEdge.offset.equals(this.offset) && otherEdge.value.equals(this.value) && this.sizeInBits.equals(otherEdge.sizeInBits);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.value + " [" + this.offset + "; " + this.sizeInBits + ")";
    }
}

