/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.graph;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.smg.graph.SMGNode;

public class SMGObject
implements SMGNode,
Comparable<SMGObject> {
    private static final UniqueIdGenerator U_ID_GENERATOR = new UniqueIdGenerator();
    private static final SMGObject NULL_OBJECT = new SMGObject(0, BigInteger.ZERO, BigInteger.ZERO);
    private int nestingLevel;
    private final BigInteger size;
    private final BigInteger offset;
    private final int id;

    protected SMGObject(int pNestingLevel, BigInteger pSize, BigInteger pOffset) {
        this.nestingLevel = pNestingLevel;
        this.size = pSize;
        this.offset = pOffset;
        this.id = U_ID_GENERATOR.getFreshId();
    }

    protected SMGObject(int pNestingLevel, BigInteger pSize, BigInteger pOffset, int pId) {
        this.nestingLevel = pNestingLevel;
        this.size = pSize;
        this.offset = pOffset;
        this.id = pId;
    }

    public static SMGObject nullInstance() {
        return NULL_OBJECT;
    }

    public static SMGObject of(int pNestingLevel, BigInteger pSize, BigInteger pOffset) {
        return new SMGObject(pNestingLevel, pSize, pOffset);
    }

    public BigInteger getSize() {
        return this.size;
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public int compareTo(SMGObject pOther) {
        return Integer.compare(this.id, pOther.id);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SMGObject)) {
            return false;
        }
        SMGObject otherObj = (SMGObject)other;
        return this.id == otherObj.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "SMGObject" + this.id;
    }

    public boolean isZero() {
        return this.equals(NULL_OBJECT);
    }

    public SMGObject copyWithNewLevel(int pNewLevel) {
        Preconditions.checkArgument((pNewLevel >= 0 ? 1 : 0) != 0);
        return SMGObject.of(pNewLevel, this.size, this.offset);
    }

    public SMGObject freshCopy() {
        return SMGObject.of(this.nestingLevel, this.size, this.offset);
    }

    public boolean isSLL() {
        return false;
    }

    @Override
    public SMGObject withNestingLevelAndCopy(int pNewLevel) {
        return new SMGObject(pNewLevel, this.size, this.offset);
    }
}

