/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.graph;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.util.smg.graph.SMGEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;

public class SMGPointsToEdge
implements SMGEdge,
Comparable<SMGPointsToEdge> {
    private final SMGObject pointsToObject;
    private final BigInteger offset;
    private SMGTargetSpecifier targetSpecifier;

    public SMGPointsToEdge(SMGObject pPointsToObject, BigInteger pOffset, SMGTargetSpecifier pTargetSpecifier) {
        this.pointsToObject = pPointsToObject;
        this.offset = pOffset;
        this.targetSpecifier = pTargetSpecifier;
    }

    public SMGObject pointsTo() {
        return this.pointsToObject;
    }

    @Override
    public BigInteger getOffset() {
        return this.offset;
    }

    public SMGTargetSpecifier targetSpecifier() {
        return this.targetSpecifier;
    }

    @Override
    public int compareTo(SMGPointsToEdge pOther) {
        if (this.pointsToObject.compareTo(pOther.pointsToObject) == 0) {
            if (this.offset.compareTo(pOther.offset) == 0) {
                if (this.targetSpecifier == pOther.targetSpecifier) {
                    return 0;
                }
                return 1;
            }
            return this.offset.compareTo(pOther.offset);
        }
        return this.pointsToObject.compareTo(pOther.pointsToObject);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SMGPointsToEdge)) {
            return false;
        }
        SMGPointsToEdge otherEdge = (SMGPointsToEdge)other;
        return otherEdge.offset.equals(this.offset) && otherEdge.pointsToObject.equals(this.pointsToObject) && this.targetSpecifier.equals((Object)otherEdge.targetSpecifier);
    }

    public int hashCode() {
        return super.hashCode() + 31 * this.pointsToObject.hashCode() + 41 * this.offset.intValue();
    }

    public void setTargetSpecifier(SMGTargetSpecifier pTargetSpecifier) {
        this.targetSpecifier = pTargetSpecifier;
    }

    public String toString() {
        return " -> [" + this.offset + "] " + this.pointsToObject;
    }
}

