/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.graph;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public class SMGSinglyLinkedListSegment
extends SMGObject {
    private final int minLength;
    private final BigInteger headOffset;
    private final BigInteger nextOffset;

    public SMGSinglyLinkedListSegment(int pNestingLevel, BigInteger pSize, BigInteger pOffset, BigInteger pHeadOffset, BigInteger pNextOffset, int pMinLength) {
        super(pNestingLevel, pSize, pOffset);
        this.minLength = pMinLength;
        this.headOffset = pHeadOffset;
        this.nextOffset = pNextOffset;
    }

    public BigInteger getNextOffset() {
        return this.nextOffset;
    }

    public BigInteger getHeadOffset() {
        return this.headOffset;
    }

    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public boolean equals(Object pOther) {
        return super.equals(pOther);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public SMGObject copyWithNewLevel(int newLevel) {
        Preconditions.checkArgument((newLevel >= 0 ? 1 : 0) != 0);
        return new SMGSinglyLinkedListSegment(newLevel, this.getSize(), this.getOffset(), this.headOffset, this.nextOffset, this.minLength);
    }

    public SMGObject decrementLengthAndCopy() {
        return new SMGSinglyLinkedListSegment(this.getNestingLevel(), this.getSize(), this.getOffset(), this.headOffset, this.nextOffset, Integer.max(this.getMinLength() - 1, 0));
    }

    @Override
    public SMGObject freshCopy() {
        return new SMGSinglyLinkedListSegment(this.getNestingLevel(), this.getSize(), this.getOffset(), this.headOffset, this.nextOffset, this.minLength);
    }

    @Override
    public String toString() {
        return this.minLength + "+SLL " + super.hashCode();
    }

    @Override
    public boolean isSLL() {
        return true;
    }
}

