/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.graph;

import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.smg.graph.SMGNode;

public class SMGValue
implements SMGNode,
Comparable<SMGValue> {
    private static final UniqueIdGenerator U_ID_GENERATOR = new UniqueIdGenerator();
    private static final SMGValue ZERO_VALUE = new SMGValue(0);
    private static final SMGValue ZERO_FLOAT_VALUE = new SMGValue(0);
    private static final SMGValue ZERO_DOUBLE_VALUE = new SMGValue(0);
    private final int id;
    private int nestingLevel;

    protected SMGValue(int pNestingLevel) {
        this.nestingLevel = pNestingLevel;
        this.id = U_ID_GENERATOR.getFreshId();
    }

    private SMGValue(int pId, int pNestingLevel) {
        this.nestingLevel = pNestingLevel;
        this.id = pId;
    }

    public static SMGValue of(int pNestingLevel) {
        return new SMGValue(pNestingLevel);
    }

    public static SMGValue of() {
        return SMGValue.of(0);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public static SMGValue zeroValue() {
        return ZERO_VALUE;
    }

    public static SMGValue zeroFloatValue() {
        return ZERO_FLOAT_VALUE;
    }

    public static SMGValue zeroDoubleValue() {
        return ZERO_DOUBLE_VALUE;
    }

    public boolean isZero() {
        return this.equals(ZERO_VALUE) || this.equals(ZERO_FLOAT_VALUE) || this.equals(ZERO_DOUBLE_VALUE);
    }

    @Override
    public int compareTo(SMGValue pOther) {
        return Integer.compare(this.id, pOther.id);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SMGValue)) {
            return false;
        }
        SMGValue otherObj = (SMGValue)other;
        return this.id == otherObj.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public SMGValue withNestingLevelAndCopy(int newLevel) {
        return new SMGValue(this.id, newLevel);
    }

    public String toString() {
        if (this.isZero()) {
            return "ZERO";
        }
        return "Value" + this.id;
    }
}

