/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class NodeMapping {
    private final Map<SMGObject, SMGObject> objectMap = new HashMap<SMGObject, SMGObject>();
    private final Map<SMGValue, SMGValue> valueMap = new HashMap<SMGValue, SMGValue>();

    public SMGValue getMappedValue(SMGValue value) {
        return this.valueMap.get(value);
    }

    public SMGObject getMappedObject(SMGObject object) {
        return this.objectMap.get(object);
    }

    public void addMapping(SMGValue v1, SMGValue v2) {
        this.valueMap.put(v1, v2);
    }

    public void addMapping(SMGObject o1, SMGObject o2) {
        this.objectMap.put(o1, o2);
    }

    public void replaceValueMapping(SMGValue oldTarget, SMGValue newTarget) {
        for (Map.Entry<SMGValue, SMGValue> entry : new ArrayList<Map.Entry<SMGValue, SMGValue>>(this.valueMap.entrySet())) {
            if (!entry.getValue().equals(oldTarget)) continue;
            this.valueMap.put(entry.getKey(), newTarget);
        }
    }

    public void replaceObjectMapping(SMGObject oldTarget, SMGObject newTarget) {
        for (Map.Entry<SMGObject, SMGObject> entry : new ArrayList<Map.Entry<SMGObject, SMGObject>>(this.objectMap.entrySet())) {
            if (!entry.getValue().equals(oldTarget)) continue;
            this.objectMap.put(entry.getKey(), newTarget);
        }
    }

    public boolean mappingExists(SMGObject pMappedObject) {
        return this.objectMap.containsValue(pMappedObject);
    }

    public boolean hasMapping(SMGValue pValue) {
        return this.valueMap.containsKey(pValue);
    }

    public boolean hasMapping(SMGObject pObject) {
        return this.objectMap.containsKey(pObject);
    }

    public Collection<SMGObject> getMappedObjects() {
        return ImmutableSet.copyOf(this.objectMap.values());
    }

    public Collection<SMGValue> getMappedValues() {
        return ImmutableSet.copyOf(this.valueMap.values());
    }

    public Map<SMGObject, SMGObject> getObjectMap() {
        return this.objectMap;
    }

    public Map<SMGValue, SMGValue> getValueMap() {
        return this.valueMap;
    }

    public int hashCode() {
        return Objects.hash(this.objectMap, this.valueMap);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeMapping)) {
            return false;
        }
        NodeMapping other = (NodeMapping)obj;
        return Objects.equals(this.objectMap, other.objectMap) && Objects.equals(this.valueMap, other.valueMap);
    }
}

