/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;

public class SMGAbstractJoin {
    protected SMGJoinStatus status;
    protected SMG inputSMG1;
    protected SMG inputSMG2;
    protected SMG destSMG;
    protected SMGValue value;
    protected NodeMapping mapping1;
    protected NodeMapping mapping2;
    protected boolean isRecoverableFailure = true;
    protected boolean isDefined = true;

    public SMGAbstractJoin(SMGJoinStatus pStatus, SMG pInputSMG1, SMG pInputSMG2, SMG pDestSMG, NodeMapping pMapping1, NodeMapping pMapping2) {
        this.status = pStatus;
        this.inputSMG1 = pInputSMG1;
        this.inputSMG2 = pInputSMG2;
        this.destSMG = pDestSMG;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
    }

    protected void copyJoinState(SMGAbstractJoin other) {
        this.status = other.getStatus();
        this.inputSMG1 = other.getInputSMG1();
        this.inputSMG2 = other.getInputSMG2();
        this.destSMG = other.getDestinationSMG();
        this.value = other.getValue();
        this.mapping1 = other.getMapping1();
        this.mapping2 = other.getMapping2();
        this.isRecoverableFailure = other.isRecoverableFailure;
        this.isDefined = other.isDefined;
    }

    protected boolean resultDLSHaveNewCycles() {
        return false;
    }

    protected boolean isDLLS(SMGObject smgObject) {
        return smgObject instanceof SMGDoublyLinkedListSegment;
    }

    protected boolean isRegion(SMGObject smgObject) {
        return !this.isDLLS(smgObject);
    }

    public NodeMapping getMapping1() {
        return this.mapping1;
    }

    public NodeMapping getMapping2() {
        return this.mapping2;
    }

    protected void setBottomState() {
        this.status = SMGJoinStatus.INCOMPARABLE;
        this.isDefined = false;
        this.isRecoverableFailure = false;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public boolean isRecoverableFailur() {
        return this.isRecoverableFailure;
    }

    public SMG getInputSMG1() {
        return this.inputSMG1;
    }

    public SMG getDestinationSMG() {
        return this.destSMG;
    }

    public SMG getInputSMG2() {
        return this.inputSMG2;
    }

    public SMGValue getValue() {
        return this.value;
    }
}

