/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.math.BigInteger;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinValues;

public class SMGInsertLeftDlsAndJoin
extends SMGAbstractJoin {
    public SMGInsertLeftDlsAndJoin(SMGJoinStatus pStatus, SMG pInputSMG1, SMG pInputSMG2, SMG pDestSMG, NodeMapping pMapping1, NodeMapping pMapping2, SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        super(pStatus, pInputSMG1, pInputSMG2, pDestSMG, pMapping1, pMapping2);
        this.checkPointsToDLLs(pValue1);
        this.insertLeftDlsAndJoin(pValue1, pValue2, pNestingLevelDiff);
    }

    private void insertLeftDlsAndJoin(SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        BigInteger nextFieldOffset;
        Optional<SMGPointsToEdge> edgeOptionalV1 = this.inputSMG1.getPTEdge(pValue1);
        Preconditions.checkArgument((boolean)edgeOptionalV1.isPresent());
        SMGPointsToEdge pToEdge1 = edgeOptionalV1.orElseThrow();
        SMGDoublyLinkedListSegment dlls1 = (SMGDoublyLinkedListSegment)pToEdge1.pointsTo();
        if (pToEdge1.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_FIRST_POINTER)) {
            nextFieldOffset = dlls1.getNextOffset();
        } else if (pToEdge1.targetSpecifier().equals((Object)SMGTargetSpecifier.IS_LAST_POINTER)) {
            nextFieldOffset = dlls1.getPrevOffset();
        } else {
            this.isRecoverableFailure = true;
            return;
        }
        Optional<SMGHasValueEdge> edgeToNextSmgValue = this.inputSMG1.getHasValueEdgeByPredicate(dlls1, (Predicate<SMGHasValueEdge>)((Predicate)edge -> nextFieldOffset.equals(edge.getOffset()) && dlls1.getSize().equals(edge.getSizeInBits())));
        SMGValue nextValue = edgeToNextSmgValue.orElseThrow().hasValue();
        SMGObject mappedObject = this.mapping1.getMappedObject(dlls1);
        if (mappedObject != null) {
            this.updateExistingJoin(mappedObject, pValue1, pValue2, nextValue, nextFieldOffset, pNestingLevelDiff, pToEdge1.targetSpecifier());
            return;
        }
        if (this.checkIfNotMatchingMappingsExists(nextValue, pValue2)) {
            this.isRecoverableFailure = true;
            return;
        }
        this.status = this.status.updateWith(dlls1.getMinLength() == 0 ? SMGJoinStatus.LEFT_ENTAIL : SMGJoinStatus.EQUAL);
        SMGDoublyLinkedListSegment freshCopyDLLS1 = new SMGDoublyLinkedListSegment(dlls1.getNestingLevel(), dlls1.getSize(), dlls1.getOffset(), dlls1.getHeadOffset(), dlls1.getNextOffset(), dlls1.getPrevOffset(), 0);
        this.mapping1.addMapping(dlls1, freshCopyDLLS1);
        this.destSMG = this.destSMG.copyAndAddObject(freshCopyDLLS1);
        this.recursiveCopyMapAndAddObject(dlls1, pNestingLevelDiff);
        Optional<SMGValue> resultOptional = this.destSMG.findAddressForEdge(freshCopyDLLS1, pToEdge1.getOffset(), pToEdge1.targetSpecifier());
        if (resultOptional.isEmpty()) {
            this.value = SMGValue.of(pValue1.getNestingLevel() + pNestingLevelDiff);
            this.mapping1.addMapping(pValue1, this.value);
            this.destSMG = this.destSMG.copyAndAddValue(this.value).copyAndAddPTEdge(new SMGPointsToEdge(freshCopyDLLS1, pToEdge1.getOffset(), pToEdge1.targetSpecifier()), this.value);
        } else {
            this.value = resultOptional.orElseThrow();
        }
        SMGJoinValues joinValues = new SMGJoinValues(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, nextValue, pValue2, pNestingLevelDiff);
        if (!joinValues.isDefined) {
            this.isDefined = false;
            return;
        }
        SMGHasValueEdge resultHasValueEdge = new SMGHasValueEdge(this.value, nextFieldOffset, dlls1.getSize());
        this.destSMG = this.destSMG.copyAndAddHVEdge(resultHasValueEdge, freshCopyDLLS1);
    }

    private void recursiveCopyMapAndAddObject(SMGObject objectToBeCopied, int pNestingLevelDiff) {
        this.inputSMG1.getEdges(objectToBeCopied).forEach(edge -> {
            SMGHasValueEdge hValueEdge;
            SMGValue subSmgValue = edge.hasValue();
            SMGObject mappedSubSmgObject = this.mapping1.getMappedObject(objectToBeCopied);
            SMGValue mappedSubSmgValue = subSmgValue;
            if (!subSmgValue.isZero() && this.inputSMG1.isPointer(subSmgValue)) {
                SMGPointsToEdge subSMGPointerEdge = this.inputSMG1.getPTEdge(subSmgValue).orElseThrow();
                SMGObject subSmgObject = subSMGPointerEdge.pointsTo();
                if (!this.mapping1.hasMapping(subSmgObject)) {
                    mappedSubSmgObject = subSmgObject.copyWithNewLevel(subSmgObject.getNestingLevel() + pNestingLevelDiff);
                    this.destSMG = this.destSMG.copyAndAddObject(mappedSubSmgObject);
                    this.mapping1.addMapping(subSmgObject, mappedSubSmgObject);
                    this.recursiveCopyMapAndAddObject(subSmgObject, pNestingLevelDiff);
                }
                if (!this.mapping1.hasMapping(subSmgValue)) {
                    mappedSubSmgValue = this.mapping1.getMappedValue(subSmgValue);
                } else {
                    mappedSubSmgValue = SMGValue.of(subSmgValue.getNestingLevel());
                    this.destSMG = this.destSMG.copyAndAddValue(mappedSubSmgValue);
                    this.mapping1.addMapping(subSmgValue, mappedSubSmgValue);
                }
                SMGPointsToEdge newEdge = new SMGPointsToEdge(mappedSubSmgObject, subSMGPointerEdge.getOffset(), subSMGPointerEdge.targetSpecifier());
                this.destSMG = this.destSMG.copyAndAddPTEdge(newEdge, mappedSubSmgValue);
            }
            if (!this.destSMG.hasOverlappingEdge(hValueEdge = new SMGHasValueEdge(mappedSubSmgValue, edge.getOffset(), edge.getSizeInBits()), mappedSubSmgObject)) {
                if (!this.destSMG.getValues().contains(mappedSubSmgValue)) {
                    this.destSMG = this.destSMG.copyAndAddValue(mappedSubSmgValue);
                }
                if (!this.mapping1.hasMapping(subSmgValue)) {
                    this.mapping1.addMapping(subSmgValue, mappedSubSmgValue);
                }
                this.destSMG = this.destSMG.copyAndAddHVEdge(hValueEdge, mappedSubSmgObject);
            }
        });
    }

    private boolean checkIfNotMatchingMappingsExists(SMGValue value1, SMGValue value2) {
        return this.mapping1.hasMapping(value1) && this.mapping2.hasMapping(value2) && this.mapping1.getMappedValue(value1).equals(this.mapping2.getMappedValue(value2));
    }

    private void updateExistingJoin(SMGObject pMappedObject, SMGValue pValue1, SMGValue pValue2, SMGValue nextValue, BigInteger offset, int pNestingLevelDiff, SMGTargetSpecifier targetSpecifier) {
        if (this.mapping2.mappingExists(pMappedObject)) {
            this.isRecoverableFailure = true;
            return;
        }
        if (this.mapping1.hasMapping(pValue1)) {
            this.value = this.mapping1.getMappedValue(pValue1);
            return;
        }
        this.value = SMGValue.of(pValue1.getNestingLevel());
        this.destSMG = this.destSMG.copyAndAddValue(this.value);
        SMGPointsToEdge edge = new SMGPointsToEdge(pMappedObject, offset, targetSpecifier);
        this.destSMG = this.destSMG.copyAndAddPTEdge(edge, this.value);
        this.mapping1.addMapping(pValue1, this.value);
        SMGJoinValues joinValues = new SMGJoinValues(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, nextValue, pValue2, pNestingLevelDiff);
        this.isDefined = joinValues.isDefined();
    }

    private void checkPointsToDLLs(SMGValue pValue) {
        Optional<SMGPointsToEdge> edgeOptionalV = this.inputSMG1.getPTEdge(pValue);
        Preconditions.checkArgument((boolean)edgeOptionalV.isPresent());
        SMGPointsToEdge pToEdge = edgeOptionalV.orElseThrow();
        SMGObject object = pToEdge.pointsTo();
        Preconditions.checkArgument((boolean)this.isDLLS(object), (Object)"Value 1 does not point to dlls.");
    }
}

