/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class SMGJoinFields {
    private SMG smg1;
    private SMG smg2;
    private SMGJoinStatus status = SMGJoinStatus.EQUAL;

    public SMGJoinFields(SMG pSmg1, SMG pSmg2) {
        this.smg1 = pSmg1;
        this.smg2 = pSmg2;
    }

    public void joinFields(SMGObject obj1, SMGObject obj2) {
        Preconditions.checkArgument((boolean)obj1.getSize().equals(obj2.getSize()), (Object)"SMG fields with different sizes cannot be joined.");
        Preconditions.checkArgument((this.smg1.getObjects().contains(obj1) && this.smg2.getObjects().contains(obj2) ? 1 : 0) != 0, (Object)"Only objects of givens SMGs can be joined.");
        PersistentSet<SMGHasValueEdge> obj1Edges = this.processHasValueEdgeSet(obj1, obj2, this.smg1, this.smg2);
        PersistentSet<SMGHasValueEdge> obj2Edges = this.processHasValueEdgeSet(obj2, obj1, this.smg2, this.smg1);
        SMG newSMG1 = this.smg1.copyAndSetHVEdges(obj1Edges, obj1);
        SMG newSMG2 = this.smg2.copyAndSetHVEdges(obj2Edges, obj2);
        this.updateStatus(this.smg1, newSMG1, SMGJoinStatus.LEFT_ENTAIL, obj1);
        this.updateStatus(this.smg2, newSMG2, SMGJoinStatus.RIGHT_ENTAIL, obj2);
        FluentIterable<SMGHasValueEdge> addObj1Edges = this.mergeNonNullValues(newSMG2, newSMG1, obj2, obj1);
        FluentIterable<SMGHasValueEdge> addObj2Edges = this.mergeNonNullValues(newSMG1, newSMG2, obj1, obj2);
        for (SMGHasValueEdge edge : addObj1Edges) {
            newSMG1 = newSMG1.copyAndAddValue(edge.hasValue());
            newSMG1 = newSMG1.copyAndAddHVEdge(edge, obj1);
        }
        for (SMGHasValueEdge edge : addObj2Edges) {
            newSMG2 = newSMG2.copyAndAddValue(edge.hasValue());
            newSMG2 = newSMG2.copyAndAddHVEdge(edge, obj2);
        }
        this.smg1 = newSMG1;
        this.smg2 = newSMG2;
    }

    @VisibleForTesting
    FluentIterable<SMGHasValueEdge> mergeNonNullValues(SMG pSMG1, SMG pSMG2, SMGObject pObject1, SMGObject pObject2) {
        PersistentSortedMap<BigInteger, SMGHasValueEdge> obj2OffsetToEdges = pSMG2.getEdges(pObject2).stream().collect(this.mapOffsetToEdgeCollector());
        return FluentIterable.from(pSMG1.getEdges(pObject1)).filter(edge -> !edge.hasValue().isZero() && !obj2OffsetToEdges.subMap((Object)edge.getOffset(), (Object)edge.getOffset().add(edge.getSizeInBits())).isEmpty()).transform(edge -> new SMGHasValueEdge(SMGValue.of(edge.hasValue().getNestingLevel()), edge.getOffset(), edge.getSizeInBits()));
    }

    @VisibleForTesting
    void updateStatus(SMG oldSmg, SMG newSmg, SMGJoinStatus pNewStatus, SMGObject object) {
        PersistentSortedMap<BigInteger, BigInteger> oldEdgesWithZeroOffsetToSize = this.getNullEdgesMapOffsetToSize(object, oldSmg);
        PersistentSortedMap<BigInteger, BigInteger> newEdgesWithZeroOffsetToSize = this.getNullEdgesMapOffsetToSize(object, newSmg);
        boolean applyUpdate = oldEdgesWithZeroOffsetToSize.entrySet().stream().anyMatch(entry -> !newEdgesWithZeroOffsetToSize.containsKey(entry.getKey()) || !((BigInteger)newEdgesWithZeroOffsetToSize.get(entry.getKey())).equals(entry.getValue()));
        if (applyUpdate) {
            this.status = this.status.updateWith(pNewStatus);
        }
    }

    @VisibleForTesting
    PersistentSet<SMGHasValueEdge> processHasValueEdgeSet(SMGObject obj1, SMGObject obj2, SMG pSmg1, SMG pSmg2) {
        FluentIterable<SMGHasValueEdge> edgesObj1Without0Address = pSmg1.getHasValueEdgesByPredicate(obj1, (com.google.common.base.Predicate<SMGHasValueEdge>)((com.google.common.base.Predicate)edge -> !edge.hasValue().isZero()));
        PersistentSortedMap<BigInteger, BigInteger> obj1EdgesWithZeroOffsetToSize = this.getNullEdgesMapOffsetToSize(obj1, pSmg1);
        PersistentSortedMap<BigInteger, BigInteger> map2 = this.getNullEdgesMapOffsetToSize(obj2, pSmg2);
        FluentIterable commonNullValueEdgeSet = FluentIterable.from((Iterable)obj1EdgesWithZeroOffsetToSize.entrySet()).transformAndConcat(entry -> this.getNullEdgesIntersection((Map.Entry<BigInteger, BigInteger>)entry, map2));
        FluentIterable obj2EdgesWithoutZero = pSmg2.getHasValueEdgesByPredicate(obj2, (com.google.common.base.Predicate<SMGHasValueEdge>)((com.google.common.base.Predicate)edge -> {
            if (edge.hasValue().isZero()) {
                return false;
            }
            BigInteger floor = edge.getOffset();
            BigInteger celing = edge.getOffset().add(edge.getSizeInBits());
            Map.Entry entry = obj1EdgesWithZeroOffsetToSize.floorEntry((Object)floor);
            return entry != null && ((BigInteger)entry.getKey()).add((BigInteger)entry.getValue()).compareTo(celing) >= 0;
        })).transform(edge -> new SMGHasValueEdge(SMGValue.zeroValue(), edge.getOffset(), edge.getSizeInBits()));
        return PersistentSet.copyOf(Iterables.concat(edgesObj1Without0Address, (Iterable)commonNullValueEdgeSet, (Iterable)obj2EdgesWithoutZero));
    }

    @VisibleForTesting
    FluentIterable<SMGHasValueEdge> getNullEdgesIntersection(Map.Entry<BigInteger, BigInteger> pEntry, PersistentSortedMap<BigInteger, BigInteger> pMap) {
        return FluentIterable.from(pMap.subMap((Object)pEntry.getKey(), true, (Object)pEntry.getKey().add(pEntry.getValue()), false).entrySet()).transform(next -> {
            BigInteger resultOffset = ((BigInteger)pEntry.getKey()).max((BigInteger)next.getKey());
            BigInteger resultSize = ((BigInteger)pEntry.getKey()).add((BigInteger)pEntry.getValue()).min(((BigInteger)next.getKey()).add((BigInteger)next.getValue()));
            return new SMGHasValueEdge(SMGValue.zeroValue(), resultOffset, resultSize);
        });
    }

    private PersistentSortedMap<BigInteger, BigInteger> getNullEdgesMapOffsetToSize(SMGObject pObj, SMG pSMG) {
        return pSMG.getEdges(pObj).stream().filter(this.createEqNullValuePredicate(true)).collect(this.mapOffsetToSizeCollector());
    }

    private Predicate<SMGHasValueEdge> createEqNullValuePredicate(boolean equals) {
        return edge -> equals == edge.hasValue().isZero();
    }

    private Collector<SMGHasValueEdge, ?, PersistentSortedMap<BigInteger, BigInteger>> mapOffsetToSizeCollector() {
        return PathCopyingPersistentTreeMap.toPathCopyingPersistentTreeMap(SMGHasValueEdge::getOffset, SMGHasValueEdge::getSizeInBits);
    }

    private Collector<SMGHasValueEdge, ?, PersistentSortedMap<BigInteger, SMGHasValueEdge>> mapOffsetToEdgeCollector() {
        return PathCopyingPersistentTreeMap.toPathCopyingPersistentTreeMap(SMGHasValueEdge::getOffset, e -> e);
    }

    public SMG getSmg1() {
        return this.smg1;
    }

    public SMG getSmg2() {
        return this.smg2;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }
}

