/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinFields;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinTest0;

public class SMGJoinFieldsTest
extends SMGJoinTest0 {
    private SMG smg1;
    private SMG smg2;
    private final SMGValue value1 = this.createValue();
    private final SMGValue value2 = this.createValue();

    @Before
    public void setUp() {
        this.smg1 = new SMG(mockType16bSize);
        this.smg2 = new SMG(mockType16bSize);
    }

    @Test
    @Ignore
    public void joinNulliefiedAndUndefinedFieldsTest() {
        SMGObject obj1 = this.createRegion(mockType16bSize);
        SMGObject obj2 = this.createRegion(mockType16bSize);
        SMGObject oth1 = this.createRegion(mockType16bSize);
        SMGObject oth2 = this.createRegion(mockType16bSize);
        SMGValue otherValue = this.createValue();
        SMGHasValueEdge obj1hv1at0 = this.createHasValueEdgeToZero(BigInteger.valueOf(40L));
        SMGHasValueEdge obj1hv2at7 = this.createHasValueEdgeToZero(mockType2bSize, 56);
        SMGHasValueEdge obj1hv3at9 = this.createHasValueEdge(56, 72, this.value1);
        SMGHasValueEdge obj2hv1at0 = this.createHasValueEdge(mockType4bSize, otherValue);
        SMGPointsToEdge obj2pt1to0 = this.createPTRegionEdge(0, obj2);
        SMGHasValueEdge obj2hv2at4 = this.createHasValueEdgeToZero(24, 32);
        SMGHasValueEdge obj2hv3at8 = this.createHasValueEdge(64, 64, this.value2);
        SMGHasValueEdge oth1hv1at0 = this.createHasValueEdgeToZero(40);
        SMGHasValueEdge oth1hv2at7 = this.createHasValueEdgeToZero(16, 56);
        SMGHasValueEdge oth1hv3at9 = this.createHasValueEdge(56, 72, this.value1);
        SMGHasValueEdge oth2hv1at0 = this.createHasValueEdge(32, 0, otherValue);
        SMGHasValueEdge oth2hv2at4 = this.createHasValueEdgeToZero(24, 32);
        SMGHasValueEdge oth2hv3at8 = this.createHasValueEdge(64, 64, this.value2);
        this.smg1 = this.smg1.copyAndAddObject(obj1);
        this.smg1 = this.smg1.copyAndAddObject(oth1);
        this.smg2 = this.smg2.copyAndAddObject(obj2);
        this.smg2 = this.smg2.copyAndAddObject(oth2);
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smg2 = this.smg2.copyAndAddValue(otherValue);
        this.smg1 = this.smg1.copyAndAddHVEdge(obj1hv1at0, obj1);
        this.smg1 = this.smg1.copyAndAddHVEdge(obj1hv2at7, obj1);
        this.smg1 = this.smg1.copyAndAddHVEdge(obj1hv3at9, obj1);
        this.smg1 = this.smg1.copyAndAddHVEdge(oth1hv1at0, oth1);
        this.smg1 = this.smg1.copyAndAddHVEdge(oth1hv2at7, oth1);
        this.smg1 = this.smg1.copyAndAddHVEdge(oth1hv3at9, oth1);
        this.smg2 = this.smg2.copyAndAddHVEdge(obj2hv1at0, obj2);
        this.smg2 = this.smg2.copyAndAddHVEdge(obj2hv2at4, obj2);
        this.smg2 = this.smg2.copyAndAddHVEdge(obj2hv3at8, obj2);
        this.smg2 = this.smg2.copyAndAddHVEdge(oth2hv1at0, oth2);
        this.smg2 = this.smg2.copyAndAddHVEdge(oth2hv2at4, oth2);
        this.smg2 = this.smg2.copyAndAddHVEdge(oth2hv3at8, oth2);
        this.smg2 = this.smg2.copyAndAddPTEdge(obj2pt1to0, otherValue);
        SMGJoinFields join = new SMGJoinFields(this.smg1, this.smg2);
        join.joinFields(obj1, obj2);
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.INCOMPARABLE);
        HashMap<BigInteger, Pair<SMGValue, BigInteger>> fieldMap1 = new HashMap<BigInteger, Pair<SMGValue, BigInteger>>();
        HashMap<BigInteger, Pair<SMGValue, BigInteger>> fieldMap2 = new HashMap<BigInteger, Pair<SMGValue, BigInteger>>();
        fieldMap1.put(BigInteger.valueOf(0L), Pair.of(SMGValue.zeroValue(), BigInteger.valueOf(40L)));
        fieldMap1.put(BigInteger.valueOf(72L), Pair.of(this.value1, BigInteger.valueOf(56L)));
        fieldMap2.put(BigInteger.valueOf(0L), Pair.of(otherValue, BigInteger.valueOf(32L)));
        fieldMap2.put(BigInteger.valueOf(32L), Pair.of(SMGValue.zeroValue(), BigInteger.valueOf(8L)));
        fieldMap2.put(BigInteger.valueOf(64L), Pair.of(this.value2, BigInteger.valueOf(64L)));
        this.checkFields(join.getSmg1(), fieldMap1, obj1);
        this.checkFields(join.getSmg2(), fieldMap2, obj2);
    }

    private void checkFields(SMG pSmg, Map<BigInteger, Pair<SMGValue, BigInteger>> pFieldMap, SMGObject pObj) {
        Set<SMGHasValueEdge> edges = pSmg.getEdges(pObj);
        Truth.assertThat(edges).hasSize(pFieldMap.size());
        for (SMGHasValueEdge edge : edges) {
            BigInteger offset = edge.getOffset();
            Truth.assertThat(pFieldMap).containsKey((Object)offset);
            SMGValue value = edge.hasValue();
            BigInteger length = edge.getSizeInBits();
            Pair<SMGValue, BigInteger> expectedValueAndLength = pFieldMap.get(offset);
            SMGValue eValue = expectedValueAndLength.getFirst();
            BigInteger eLength = expectedValueAndLength.getSecond();
            Truth.assertThat((Comparable)value).isEqualTo((Object)eValue);
            Truth.assertThat((Comparable)length).isEqualTo((Object)eLength);
        }
    }

    @Test
    @Ignore
    public void processHVEdgeSetTest() {
        SMGObject obj = this.createRegion(mockType32bSize);
        SMGObject differentObject = this.createRegion(mockType16bSize);
        this.smg1 = this.smg1.copyAndAddObject(obj);
        this.smg2 = this.smg2.copyAndAddObject(obj);
        this.smg1 = this.smg1.copyAndAddObject(differentObject);
        this.smg2 = this.smg2.copyAndAddValue(this.value1);
        SMGHasValueEdge hv0for4at0in1 = this.createHasValueEdgeToZero(mockType4bSize);
        SMGHasValueEdge hv0for4at0in2 = this.createHasValueEdgeToZero(mockType4bSize);
        SMGHasValueEdge hv0for4at5in1 = this.createHasValueEdgeToZero(mockType4bSize, 40);
        SMGHasValueEdge hv0for4at7in2 = this.createHasValueEdgeToZero(mockType4bSize, 56);
        SMGHasValueEdge hv0for4at12in1 = this.createHasValueEdgeToZero(mockType4bSize, 96);
        SMGHasValueEdge hv0for4at16in2 = this.createHasValueEdgeToZero(mockType4bSize, 128);
        SMGHasValueEdge hv0for4at20in1 = this.createHasValueEdgeToZero(mockType4bSize, 160);
        SMGHasValueEdge hv666for4at20in2 = this.createHasValueEdge(mockType4bSize, 160, this.value1);
        SMGHasValueEdge hv666for4at28in2 = this.createHasValueEdge(mockType4bSize, 224, this.value1);
        SMGHasValueEdge diffObjectNullValue = this.createHasValueEdgeToZero(mockType4bSize, 0);
        this.smg1 = this.smg1.copyAndAddHVEdge(hv0for4at0in1, obj);
        this.smg1 = this.smg1.copyAndAddHVEdge(hv0for4at5in1, obj);
        this.smg1 = this.smg1.copyAndAddHVEdge(hv0for4at12in1, obj);
        this.smg1 = this.smg1.copyAndAddHVEdge(hv0for4at20in1, obj);
        this.smg1 = this.smg1.copyAndAddHVEdge(diffObjectNullValue, differentObject);
        this.smg2 = this.smg2.copyAndAddHVEdge(hv0for4at0in2, obj);
        this.smg2 = this.smg2.copyAndAddHVEdge(hv0for4at7in2, obj);
        this.smg2 = this.smg2.copyAndAddHVEdge(hv0for4at16in2, obj);
        this.smg2 = this.smg2.copyAndAddHVEdge(hv666for4at20in2, obj);
        this.smg2 = this.smg2.copyAndAddPTEdge(this.createPTRegionEdge(160, obj), this.value1);
        this.smg2 = this.smg2.copyAndAddHVEdge(hv666for4at28in2, obj);
        SMGJoinFields jFields = new SMGJoinFields(this.smg1, this.smg2);
        PersistentSet<SMGHasValueEdge> edgesFluentIterable = jFields.processHasValueEdgeSet(obj, obj, this.smg1, this.smg2);
        Truth.assertThat(edgesFluentIterable).hasSize(4);
        edgesFluentIterable = jFields.processHasValueEdgeSet(obj, obj, this.smg2, this.smg1);
        Truth.assertThat(edgesFluentIterable).hasSize(4);
    }

    @Ignore
    @Test
    public void mergeNonNullHVEdgesTest() {
        HashSet<SMGValue> values = new HashSet<SMGValue>();
        values.add(this.value1);
        values.add(this.value2);
        SMGObject object = this.createRegion(mockType16bSize);
        SMGHasValueEdge smg1_4bFrom0ToV1 = this.createHasValueEdge(mockType4bSize, this.value1);
        SMGHasValueEdge smg1_4bFrom4ToV2 = this.createHasValueEdge(mockType4bSize, 32, this.value2);
        SMGHasValueEdge smg1_4bFrom8ToNull = this.createHasValueEdgeToZero(mockType4bSize, 64);
        this.smg1 = this.smg1.copyAndAddObject(object);
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg1 = this.smg1.copyAndAddValue(this.value2);
        this.smg1 = this.smg1.copyAndAddHVEdge(smg1_4bFrom8ToNull, object);
        this.smg1 = this.smg1.copyAndAddHVEdge(smg1_4bFrom4ToV2, object);
        this.smg1 = this.smg1.copyAndAddHVEdge(smg1_4bFrom0ToV1, object);
        this.smg2 = this.smg2.copyAndAddObject(object);
        SMGJoinFields jFields = new SMGJoinFields(this.smg1, this.smg2);
        ImmutableSet hvSet = jFields.mergeNonNullValues(this.smg1, this.smg2, object, object).toSet();
        Truth.assertThat((Iterable)hvSet).hasSize(2);
        boolean seenZero = false;
        boolean seenTwo = false;
        for (SMGHasValueEdge edge : hvSet) {
            if (edge.getOffset().equals(BigInteger.ZERO)) {
                seenZero = true;
            } else if (edge.getOffset().equals(BigInteger.valueOf(32L))) {
                seenTwo = true;
            }
            Truth.assertThat((Comparable)edge.getOffset()).isAnyOf((Object)BigInteger.ZERO, (Object)BigInteger.valueOf(32L), new Object[0]);
            Truth.assertThat((Comparable)edge.getSizeInBits()).isEqualTo((Object)mockType4bSize);
            Truth.assertThat(values).doesNotContain((Object)edge.hasValue());
            values.add(edge.hasValue());
        }
        Truth.assertThat((Boolean)seenZero).isTrue();
        Truth.assertThat((Boolean)seenTwo).isTrue();
        this.smg2 = this.smg2.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddHVEdge(smg1_4bFrom0ToV1, object);
        hvSet = jFields.mergeNonNullValues(this.smg1, this.smg2, object, object).toSet();
        Truth.assertThat((Iterable)hvSet).hasSize(1);
    }

    @Ignore
    @Test
    public void mergeNonNullAplliedTest() {
        SMGObject obj1 = this.createRegion(mockType8bSize);
        SMGObject obj2 = this.createRegion(mockType8bSize);
        this.smg1 = this.smg1.copyAndAddObject(obj1);
        this.smg2 = this.smg2.copyAndAddObject(obj2);
        SMGValue value3 = this.createValue();
        this.smg1 = this.smg1.copyAndAddValue(value3);
        this.smg1 = this.smg1.copyAndAddHVEdge(this.createHasValueEdge(mockType4bSize, value3), obj1);
        SMGJoinFields jf = new SMGJoinFields(this.smg1, this.smg2);
        jf.joinFields(obj1, obj2);
        SMG resultSMG = jf.getSmg2();
        Set<SMGHasValueEdge> edges = resultSMG.getEdges(obj2);
        Truth.assertThat((Boolean)edges.isEmpty()).isFalse();
        jf = new SMGJoinFields(this.smg2, this.smg1);
        jf.joinFields(obj2, obj1);
        resultSMG = jf.getSmg1();
        edges = resultSMG.getEdges(obj2);
        Truth.assertThat((Boolean)edges.isEmpty()).isFalse();
    }

    @Ignore
    @Test
    public void joinFieldsRelaxStatusTest() {
        SMGObject object = this.createRegion(mockType8bSize);
        this.smg1 = this.smg1.copyAndAddObject(object);
        SMG smg0_0B_4B = this.smg1.copyAndAddHVEdge(new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, mockType4bSize), object);
        SMG smg0_2B_6B = this.smg1.copyAndAddHVEdge(new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(16L), mockType4bSize), object);
        SMG smg0_4B_8B = this.smg1.copyAndAddHVEdge(new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(32L), mockType4bSize), object);
        SMG smg0_0B_8B = this.smg1.copyAndAddHVEdge(new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.ZERO, mockType4bSize), object).copyAndAddHVEdge(new SMGHasValueEdge(SMGValue.zeroValue(), BigInteger.valueOf(32L), mockType4bSize), object);
        this.checkStatusAfterRelax(SMGJoinStatus.EQUAL, smg0_0B_8B, smg0_0B_8B, object);
        this.checkStatusAfterRelax(SMGJoinStatus.INCOMPARABLE, smg0_0B_8B, smg0_0B_4B, object);
        this.checkStatusAfterRelax(SMGJoinStatus.INCOMPARABLE, smg0_0B_8B, smg0_4B_8B, object);
        this.checkStatusAfterRelax(SMGJoinStatus.INCOMPARABLE, smg0_0B_8B, smg0_2B_6B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.EQUAL, smg0_0B_8B, smg0_0B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.LEFT_ENTAIL, smg0_0B_8B, smg0_0B_4B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.LEFT_ENTAIL, smg0_0B_8B, smg0_2B_6B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.LEFT_ENTAIL, smg0_0B_8B, smg0_4B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.RIGHT_ENTAIL, smg0_0B_4B, smg0_0B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.RIGHT_ENTAIL, smg0_2B_6B, smg0_0B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.RIGHT_ENTAIL, smg0_4B_8B, smg0_0B_8B, object);
    }

    private void checkStatusAfterRelax(SMGJoinStatus expected, SMG a, SMG b, SMGObject object) {
        SMGJoinFields js = new SMGJoinFields(a, a);
        js.updateStatus(a, b, SMGJoinStatus.INCOMPARABLE, object);
        Truth.assertThat((Comparable)((Object)js.getStatus())).isEqualTo((Object)expected);
    }

    private void checkStatusAfterJoinFields(SMGJoinStatus expected, SMG a, SMG b, SMGObject object) {
        SMGJoinFields js = new SMGJoinFields(a, b);
        js.joinFields(object, object);
        Truth.assertThat((Comparable)((Object)js.getStatus())).isEqualTo((Object)expected);
    }

    @Test
    public void nonMemberObjectTest1() {
        SMG smg3 = new SMG(mockType32bSize);
        SMG smg4 = new SMG(mockType32bSize);
        SMGObject obj1 = this.createRegion(mockType32bSize);
        SMGObject obj2 = this.createRegion(mockType32bSize);
        smg4 = smg4.copyAndAddObject(obj2);
        SMGJoinFields jFields = new SMGJoinFields(smg3, smg4);
        Assert.assertThrows(IllegalArgumentException.class, () -> jFields.joinFields(obj1, obj2));
    }

    @Test
    public void nonMemberObjectTest2() {
        SMG smg3 = new SMG(mockType32bSize);
        SMG smg4 = new SMG(mockType32bSize);
        SMGObject obj1 = this.createRegion(mockType32bSize);
        SMGObject obj2 = this.createRegion(mockType32bSize);
        smg3 = smg3.copyAndAddObject(obj1);
        SMGJoinFields jFields = new SMGJoinFields(smg3, smg4);
        Assert.assertThrows(IllegalArgumentException.class, () -> jFields.joinFields(obj1, obj2));
    }
}

