/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentStack;
import org.sosy_lab.cpachecker.cpa.smg2.StackFrame;
import org.sosy_lab.cpachecker.cpa.smg2.SymbolicProgramConfiguration;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinSubSMGs;

public class SMGJoinSPC
extends SMGAbstractJoin {
    private final SymbolicProgramConfiguration inputSPC1;
    private final SymbolicProgramConfiguration inputSPC2;
    private Map<String, SMGObject> resultGolbalMapping = new TreeMap<String, SMGObject>();
    private PersistentStack<StackFrame> resultStackMapping = PersistentStack.of();
    private SymbolicProgramConfiguration resultSPC;

    public SMGJoinSPC(SymbolicProgramConfiguration pSpc1, SymbolicProgramConfiguration pSpc2) {
        super(SMGJoinStatus.EQUAL, pSpc1.getSmg(), pSpc2.getSmg(), new SMG(pSpc1.getSmg().getSizeOfPointer()), new NodeMapping(), new NodeMapping());
        this.inputSPC1 = pSpc1;
        this.inputSPC2 = pSpc2;
        this.checkVariableRanges();
        for (Map.Entry variableAndObject : this.inputSPC1.getGlobalVariableToSmgObjectMap().entrySet()) {
            SMGObject destObject = this.joinVariable((SMGObject)variableAndObject.getValue(), (SMGObject)this.inputSPC2.getGlobalVariableToSmgObjectMap().get(variableAndObject.getKey()));
            this.resultGolbalMapping.put((String)variableAndObject.getKey(), destObject);
            if (!this.status.equals((Object)SMGJoinStatus.INCOMPARABLE)) continue;
            return;
        }
        Iterator<StackFrame> smg1stackIterator = this.inputSPC1.getStackFrames().iterator();
        Iterator<StackFrame> smg2stackIterator = this.inputSPC1.getStackFrames().iterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            StackFrame frameInSMG1 = smg1stackIterator.next();
            StackFrame frameInSMG2 = smg2stackIterator.next();
            TreeMap<String, SMGObject> frameMapping = new TreeMap<String, SMGObject>();
            for (Map.Entry<String, SMGObject> variableAndObject : frameInSMG1.getVariables().entrySet()) {
                SMGObject localInSMG1 = variableAndObject.getValue();
                SMGObject localInSMG2 = frameInSMG2.getVariable(variableAndObject.getKey());
                SMGObject destObject = this.joinVariable(localInSMG1, localInSMG2);
                frameMapping.put(variableAndObject.getKey(), destObject);
                if (!this.status.equals((Object)SMGJoinStatus.INCOMPARABLE)) continue;
                return;
            }
            Optional<SMGObject> returnOptional = Optional.empty();
            if (frameInSMG1.getReturnObject().isPresent()) {
                SMGObject returnObjectInSmg1 = frameInSMG1.getReturnObject().orElseThrow();
                SMGObject returnObjectInSmg2 = frameInSMG2.getReturnObject().orElseThrow();
                returnOptional = Optional.of(this.joinVariable(returnObjectInSmg1, returnObjectInSmg2));
                if (this.status.equals((Object)SMGJoinStatus.INCOMPARABLE)) {
                    return;
                }
            }
            this.resultStackMapping = this.resultStackMapping.pushAndCopy(frameInSMG1.copyWith(returnOptional, frameMapping));
        }
        if (this.resultDLSHaveNewCycles()) {
            this.status = this.status.updateWith(SMGJoinStatus.INCOMPARABLE);
            return;
        }
        this.resultSPC = SymbolicProgramConfiguration.of(this.destSMG, (PersistentMap<String, SMGObject>)PathCopyingPersistentTreeMap.copyOf(this.resultGolbalMapping), this.resultStackMapping, PersistentSet.of(), (PersistentMap<SMGObject, Boolean>)PathCopyingPersistentTreeMap.of(), (ImmutableBiMap<Equivalence.Wrapper<Value>, SMGValue>)ImmutableBiMap.of(), (PersistentMap<String, CType>)PathCopyingPersistentTreeMap.of());
    }

    private SMGObject joinVariable(SMGObject obj1, SMGObject obj2) {
        SMGObject newObject = obj1.freshCopy();
        this.destSMG = this.destSMG.copyAndAddObject(newObject);
        this.mapping1.addMapping(obj1, newObject);
        this.mapping2.addMapping(obj2, newObject);
        SMGJoinSubSMGs joinSubSMGs = new SMGJoinSubSMGs(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, obj1, obj2, newObject, 0);
        if (!joinSubSMGs.isDefined() || joinSubSMGs.isRecoverableFailur()) {
            this.status = this.status.updateWith(SMGJoinStatus.INCOMPARABLE);
        } else {
            this.copyJoinState(joinSubSMGs);
        }
        return newObject;
    }

    private void checkVariableRanges() {
        Set spc1Variables = this.inputSPC1.getGlobalVariableToSmgObjectMap().keySet();
        Set spc2Variables = this.inputSPC2.getGlobalVariableToSmgObjectMap().keySet();
        Preconditions.checkArgument((boolean)spc1Variables.containsAll(spc2Variables), (Object)"Variable ranges are not equal.");
    }

    public SymbolicProgramConfiguration getResult() {
        Preconditions.checkNotNull((Object)this.resultSPC);
        return this.resultSPC;
    }
}

