/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Predicate;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.exception.SMGJoinException;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinFields;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinValues;

public class SMGJoinSubSMGs
extends SMGAbstractJoin {
    public SMGJoinSubSMGs(SMGJoinStatus initialStatus, SMG pSMG1, SMG pSMG2, SMG pDestSMG, NodeMapping pMapping1, NodeMapping pMapping2, SMGObject pObj1, SMGObject pObj2, SMGObject pNewObject, int pLDiff) {
        super(initialStatus, pSMG1, pSMG2, pDestSMG, pMapping1, pMapping2);
        this.joinFields(pObj1, pObj2);
        this.joinValues(pObj1, pObj2, pNewObject, pLDiff);
    }

    private void joinFields(SMGObject pObj1, SMGObject pObj2) {
        SMGJoinFields joinFields = new SMGJoinFields(this.inputSMG1, this.inputSMG2);
        joinFields.joinFields(pObj1, pObj2);
        this.inputSMG1 = joinFields.getSmg1();
        this.inputSMG2 = joinFields.getSmg2();
        this.status = this.status.updateWith(joinFields.getStatus());
    }

    private void joinValues(SMGObject pObj1, SMGObject pObj2, SMGObject pNewObject, int nestingLevelDiff) {
        for (SMGHasValueEdge edge1 : this.inputSMG1.getEdges(pObj1)) {
            SMGHasValueEdge edge2 = this.inputSMG2.getHasValueEdgeByPredicate(pObj2, (Predicate<SMGHasValueEdge>)((Predicate)o -> o.getOffset().equals(edge1.getOffset()))).orElseThrow(() -> new SMGJoinException(pObj2 + " misses edge with offset " + edge1.getOffset()));
            SMGValue value1 = edge1.hasValue();
            SMGValue value2 = edge2.hasValue();
            int newNestingLevelDiff = this.updateNestinglevelDiff(pObj1, edge1, nestingLevelDiff, 1);
            newNestingLevelDiff = this.updateNestinglevelDiff(pObj2, edge2, newNestingLevelDiff, -1);
            SMGJoinValues joinValues = new SMGJoinValues(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, value1, value2, newNestingLevelDiff);
            this.status = joinValues.getStatus();
            if (!joinValues.isDefined() && !joinValues.isRecoverableFailur()) {
                this.status = SMGJoinStatus.INCOMPARABLE;
                return;
            }
            this.inputSMG1 = joinValues.getInputSMG1();
            this.inputSMG2 = joinValues.getInputSMG2();
            this.destSMG = joinValues.getDestinationSMG();
            this.value = joinValues.getValue();
            SMGHasValueEdge newHVEdge = new SMGHasValueEdge(joinValues.getValue(), edge1.getOffset(), edge1.getSizeInBits());
            this.destSMG = this.destSMG.copyAndAddHVEdge(newHVEdge, pNewObject);
        }
    }

    private int updateNestinglevelDiff(SMGObject pObj, SMGHasValueEdge pEdge, int pLevel, int pAccumulator) {
        SMGDoublyLinkedListSegment doublyLinkedListSegment;
        if (pObj instanceof SMGDoublyLinkedListSegment && this.matchesOffsetAndSize(doublyLinkedListSegment = (SMGDoublyLinkedListSegment)pObj, pEdge)) {
            pLevel += pAccumulator;
        }
        return pLevel;
    }

    private boolean matchesOffsetAndSize(SMGDoublyLinkedListSegment dlls, SMGHasValueEdge edge) {
        if (dlls.getSize().equals(edge.getSizeInBits())) {
            return !dlls.getNextOffset().equals(edge.getOffset()) && !dlls.getPrevOffset().equals(edge.getOffset());
        }
        return false;
    }
}

