/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Predicate;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGNode;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinSubSMGs;

public class SMGJoinSubSMGsForAbstraction
extends SMGAbstractJoin {
    private final PersistentSet<SMGObject> smgObjectsMappedinSMG1;
    private final PersistentSet<SMGObject> smgObjectsMappedinSMG2;
    private final PersistentSet<SMGValue> smgValuesMappedinSMG1;
    private final PersistentSet<SMGValue> smgValuesMappedinSMG2;

    public SMGJoinSubSMGsForAbstraction(SMGJoinStatus initialStatus, SMG pSMG1, SMG pSMG2, SMG pDestSMG, SMGObject pObj1, SMGObject pObj2, BigInteger headOffset, BigInteger nextOffset, BigInteger prevOffset) {
        super(initialStatus, pSMG1, pSMG2, pDestSMG, new NodeMapping(), new NodeMapping());
        Optional<SMGHasValueEdge> nextEdgeObj1 = this.destSMG.getHasValueEdgeByPredicate(pObj1, (Predicate<SMGHasValueEdge>)((Predicate)e -> e.getOffset().equals(nextOffset)));
        Optional<SMGHasValueEdge> prevEdgeObj1 = this.destSMG.getHasValueEdgeByPredicate(pObj1, (Predicate<SMGHasValueEdge>)((Predicate)e -> e.getOffset().equals(prevOffset)));
        Optional<SMGHasValueEdge> nextEdgeObj2 = this.destSMG.getHasValueEdgeByPredicate(pObj2, (Predicate<SMGHasValueEdge>)((Predicate)e -> e.getOffset().equals(nextOffset)));
        Optional<SMGHasValueEdge> prevEdgeObj2 = this.destSMG.getHasValueEdgeByPredicate(pObj2, (Predicate<SMGHasValueEdge>)((Predicate)e -> e.getOffset().equals(prevOffset)));
        Map<Pair<SMGObject, SMGHasValueEdge>, SMGHasValueEdge> tempEdgeMapping = this.replaceEdgesByZeroEdges(pObj1, pObj2, prevEdgeObj1, nextEdgeObj1, nextEdgeObj2, prevEdgeObj2);
        SMGObject newObject = this.extendDestWithFreshDls(pObj1, pObj2, nextOffset, prevOffset, headOffset);
        int lDiff = pObj1.getClass().equals(pObj2.getClass()) ? 0 : (this.isDLLS(pObj1) ? 1 : -1);
        this.mapping1.addMapping(pObj1, newObject);
        this.mapping2.addMapping(pObj2, newObject);
        SMGJoinSubSMGs smgJoinSubSMGs = new SMGJoinSubSMGs(SMGJoinStatus.EQUAL, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pObj1, pObj2, newObject, lDiff);
        if (!smgJoinSubSMGs.isDefined) {
            this.setBottomState();
            this.smgObjectsMappedinSMG1 = PersistentSet.of();
            this.smgObjectsMappedinSMG2 = PersistentSet.of();
            this.smgValuesMappedinSMG1 = PersistentSet.of();
            this.smgValuesMappedinSMG2 = PersistentSet.of();
            return;
        }
        this.copyJoinState(smgJoinSubSMGs);
        if (this.resultDLSHaveNewCycles()) {
            this.setBottomState();
            this.smgObjectsMappedinSMG1 = PersistentSet.of();
            this.smgObjectsMappedinSMG2 = PersistentSet.of();
            this.smgValuesMappedinSMG1 = PersistentSet.of();
            this.smgValuesMappedinSMG2 = PersistentSet.of();
            return;
        }
        if (this.isRegion(pObj1) && this.isRegion(pObj2)) {
            this.relabelPTEdges(newObject);
            this.increaseLevelOfMapped();
        }
        this.dropTempZeroEdges(tempEdgeMapping);
        HashSet tmpObjectsMappedinSMG1 = new HashSet();
        HashSet tmpObjectsMappedinSMG2 = new HashSet();
        HashSet tmpSMGValuesMappedinSMG1 = new HashSet();
        HashSet tmpSMGValuesMappedinSMG2 = new HashSet();
        this.fillWithIntersectingNodes(tmpObjectsMappedinSMG1, this.mapping1.getMappedObjects(), this.destSMG.getObjects());
        this.fillWithIntersectingNodes(tmpObjectsMappedinSMG2, this.mapping2.getMappedObjects(), this.destSMG.getObjects());
        this.fillWithIntersectingNodes(tmpSMGValuesMappedinSMG1, this.mapping1.getMappedValues(), this.destSMG.getValues());
        this.fillWithIntersectingNodes(tmpSMGValuesMappedinSMG2, this.mapping2.getMappedValues(), this.destSMG.getValues());
        this.smgObjectsMappedinSMG1 = PersistentSet.copyOf(tmpObjectsMappedinSMG1);
        this.smgObjectsMappedinSMG2 = PersistentSet.copyOf(tmpObjectsMappedinSMG2);
        this.smgValuesMappedinSMG1 = PersistentSet.copyOf(tmpSMGValuesMappedinSMG1);
        this.smgValuesMappedinSMG2 = PersistentSet.copyOf(tmpSMGValuesMappedinSMG2);
    }

    private <V extends SMGNode> void fillWithIntersectingNodes(Collection<V> target, Collection<V> mapping, Collection<V> original) {
        for (SMGNode node : mapping) {
            if (!original.contains(node)) continue;
            target.add(node);
        }
    }

    private void dropTempZeroEdges(Map<Pair<SMGObject, SMGHasValueEdge>, SMGHasValueEdge> pTempEdgeMapping) {
        pTempEdgeMapping.entrySet().forEach(entry -> {
            this.destSMG = this.destSMG.copyAndReplaceHVEdge((SMGObject)((Pair)entry.getKey()).getFirst(), (SMGHasValueEdge)entry.getValue(), (SMGHasValueEdge)((Pair)entry.getKey()).getSecond());
        });
    }

    private void increaseLevelOfMapped() {
        for (SMGObject mappedObj : this.mapping1.getMappedObjects()) {
            this.mapping1.replaceObjectMapping(mappedObj, mappedObj.withNestingLevelAndCopy(mappedObj.getNestingLevel() + 1));
        }
        for (SMGValue mappedVal : this.mapping1.getMappedValues()) {
            this.mapping1.replaceValueMapping(mappedVal, mappedVal.withNestingLevelAndCopy(mappedVal.getNestingLevel() + 1));
        }
        for (SMGObject mappedObj : this.mapping2.getMappedObjects()) {
            this.mapping2.replaceObjectMapping(mappedObj, mappedObj.withNestingLevelAndCopy(mappedObj.getNestingLevel() + 1));
        }
        for (SMGValue mappedVal : this.mapping2.getMappedValues()) {
            this.mapping2.replaceValueMapping(mappedVal, mappedVal.withNestingLevelAndCopy(mappedVal.getNestingLevel() + 1));
        }
    }

    private void relabelPTEdges(SMGObject pNewObject) {
        this.destSMG.getPTEdgesByTarget(pNewObject).forEach(ptEdge -> ptEdge.setTargetSpecifier(SMGTargetSpecifier.IS_ALL_POINTER));
    }

    private Map<Pair<SMGObject, SMGHasValueEdge>, SMGHasValueEdge> replaceEdgesByZeroEdges(SMGObject pObj1, SMGObject pObj2, Optional<SMGHasValueEdge> pNextEdge1, Optional<SMGHasValueEdge> pPrevEdge1, Optional<SMGHasValueEdge> pNextEdge2, Optional<SMGHasValueEdge> pPrevEdge2) {
        HashMap<Pair<SMGObject, SMGHasValueEdge>, SMGHasValueEdge> retMap = new HashMap<Pair<SMGObject, SMGHasValueEdge>, SMGHasValueEdge>();
        this.insertTempZeroEdgeMapping(retMap, pObj1, pNextEdge1);
        this.insertTempZeroEdgeMapping(retMap, pObj1, pPrevEdge1);
        this.insertTempZeroEdgeMapping(retMap, pObj2, pNextEdge2);
        this.insertTempZeroEdgeMapping(retMap, pObj2, pPrevEdge2);
        return retMap;
    }

    private void insertTempZeroEdgeMapping(Map<Pair<SMGObject, SMGHasValueEdge>, SMGHasValueEdge> mapping, SMGObject pObj, Optional<SMGHasValueEdge> edgeOptional) {
        if (edgeOptional.isPresent()) {
            SMGHasValueEdge pOldEdge = edgeOptional.orElseThrow();
            SMGHasValueEdge newEdge = new SMGHasValueEdge(SMGValue.zeroValue(), pOldEdge.getOffset(), pOldEdge.getSizeInBits());
            this.destSMG = this.destSMG.copyAndReplaceHVEdge(pObj, pOldEdge, newEdge);
            mapping.put(Pair.of(pObj, pOldEdge), newEdge);
        }
    }

    private SMGObject extendDestWithFreshDls(SMGObject pObj1, SMGObject pObj2, BigInteger pNextOffset, BigInteger pPrevOffset, BigInteger pHeadOffset) {
        int minLength = 0;
        if (this.isDLLS(pObj1)) {
            minLength += ((SMGDoublyLinkedListSegment)pObj1).getMinLength();
        }
        if (this.isDLLS(pObj2)) {
            minLength += ((SMGDoublyLinkedListSegment)pObj2).getMinLength();
        }
        SMGDoublyLinkedListSegment dls = new SMGDoublyLinkedListSegment(pObj1.getNestingLevel(), pObj1.getSize(), pObj1.getOffset(), pHeadOffset, pNextOffset, pPrevOffset, minLength);
        this.destSMG = this.destSMG.copyAndAddObject(dls);
        return dls;
    }

    public PersistentSet<SMGObject> getSmgObjectsMappedinSMG1() {
        return this.smgObjectsMappedinSMG1;
    }

    public PersistentSet<SMGObject> getSmgObjectsMappedinSMG2() {
        return this.smgObjectsMappedinSMG2;
    }

    public PersistentSet<SMGValue> getSmgValuesMappedinSMG1() {
        return this.smgValuesMappedinSMG1;
    }

    public PersistentSet<SMGValue> getSmgValuesMappedinSMG2() {
        return this.smgValuesMappedinSMG2;
    }
}

