/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinSubSMGs;
import org.sosy_lab.cpachecker.util.smg.join.SMGMapTargetAddress;
import org.sosy_lab.cpachecker.util.smg.join.SMGMatchObjects;

public class SMGJoinTargetObjects
extends SMGAbstractJoin {
    public SMGJoinTargetObjects(SMGJoinStatus pStatus, SMG pInputSMG1, SMG pInputSMG2, SMG pDestSMG, NodeMapping pMapping1, NodeMapping pMapping2, SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        super(pStatus, pInputSMG1, pInputSMG2, pDestSMG, pMapping1, pMapping2);
        this.joinTargetObjects(pValue1, pValue2, pNestingLevelDiff);
    }

    public void joinTargetObjects(SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        Optional<SMGPointsToEdge> edgeOptionalV1 = this.inputSMG1.getPTEdge(pValue1);
        Optional<SMGPointsToEdge> edgeOptionalV2 = this.inputSMG2.getPTEdge(pValue2);
        Preconditions.checkArgument((edgeOptionalV1.isPresent() && edgeOptionalV2.isPresent() ? 1 : 0) != 0);
        SMGPointsToEdge pToEdge1 = edgeOptionalV1.orElseThrow();
        SMGPointsToEdge pToEdge2 = edgeOptionalV2.orElseThrow();
        if (!this.checkCompatibility(pToEdge1, pToEdge2, pValue1, pValue2, pNestingLevelDiff)) {
            this.isDefined = false;
            this.isRecoverableFailure = true;
            return;
        }
        if (this.checkForJoinedTargetObjects(pToEdge1.pointsTo(), pToEdge2.pointsTo())) {
            SMGMapTargetAddress mapTargetAddress = new SMGMapTargetAddress(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pValue1, pValue2);
            this.copyJoinState(mapTargetAddress);
            return;
        }
        if (this.checkForRecoverableFailure(pToEdge1, pToEdge2)) {
            this.isDefined = false;
            this.isRecoverableFailure = true;
            return;
        }
        SMGObject newObject = this.createNewObject(pToEdge1.pointsTo(), pToEdge2.pointsTo());
        this.destSMG = this.destSMG.copyAndAddObject(newObject);
        if (!(this.inputSMG1.isValid(pToEdge1.pointsTo()) || this.isDLLS(pToEdge1.pointsTo()) || this.inputSMG2.isValid(pToEdge2.pointsTo()))) {
            this.destSMG = this.destSMG.copyAndInvalidateObject(newObject);
        }
        this.mapping1.addMapping(pToEdge1.pointsTo(), newObject);
        this.mapping2.addMapping(pToEdge2.pointsTo(), newObject);
        SMGMapTargetAddress targetAddress = new SMGMapTargetAddress(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pValue1, pValue2);
        SMGJoinSubSMGs joinSubSMGs = new SMGJoinSubSMGs(this.status, this.inputSMG1, this.inputSMG2, targetAddress.destSMG, targetAddress.getMapping1(), targetAddress.getMapping2(), pToEdge1.pointsTo(), pToEdge2.pointsTo(), newObject, pNestingLevelDiff);
        if (!joinSubSMGs.isDefined) {
            this.setBottomState();
        } else {
            this.copyJoinState(joinSubSMGs);
            this.value = targetAddress.getValue();
        }
    }

    private SMGObject createNewObject(SMGObject obj1, SMGObject obj2) {
        int level = Integer.max(obj1.getNestingLevel(), obj2.getNestingLevel());
        SMGObject newObject = this.isDLLS(obj1) || this.isDLLS(obj2) ? this.createDLLSCopyLabeling(obj1, obj2, level) : SMGObject.of(level, obj1.getSize(), obj1.getOffset());
        this.destSMG = this.destSMG.copyAndAddObject(newObject);
        this.delayedJoin(this.mapping1.getMappedObject(obj1), newObject);
        this.delayedJoin(this.mapping2.getMappedObject(obj2), newObject);
        return newObject;
    }

    private SMGDoublyLinkedListSegment createDLLSCopyLabeling(SMGObject obj1, SMGObject obj2, int pNestingLevel) {
        int length1 = 0;
        int length2 = 0;
        BigInteger headOffset = null;
        BigInteger nextOffset = null;
        BigInteger prevOffset = null;
        BigInteger pSize = null;
        BigInteger pOffset = null;
        if (this.isDLLS(obj1)) {
            length1 = ((SMGDoublyLinkedListSegment)obj1).getMinLength();
            headOffset = ((SMGDoublyLinkedListSegment)obj1).getHeadOffset();
            nextOffset = ((SMGDoublyLinkedListSegment)obj1).getNextOffset();
            prevOffset = ((SMGDoublyLinkedListSegment)obj1).getPrevOffset();
            pSize = obj1.getSize();
            pOffset = obj1.getOffset();
        }
        if (this.isDLLS(obj2)) {
            length2 = ((SMGDoublyLinkedListSegment)obj2).getMinLength();
            if (headOffset == null) {
                headOffset = ((SMGDoublyLinkedListSegment)obj2).getHeadOffset();
                nextOffset = ((SMGDoublyLinkedListSegment)obj2).getNextOffset();
                prevOffset = ((SMGDoublyLinkedListSegment)obj2).getPrevOffset();
                pSize = obj2.getSize();
                pOffset = obj2.getOffset();
            }
        }
        return new SMGDoublyLinkedListSegment(pNestingLevel, pSize, pOffset, headOffset, nextOffset, prevOffset, Integer.min(length1, length2));
    }

    private void delayedJoin(SMGObject oldObject, SMGObject newObject) {
        if (oldObject == null) {
            return;
        }
        this.destSMG = this.destSMG.copyAndReplaceObject(oldObject, newObject);
    }

    private boolean checkForRecoverableFailure(SMGPointsToEdge pEdge1, SMGPointsToEdge pEdge2) {
        SMGObject targetObject1 = pEdge1.pointsTo();
        SMGObject targetObject2 = pEdge2.pointsTo();
        if (targetObject1.getClass().equals(targetObject2.getClass()) && !pEdge1.targetSpecifier().equals((Object)pEdge2.targetSpecifier())) {
            return true;
        }
        if (!targetObject1.getClass().equals(targetObject2.getClass()) && this.mapping1.getMappedObject(targetObject1).equals(this.mapping2.getMappedObject(targetObject1))) {
            return true;
        }
        SMGMatchObjects matchObjects = new SMGMatchObjects(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, targetObject1, targetObject2);
        return matchObjects.getStatus().equals((Object)SMGJoinStatus.INCOMPARABLE);
    }

    private boolean checkForJoinedTargetObjects(SMGObject obj1, SMGObject obj2) {
        return obj1.isZero() && obj1.equals(obj2) || this.checkMappings(obj1, obj2);
    }

    private boolean checkMappings(SMGObject obj1, SMGObject obj2) {
        SMGObject mapped1 = this.mapping1.getMappedObject(obj1);
        SMGObject mapped2 = this.mapping2.getMappedObject(obj2);
        return mapped1 != null && mapped2 != null && mapped1.equals(mapped2);
    }

    private boolean checkCompatibility(SMGPointsToEdge pToEdge1, SMGPointsToEdge pToEdge2, SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        if (pValue1.getNestingLevel() - pValue2.getNestingLevel() != pNestingLevelDiff) {
            return false;
        }
        return pToEdge1 != null && pToEdge2 != null && pToEdge1.getOffset().equals(pToEdge2.getOffset());
    }
}

