/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinTargetObjects;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinTest0;
import org.sosy_lab.cpachecker.util.smg.join.SMGMatchObjects;

public class SMGJoinTargetObjectsTest
extends SMGJoinTest0 {
    private SMG smg1;
    private SMG smg2;
    private SMG destSMG;
    private NodeMapping mapping1;
    private NodeMapping mapping2;
    private final SMGObject obj1 = this.createRegion(64);
    private final SMGValue value1 = this.createValue();
    private final SMGPointsToEdge pt1 = this.createPTRegionEdge(0, this.obj1);
    private final SMGObject obj2 = this.createRegion(64);
    private final SMGValue value2 = this.createValue();
    private final SMGPointsToEdge pt2 = this.createPTRegionEdge(0, this.obj2);
    private final SMGObject destObj = this.createRegion(64);

    @Before
    public void setUp() {
        this.smg1 = new SMG(mockType8bSize);
        this.smg2 = new SMG(mockType8bSize);
        this.destSMG = new SMG(mockType8bSize);
        this.mapping1 = new NodeMapping();
        this.mapping2 = new NodeMapping();
    }

    @Test
    public void matchingObjectsWithoutMappingTest() {
        this.smg1 = this.smg1.copyAndAddObject(this.obj1);
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg1 = this.smg1.copyAndAddPTEdge(this.pt1, this.value1);
        this.smg2 = this.smg2.copyAndAddObject(this.obj2);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smg2 = this.smg2.copyAndAddPTEdge(this.pt2, this.value2);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Comparable)jto.mapping2.getMappedObject(this.obj2)).isSameInstanceAs((Object)jto.mapping1.getMappedObject(this.obj1));
        Truth.assertThat((Comparable)jto.mapping1.getMappedObject(this.obj1)).isNotNull();
        Truth.assertThat((Comparable)this.obj1.getOffset()).isEqualTo((Object)jto.mapping1.getMappedObject(this.obj1).getOffset());
        Truth.assertThat((Comparable)this.obj1.getSize()).isEqualTo((Object)jto.mapping1.getMappedObject(this.obj1).getSize());
    }

    @Test
    public void nonMatchingObjectsTest() {
        this.smg1 = this.smg1.copyAndAddObject(this.obj1);
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg1 = this.smg1.copyAndAddPTEdge(this.pt1, this.value1);
        SMGMatchObjects mo = new SMGMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.obj1, SMGObject.nullInstance());
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, SMGValue.zeroValue(), 0);
        Truth.assertThat((Boolean)jto.isDefined()).isFalse();
        Truth.assertThat((Boolean)jto.isRecoverableFailur()).isTrue();
    }

    @Test
    public void joinTargetObjectsDifferentOffsets() {
        SMGPointsToEdge pt1null = this.createPTRegionEdge(2, SMGObject.nullInstance());
        SMGPointsToEdge pt2null = this.createPTRegionEdge(1, SMGObject.nullInstance());
        this.smg1 = this.smg1.copyAndAddObject(this.obj1);
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg1 = this.smg1.copyAndAddPTEdge(pt1null, this.value1);
        this.smg2 = this.smg2.copyAndAddObject(this.obj2);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smg2 = this.smg2.copyAndAddPTEdge(pt2null, this.value2);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jto.isDefined()).isFalse();
        Truth.assertThat((Boolean)jto.isRecoverableFailur()).isTrue();
    }

    @Test
    public void joinTargetObjectsAlreadyJoinedNull() {
        SMGPointsToEdge pt1null = this.createPTRegionEdge(0, SMGObject.nullInstance());
        SMGPointsToEdge pt2null = this.createPTRegionEdge(0, SMGObject.nullInstance());
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smg1 = this.smg1.copyAndAddPTEdge(pt1null, this.value1);
        this.smg2 = this.smg2.copyAndAddPTEdge(pt2null, this.value2);
        SMGJoinTargetObjects mta = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jto.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jto.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jto.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jto.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Object)jto.getDestinationSMG()).isEqualTo((Object)mta.getDestinationSMG());
        Truth.assertThat((Object)jto.mapping1).isEqualTo((Object)mta.mapping1);
        Truth.assertThat((Object)jto.mapping2).isEqualTo((Object)mta.mapping2);
        Truth.assertThat((Comparable)jto.getValue()).isEqualTo((Object)mta.getValue());
    }

    @Test
    public void joinTargetObjectsAlreadyJoinedNonNull() {
        this.smg1 = this.smg1.copyAndAddValue(this.value1);
        this.smg2 = this.smg2.copyAndAddValue(this.value2);
        this.smg1 = this.smg1.copyAndAddObject(this.obj1);
        this.smg2 = this.smg2.copyAndAddObject(this.obj2);
        this.destSMG = this.destSMG.copyAndAddObject(this.destObj);
        this.smg1 = this.smg1.copyAndAddPTEdge(this.pt1, this.value1);
        this.smg2 = this.smg2.copyAndAddPTEdge(this.pt2, this.value2);
        this.mapping1.addMapping(this.obj1, this.destObj);
        this.mapping2.addMapping(this.obj2, this.destObj);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2, 0);
        Truth.assertThat((Boolean)jto.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jto.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jto.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jto.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Boolean)jto.mapping1.hasMapping(this.value1)).isTrue();
        Truth.assertThat((Comparable)jto.getValue()).isEqualTo((Object)jto.mapping1.getMappedValue(this.value1));
        Truth.assertThat((Boolean)jto.mapping2.hasMapping(this.value2)).isTrue();
        Truth.assertThat((Comparable)jto.getValue()).isEqualTo((Object)jto.mapping2.getMappedValue(this.value2));
    }
}

