/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.smg.join;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.NodeMapping;
import org.sosy_lab.cpachecker.util.smg.join.SMGAbstractJoin;
import org.sosy_lab.cpachecker.util.smg.join.SMGInsertLeftDlsAndJoin;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinTargetObjects;

public class SMGJoinValues
extends SMGAbstractJoin {
    public SMGJoinValues(SMGJoinStatus pStatus, SMG pInputSMG1, SMG pInputSMG2, SMG pDestSMG, NodeMapping pMapping1, NodeMapping pMapping2, SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        super(pStatus, pInputSMG1, pInputSMG2, pDestSMG, pMapping1, pMapping2);
        this.joinValues(pValue1, pValue2, pNestingLevelDiff);
    }

    public void joinValues(SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        SMGValue mappingV2;
        if (pValue1.equals(pValue2)) {
            this.value = pValue1;
            return;
        }
        SMGValue mappingV1 = this.mapping1.getMappedValue(pValue1);
        if (this.valuesEqualsAndNotZero(mappingV1, mappingV2 = this.mapping2.getMappedValue(pValue2))) {
            this.value = mappingV1;
            return;
        }
        Optional<SMGPointsToEdge> edgeOptionalV1 = this.inputSMG1.getPTEdge(pValue1);
        Optional<SMGPointsToEdge> edgeOptionalV2 = this.inputSMG2.getPTEdge(pValue2);
        if (edgeOptionalV1.isEmpty() && edgeOptionalV2.isEmpty()) {
            this.joinNonPointerValues(pValue1, pValue2, pNestingLevelDiff);
        } else if (edgeOptionalV1.isEmpty() || edgeOptionalV2.isEmpty()) {
            this.setBottomState();
        } else {
            this.joinPointerValues(pValue1, pValue2, pNestingLevelDiff);
        }
    }

    public boolean isNullPointer(SMGPointsToEdge ptEdge) {
        return ptEdge == null || ptEdge.pointsTo().equals(SMGObject.nullInstance());
    }

    private void joinPointerValues(SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        SMGJoinTargetObjects joinTargetObjects = new SMGJoinTargetObjects(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pValue1, pValue2, pNestingLevelDiff);
        if (!joinTargetObjects.isDefined()) {
            this.setBottomState();
            return;
        }
        if (!joinTargetObjects.isRecoverableFailur()) {
            this.copyJoinState(joinTargetObjects);
            return;
        }
        Optional<SMGPointsToEdge> edgeOptionalV1 = this.inputSMG1.getPTEdge(pValue1);
        Optional<SMGPointsToEdge> edgeOptionalV2 = this.inputSMG2.getPTEdge(pValue2);
        Preconditions.checkArgument((edgeOptionalV1.isPresent() && edgeOptionalV2.isPresent() ? 1 : 0) != 0);
        SMGObject obj1 = edgeOptionalV1.orElseThrow().pointsTo();
        SMGObject obj2 = edgeOptionalV2.orElseThrow().pointsTo();
        if (obj1 instanceof SMGDoublyLinkedListSegment) {
            SMGInsertLeftDlsAndJoin jDlsAndJoin = new SMGInsertLeftDlsAndJoin(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pValue1, pValue2, pNestingLevelDiff);
            if (!jDlsAndJoin.isDefined()) {
                this.setBottomState();
                return;
            }
            if (!jDlsAndJoin.isRecoverableFailur()) {
                this.copyJoinState(joinTargetObjects);
                return;
            }
        }
        if (obj2 instanceof SMGDoublyLinkedListSegment) {
            SMGInsertLeftDlsAndJoin jrightDlsAndJoin = new SMGInsertLeftDlsAndJoin(this.status, this.inputSMG2, this.inputSMG1, this.destSMG, this.mapping2, this.mapping1, pValue2, pValue1, pNestingLevelDiff);
            if (!jrightDlsAndJoin.isDefined() || jrightDlsAndJoin.isRecoverableFailur()) {
                this.status = SMGJoinStatus.INCOMPARABLE;
                this.isDefined = jrightDlsAndJoin.isDefined;
                this.isRecoverableFailure = jrightDlsAndJoin.isRecoverableFailure;
                return;
            }
            this.copyJoinState(joinTargetObjects);
        }
    }

    private void joinNonPointerValues(SMGValue pValue1, SMGValue pValue2, int pNestingLevelDiff) {
        SMGValue mappingV1 = this.mapping1.getMappedValue(pValue1);
        SMGValue mappingV2 = this.mapping2.getMappedValue(pValue2);
        if (!this.isBottom(mappingV1, mappingV2)) {
            this.setBottomState();
            return;
        }
        int newLevel = Integer.max(pValue1.getNestingLevel(), pValue2.getNestingLevel());
        this.value = SMGValue.of(newLevel);
        this.mapping1.addMapping(pValue1, this.value);
        this.mapping2.addMapping(pValue2, this.value);
        int levelDiffV1AndV2 = pValue1.getNestingLevel() - pValue2.getNestingLevel();
        if (levelDiffV1AndV2 < pNestingLevelDiff) {
            this.status = this.status.updateWith(SMGJoinStatus.LEFT_ENTAIL);
        } else if (levelDiffV1AndV2 > pNestingLevelDiff) {
            this.status = this.status.updateWith(SMGJoinStatus.RIGHT_ENTAIL);
        }
        this.destSMG = this.destSMG.copyAndAddValue(this.value);
    }

    private boolean isBottom(SMGValue ... values) {
        for (SMGValue v : values) {
            if (v == null || v.isZero()) continue;
            return false;
        }
        return true;
    }

    private boolean valuesEqualsAndNotZero(SMGValue v1, SMGValue v2) {
        return v1 != null && v2 != null && !v1.isZero() && v1.equals(v2);
    }
}

